/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.blocks;

import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.entity.MagicalPredatorEntity;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import by.jackraidenph.dragonsurvival.registration.ItemsInit;
import by.jackraidenph.dragonsurvival.tiles.PredatorStarTileEntity;
import by.jackraidenph.dragonsurvival.util.DamageSources;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class PredatorStarBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public PredatorStarBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void blockBehaviour(Entity entity, World worldIn, BlockPos pos) {
        ItemEntity itemEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.func_70097_a(DamageSources.STAR_DRAIN, Float.MAX_VALUE);
            worldIn.func_175655_b(pos, false);
            Random random = new Random();
            if (random.nextDouble() < (Double)ConfigHandler.COMMON.predatorStarSpawnChance.get()) {
                MagicalPredatorEntity beast = (MagicalPredatorEntity)EntityTypesInit.MAGICAL_BEAST.func_200721_a(worldIn);
                worldIn.func_217376_c((Entity)beast);
                beast.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).func_92059_d().func_77973_b() == ItemsInit.elderDragonBone) {
            itemEntity.func_92058_a(new ItemStack((IItemProvider)ItemsInit.starBone));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PredatorStarTileEntity();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (!(entityIn instanceof MagicalPredatorEntity)) {
            this.blockBehaviour(entityIn, worldIn, pos);
        }
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (!((Boolean)ConfigHandler.SERVER.mineStarBlock.get()).booleanValue() || !player.func_184614_ca().getToolTypes().contains(ToolType.HOE) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) <= 0) {
            this.blockBehaviour((Entity)player, worldIn, pos);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.IGNORE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState state2, IWorld level, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            level.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(state, dir, state2, level, pos, pos2);
    }
}

