/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.capability;

import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;

public class DragonStateHandler {
    private boolean isHiding;
    private DragonType type = DragonType.NONE;
    private final DragonMovementData movementData = new DragonMovementData(0.0, 0.0, 0.0, false);
    private boolean hasWings;
    private float size;
    private final DragonDebuffData debuffData = new DragonDebuffData(0, 0);
    private int lavaAirSupply;
    private int passengerId;
    public static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("03574e62-f9e4-4f1b-85ad-fde00915e446");
    public static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("5bd3cebc-132e-4f9d-88ef-b686c7ad1e2c");
    public static final UUID SWIM_SPEED_MODIFIER_UUID = UUID.fromString("2a9341f3-d19e-446c-924b-7cf2e5259e10");

    public float getSize() {
        return this.size;
    }

    public void setSize(float size, PlayerEntity playerEntity) {
        this.setSize(size);
        AttributeModifier healthMod = DragonStateHandler.buildHealthMod(size);
        DragonStateHandler.updateHealthModifier(playerEntity, healthMod);
        AttributeModifier damageMod = DragonStateHandler.buildDamageMod(this.getLevel(), this.isDragon());
        DragonStateHandler.updateDamageModifier(playerEntity, damageMod);
        AttributeModifier swimSpeedMod = DragonStateHandler.buildSwimSpeedMod(this.getType());
        DragonStateHandler.updateSwimSpeedModifier(playerEntity, swimSpeedMod);
    }

    public void setSize(float size) {
        this.size = size;
    }

    public boolean hasWings() {
        return this.hasWings;
    }

    public void setHasWings(boolean hasWings) {
        this.hasWings = hasWings;
    }

    public boolean isDragon() {
        return this.type != DragonType.NONE;
    }

    public boolean isHiding() {
        return this.isHiding;
    }

    public void setIsHiding(boolean hiding) {
        this.isHiding = hiding;
    }

    public DragonLevel getLevel() {
        if (this.size < 20.0f) {
            return DragonLevel.BABY;
        }
        if (this.size < 30.0f) {
            return DragonLevel.YOUNG;
        }
        return DragonLevel.ADULT;
    }

    public boolean canHarvestWithPaw(BlockState state) {
        int harvestLevel = state.getHarvestLevel();
        switch (this.getLevel()) {
            case BABY: {
                if (ConfigHandler.SERVER.bonusUnlockedAt.get() != DragonLevel.BABY) {
                    if (harvestLevel > (Integer)ConfigHandler.SERVER.baseHarvestLevel.get()) break;
                    return true;
                }
            }
            case YOUNG: {
                if (ConfigHandler.SERVER.bonusUnlockedAt.get() == DragonLevel.ADULT && this.getLevel() != DragonLevel.BABY) {
                    if (harvestLevel > (Integer)ConfigHandler.SERVER.baseHarvestLevel.get()) break;
                    return true;
                }
            }
            case ADULT: {
                if (harvestLevel <= (Integer)ConfigHandler.SERVER.bonusHarvestLevel.get()) {
                    switch (this.getType()) {
                        case SEA: {
                            if (!state.isToolEffective(ToolType.SHOVEL)) break;
                            return true;
                        }
                        case CAVE: {
                            if (!state.isToolEffective(ToolType.PICKAXE)) break;
                            return true;
                        }
                        case FOREST: {
                            if (!state.isToolEffective(ToolType.AXE)) break;
                            return true;
                        }
                    }
                }
                if (harvestLevel > (Integer)ConfigHandler.SERVER.baseHarvestLevel.get()) break;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static AttributeModifier getHealthModifier(PlayerEntity player) {
        return Objects.requireNonNull(player.func_110148_a(Attributes.field_233818_a_)).func_111127_a(HEALTH_MODIFIER_UUID);
    }

    @Nullable
    public static AttributeModifier getDamageModifier(PlayerEntity player) {
        return Objects.requireNonNull(player.func_110148_a(Attributes.field_233823_f_)).func_111127_a(DAMAGE_MODIFIER_UUID);
    }

    @Nullable
    public static AttributeModifier getSwimSpeedModifier(PlayerEntity player) {
        return Objects.requireNonNull(player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get())).func_111127_a(SWIM_SPEED_MODIFIER_UUID);
    }

    public static AttributeModifier buildHealthMod(float size) {
        return new AttributeModifier(HEALTH_MODIFIER_UUID, "Dragon Health Adjustment", (double)((float)((Integer)ConfigHandler.SERVER.minHealth.get()).intValue() + (size - 14.0f) / 26.0f * ((float)((Integer)ConfigHandler.SERVER.maxHealth.get()).intValue() - (float)((Integer)ConfigHandler.SERVER.minHealth.get()).intValue()) - 20.0f), AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier buildDamageMod(DragonLevel level, boolean isDragon) {
        return new AttributeModifier(DAMAGE_MODIFIER_UUID, "Dragon Damage Adjustment", isDragon ? (level == DragonLevel.ADULT ? (Double)ConfigHandler.SERVER.adultBonusDamage.get() : (level == DragonLevel.YOUNG ? ((Double)ConfigHandler.SERVER.youngBonusDamage.get()).doubleValue() : ((Double)ConfigHandler.SERVER.babyBonusDamage.get()).doubleValue())) : 0.0, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier buildSwimSpeedMod(DragonType dragonType) {
        return new AttributeModifier(SWIM_SPEED_MODIFIER_UUID, "Dragon Swim Speed Adjustment", dragonType == DragonType.SEA && (Boolean)ConfigHandler.SERVER.seaSwimmingBonuses.get() != false ? 1.0 : 0.0, AttributeModifier.Operation.ADDITION);
    }

    public static void updateModifiers(PlayerEntity oldPlayer, PlayerEntity newPlayer) {
        AttributeModifier oldMod = DragonStateHandler.getHealthModifier(oldPlayer);
        if (oldMod != null) {
            DragonStateHandler.updateHealthModifier(newPlayer, oldMod);
        }
        if ((oldMod = DragonStateHandler.getDamageModifier(oldPlayer)) != null) {
            DragonStateHandler.updateDamageModifier(newPlayer, oldMod);
        }
        if ((oldMod = DragonStateHandler.getSwimSpeedModifier(oldPlayer)) != null) {
            DragonStateHandler.updateSwimSpeedModifier(newPlayer, oldMod);
        }
    }

    public static void updateHealthModifier(PlayerEntity player, AttributeModifier mod) {
        if (!((Boolean)ConfigHandler.SERVER.healthAdjustments.get()).booleanValue()) {
            return;
        }
        float oldMax = player.func_110138_aP();
        ModifiableAttributeInstance max = Objects.requireNonNull(player.func_110148_a(Attributes.field_233818_a_));
        max.func_111124_b(mod);
        max.func_233769_c_(mod);
        float newHealth = player.func_110143_aJ() * player.func_110138_aP() / oldMax;
        player.func_70606_j(newHealth);
    }

    public static void updateDamageModifier(PlayerEntity player, AttributeModifier mod) {
        if (!((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() || !((Boolean)ConfigHandler.SERVER.attackDamage.get()).booleanValue()) {
            return;
        }
        ModifiableAttributeInstance max = Objects.requireNonNull(player.func_110148_a(Attributes.field_233823_f_));
        max.func_111124_b(mod);
        max.func_233769_c_(mod);
    }

    public static void updateSwimSpeedModifier(PlayerEntity player, AttributeModifier mod) {
        if (!((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() || !((Boolean)ConfigHandler.SERVER.seaSwimmingBonuses.get()).booleanValue()) {
            return;
        }
        ModifiableAttributeInstance max = Objects.requireNonNull(player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()));
        max.func_111124_b(mod);
        max.func_233769_c_(mod);
    }

    public void setMovementData(double bodyYaw, double headYaw, double headPitch, boolean bite) {
        this.movementData.bodyYaw = bodyYaw;
        this.movementData.headYaw = headYaw;
        this.movementData.headPitch = headPitch;
        this.movementData.bite = bite;
    }

    public DragonMovementData getMovementData() {
        return this.movementData;
    }

    public void setDebuffData(int timeWithoutWater, int timeInDarkness) {
        this.debuffData.timeWithoutWater = timeWithoutWater;
        this.debuffData.timeInDarkness = timeInDarkness;
    }

    public DragonDebuffData getDebuffData() {
        return this.debuffData;
    }

    public DragonType getType() {
        return this.type;
    }

    public void setType(DragonType type) {
        this.type = type;
    }

    public int getLavaAirSupply() {
        return this.lavaAirSupply;
    }

    public void setLavaAirSupply(int lavaAirSupply) {
        this.lavaAirSupply = lavaAirSupply;
    }

    public int getPassengerId() {
        return this.passengerId;
    }

    public void setPassengerId(int passengerId) {
        this.passengerId = passengerId;
    }

    public static class DragonDebuffData {
        public int timeWithoutWater;
        public int timeInDarkness;

        public DragonDebuffData(int timeWithoutWater, int timeInDarkness) {
            this.timeWithoutWater = timeWithoutWater;
            this.timeInDarkness = timeInDarkness;
        }
    }

    public static class DragonMovementData {
        public double bodyYaw;
        public double headYaw;
        public double headPitch;
        public double headYawLastTick;
        public double headPitchLastTick;
        public double bodyYawLastTick;
        public boolean bite;

        public DragonMovementData(double bodyYaw, double headYaw, double headPitch, boolean bite) {
            this.bodyYaw = bodyYaw;
            this.headYaw = headYaw;
            this.headPitch = headPitch;
            this.headYawLastTick = headYaw;
            this.headPitchLastTick = headPitch;
            this.bodyYawLastTick = bodyYaw;
            this.bite = bite;
        }
    }
}

