/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.config;

import by.jackraidenph.dragonsurvival.config.DragonBodyMovementType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public final ForgeConfigSpec.ConfigValue<DragonBodyMovementType> firstPersonBodyMovement;
    public final ForgeConfigSpec.ConfigValue<DragonBodyMovementType> thirdPersonBodyMovement;
    public final ForgeConfigSpec.BooleanValue dragonNameTags;
    public final ForgeConfigSpec.BooleanValue renderInFirstPerson;
    public final ForgeConfigSpec.BooleanValue notifyWingStatus;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("client");
        this.renderInFirstPerson = builder.comment("Render dragon model in first person").define("renderFirstPerson", true);
        this.notifyWingStatus = builder.comment("Notifies of wing status in chat message").define("notifyWingStatus", true);
        builder.push("movement");
        this.firstPersonBodyMovement = builder.comment("The type of body movement you use while in first person as a dragon.").defineEnum("firstPersonMovement", (Enum)DragonBodyMovementType.VANILLA, (Enum[])DragonBodyMovementType.values());
        this.thirdPersonBodyMovement = builder.comment("The type of body movement you use while in third person as a dragon.").defineEnum("thirdPersonMovement", (Enum)DragonBodyMovementType.DRAGON, (Enum[])DragonBodyMovementType.values());
        builder.pop().push("nametag");
        this.dragonNameTags = builder.comment("Show name tags for dragons.").define("dragonNameTags", false);
        builder.pop();
    }
}

