/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.config;

import by.jackraidenph.dragonsurvival.util.BiomeDictionaryHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final ForgeConfigSpec.BooleanValue endVoidTeleport;
    public final ForgeConfigSpec.BooleanValue dragonsAllowedToUseElytra;
    public final ForgeConfigSpec.DoubleValue predatorDamageFactor;
    public final ForgeConfigSpec.DoubleValue predatorHealthFactor;
    public final ForgeConfigSpec.IntValue minPredatorSpawn;
    public final ForgeConfigSpec.IntValue maxPredatorSpawn;
    public final ForgeConfigSpec.IntValue predatorSpawnWeight;
    public final ForgeConfigSpec.DoubleValue predatorStarSpawnChance;
    public final ForgeConfigSpec.DoubleValue predatorAnimalSpawnChance;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> predatorBiomesInclude;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> predatorBiomesExclude;
    public final ForgeConfigSpec.DoubleValue knightHealth;
    public final ForgeConfigSpec.DoubleValue knightDamage;
    public final ForgeConfigSpec.DoubleValue knightArmor;
    public final ForgeConfigSpec.DoubleValue knightSpeed;
    public final ForgeConfigSpec.DoubleValue knightShieldChance;
    public final ForgeConfigSpec.DoubleValue houndHealth;
    public final ForgeConfigSpec.DoubleValue houndDamage;
    public final ForgeConfigSpec.DoubleValue houndSpeed;
    public final ForgeConfigSpec.BooleanValue houndDoesSlowdown;
    public final ForgeConfigSpec.DoubleValue hunterHealth;
    public final ForgeConfigSpec.DoubleValue hunterDamage;
    public final ForgeConfigSpec.DoubleValue hunterArmor;
    public final ForgeConfigSpec.DoubleValue hunterSpeed;
    public final ForgeConfigSpec.BooleanValue hunterHasBolas;
    public final ForgeConfigSpec.DoubleValue squireHealth;
    public final ForgeConfigSpec.DoubleValue squireDamage;
    public final ForgeConfigSpec.DoubleValue squireArmor;
    public final ForgeConfigSpec.DoubleValue squireSpeed;
    public final ForgeConfigSpec.DoubleValue princeHealth;
    public final ForgeConfigSpec.DoubleValue princeDamage;
    public final ForgeConfigSpec.DoubleValue princeArmor;
    public final ForgeConfigSpec.DoubleValue princeSpeed;
    public final ForgeConfigSpec.IntValue hunterDespawnDelay;
    public final ForgeConfigSpec.IntValue princessDespawnDelay;
    public final ForgeConfigSpec.IntValue hunterSpawnDelay;
    public final ForgeConfigSpec.IntValue princessSpawnDelay;
    public final ForgeConfigSpec.BooleanValue spawnKnight;
    public final ForgeConfigSpec.BooleanValue spawnSquire;
    public final ForgeConfigSpec.BooleanValue spawnHunter;
    public final ForgeConfigSpec.BooleanValue spawnHound;
    public final ForgeConfigSpec.IntValue xpGain;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> evilDragonStatusGivers;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("common");
        builder.push("general");
        this.endVoidTeleport = builder.comment("Should the player be teleported to the overworld when they fall in the end?").define("endVoidTeleport", true);
        this.dragonsAllowedToUseElytra = builder.comment("Whether dragons are allowed to use Elytra").define("elytraForDragon", false);
        builder.pop().push("predator");
        this.predatorDamageFactor = builder.defineInRange("predatorDamageFactor", 0.5, 0.5, 10.0);
        this.predatorHealthFactor = builder.defineInRange("predatorHealthFactor", 0.2, 0.2, 5.0);
        builder.push("spawnChances");
        this.minPredatorSpawn = builder.defineInRange("minimum", 0, 0, 64);
        this.maxPredatorSpawn = builder.defineInRange("maximum", 1, 0, 64);
        this.predatorSpawnWeight = builder.comment("Set weight to 0 to disable spawning.").defineInRange("weight", 2, 0, 100);
        this.predatorStarSpawnChance = builder.comment("Chance for predators to spawn from stars. Set to 0.0 to disable.").defineInRange("starSpawnChance", 0.3, 0.0, 1.0);
        this.predatorAnimalSpawnChance = builder.comment("Chance for predators to spawn when an animal dies. Set to 0.0 to disable.").defineInRange("animalSpawnChance", 0.03, 0.0, 1.0);
        builder.pop().push("spawnBiomes");
        this.predatorBiomesInclude = builder.comment("The predator can only spawn in biomes with the included types.").defineList("include", Collections.singletonList(BiomeDictionary.Type.END.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
        this.predatorBiomesExclude = builder.comment("The predator cannot spawn in biomes with excluded types.").defineList("exclude", Arrays.asList(BiomeDictionary.Type.OVERWORLD.toString(), BiomeDictionary.Type.NETHER.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
        builder.pop();
        builder.pop().push("dragonHunters");
        this.princessDespawnDelay = builder.comment("Princess or prince may despawn after this many minutes").defineInRange("princessDespawnDelay", 15, 1, 120);
        this.hunterDespawnDelay = builder.comment("Any dragon hunter may despawn after this many minutes").defineInRange("hunterDespawnDelay", 15, 1, 120);
        this.princessSpawnDelay = builder.comment("Minimum delay between prince or princess spawning, in minutes").defineInRange("princessSpawnDelay", 120, 10, 240);
        this.hunterSpawnDelay = builder.comment("Minimum delay between Dragon hunter group spawning, in minutes").defineInRange("hunterGroupSpawnDelay", 20, 12, 240);
        this.spawnKnight = builder.comment("Dragon knight spawning enabled?").define("allowKnightSpawning", true);
        this.spawnSquire = builder.comment("Dragon Squire spawning enabled?").define("allowSquireSpawning", true);
        this.spawnHunter = builder.comment("Dragon Hunter spawning enabled?").define("allowHunterSpawning", true);
        this.spawnHound = builder.comment("Dragon Knight hound spawning enabled?").define("allowHoundSpawning", true);
        this.xpGain = builder.comment("How many experience points are gained for killing a villager").defineInRange("villagerKillxp", 10, 10, 1000);
        this.evilDragonStatusGivers = builder.comment("Entities which give 'Evil dragon' status on death").defineList("evilDragonStatusGivers", () -> Arrays.asList("minecraft:villager", "dragonsurvival:hunter_hound", "dragonsurvival:knight", "dragonsurvival:shooter", "dragonsurvival:squire", "dragonsurvival:prince", "dragonsurvival:princess", "dragonsurvival:princess_entity"), o -> EntityType.func_220327_a((String)((String)o)).isPresent());
        builder.push("knight");
        this.knightHealth = builder.comment("Dragon Knight health").defineInRange("knightHealth", 40.0, 10.0, 80.0);
        this.knightDamage = builder.comment("Dragon Knight base damage").defineInRange("knightDamage", 12.0, 1.0, 32.0);
        this.knightArmor = builder.comment("Dragon Knight armor").defineInRange("knightArmor", 10.0, 0.0, 30.0);
        this.knightSpeed = builder.comment("Dragon Knight speed").defineInRange("knightSpeed", 0.35, 0.1, 0.6);
        this.knightShieldChance = builder.comment("Chance of having shield").defineInRange("knightShieldChance", 0.1, 0.0, 1.0);
        builder.pop().push("hound");
        this.houndHealth = builder.comment("Knight Hound health").defineInRange("houndHealth", 10.0, 8.0, 40.0);
        this.houndDamage = builder.comment("Knight Hound damage").defineInRange("houndDamage", 2.0, 1.0, 10.0);
        this.houndSpeed = builder.comment("Knight Hound speed").defineInRange("houndSpeed", 0.45, 0.1, 0.6);
        this.houndDoesSlowdown = builder.comment("Does Knight Hound apply speed slowdown?").define("houndDoesSlowdown", true);
        builder.pop().push("hunter");
        this.hunterHealth = builder.comment("Dragon Hunter health").defineInRange("hunterHealth", 24.0, 10.0, 60.0);
        this.hunterDamage = builder.comment("Dragon Hunter damage").defineInRange("hunterDamage", 5.0, 2.0, 20.0);
        this.hunterSpeed = builder.comment("Dragon Hunter speed").defineInRange("hunterSpeed", 0.35, 0.1, 0.6);
        this.hunterArmor = builder.comment("Dragon Hunter armor").defineInRange("hunterArmor", 0.0, 0.0, 20.0);
        this.hunterHasBolas = builder.comment("Is Dragon hunter able to throw a bolas?").define("hunterThrowsBolas", true);
        builder.pop().push("squire");
        this.squireHealth = builder.comment("Dragon Squire health").defineInRange("squireHealth", 24.0, 10.0, 60.0);
        this.squireDamage = builder.comment("Dragon Squire damage").defineInRange("squireDamage", 6.0, 2.0, 20.0);
        this.squireSpeed = builder.comment("Dragon Squire speed").defineInRange("squireSpeed", 0.35, 0.1, 0.6);
        this.squireArmor = builder.comment("Dragon Squire armor").defineInRange("squireArmor", 2.0, 0.0, 20.0);
        builder.pop().push("prince");
        this.princeHealth = builder.comment("Prince health").defineInRange("princeHealth", 20.0, 10.0, 60.0);
        this.princeDamage = builder.comment("Prince base damage").defineInRange("princeDamage", 1.0, 1.0, 20.0);
        this.princeSpeed = builder.comment("Prince speed").defineInRange("princeSpeed", 0.3, 0.2, 0.6);
        this.princeArmor = builder.comment("Prince armor").defineInRange("princeArmor", 6.0, 0.0, 20.0);
        builder.pop();
    }
}

