/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.entity;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.network.PacketSyncXPDevour;
import by.jackraidenph.dragonsurvival.registration.BlockInit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class MagicalPredatorEntity
extends MonsterEntity {
    public int field_200606_g;
    public float size;
    private final float scale;
    private boolean deathStar;
    private int teleportationCooldown;

    public MagicalPredatorEntity(EntityType<? extends MonsterEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_200606_g = worldIn.func_201674_k().nextInt(10);
        this.size = worldIn.func_201674_k().nextFloat() + 0.95f;
        this.scale = this.size / this.func_213302_cg();
        this.deathStar = false;
    }

    private static int getActualDistance(PlayerEntity player) {
        AtomicInteger distance = new AtomicInteger();
        if (player != null) {
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (cap.isDragon() && !cap.isHiding()) {
                    distance.set(30);
                } else if (cap.isDragon()) {
                    distance.set(18);
                } else {
                    distance.set(10);
                }
            });
        }
        return distance.get();
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 19 && !this.deathStar) {
            this.deathStar = true;
            for (int i = 1; i < 10; ++i) {
                for (int r = 0; r < 5; ++r) {
                    BlockPos blockpos = this.func_233580_cy_().func_177982_a(this.field_70170_p.field_73012_v.nextInt(i) - this.field_70170_p.field_73012_v.nextInt(i), this.field_70170_p.field_73012_v.nextInt(i) - this.field_70170_p.field_73012_v.nextInt(i), this.field_70170_p.field_73012_v.nextInt(i) - this.field_70170_p.field_73012_v.nextInt(i));
                    if (!this.field_70170_p.func_180495_p(blockpos).getBlockState().func_227032_a_((Fluid)Fluids.field_204547_b) || this.field_70170_p.func_230318_c_(null, new AxisAlignedBB(blockpos), entity -> entity instanceof LivingEntity).count() != 0L) continue;
                    if (this.field_70170_p.field_72995_K) {
                        this.func_70656_aK();
                    } else {
                        BlockState starState = BlockInit.PREDATOR_STAR_BLOCK.func_176223_P();
                        starState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(this.field_70170_p.func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a));
                        if (!this.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76224_d()) {
                            this.field_70170_p.func_175655_b(blockpos, true);
                        }
                        this.field_70170_p.func_175656_a(blockpos, starState);
                    }
                    return;
                }
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)this.field_70170_p.func_201674_k().nextFloat() * 1.25 - 0.75, this.func_226278_cu_() + (double)(this.func_213302_cg() / 1.5f * this.scale), this.func_226281_cx_() + (double)this.field_70170_p.func_201674_k().nextFloat() * 1.25 - 0.75, 0.0, (double)(this.field_70170_p.func_201674_k().nextFloat() / 12.5f), 0.0);
        if (this.teleportationCooldown > 0) {
            --this.teleportationCooldown;
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (worldIn.func_201674_k().nextInt(10) == 0) {
            SkeletonEntity skeletonentity = (SkeletonEntity)EntityType.field_200741_ag.func_200721_a(this.field_70170_p);
            skeletonentity.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            skeletonentity.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
            worldIn.func_217376_c((Entity)skeletonentity);
            skeletonentity.func_184220_m((Entity)this);
        }
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("healthBoost", (double)this.scale, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("damageBoost", (double)this.scale, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233824_g_).func_233769_c_(new AttributeModifier("attackBoost", (double)this.scale, AttributeModifier.Operation.MULTIPLY_BASE));
        return spawnDataIn;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new DevourXP(this.field_70170_p, this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new IsNearestDragonTargetGoal((MobEntity)this, true));
    }

    public double func_70042_X() {
        return (double)(this.func_213302_cg() * this.scale) * 0.75;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("teleportationCooldown", this.teleportationCooldown);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.teleportationCooldown = compound.func_74762_e("teleportationCooldown");
    }

    public static AttributeModifierMap.MutableAttribute createMonsterAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.375).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233823_f_, 2.0 * (Double)ConfigHandler.COMMON.predatorDamageFactor.get()).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233818_a_, 29.5 * (Double)ConfigHandler.COMMON.predatorHealthFactor.get());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() instanceof LivingEntity) {
            this.teleportationCooldown = 30;
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70652_k(Entity target) {
        if (!super.func_70652_k(target)) {
            return false;
        }
        this.teleportationCooldown = 30;
        return true;
    }

    private void teleportToEntity(Entity p_70816_1_) {
        Vector3d vec = p_70816_1_.func_213303_ch().func_178788_d(p_70816_1_.func_70040_Z().func_216372_d(2.0, 1.0, 2.0));
        double d1 = vec.func_82615_a();
        double d2 = 256.0;
        double d3 = vec.func_82616_c();
        this._teleportTo(d1, d2, d3);
    }

    private void _teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        this.attemptTeleport(x, y, z, true);
        if (flag && !flag1) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    public boolean attemptTeleport(double p_213373_1_, double p_213373_3_, double p_213373_5_, boolean p_213373_7_) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        double d3 = p_213373_3_;
        boolean flag = false;
        BlockPos blockpos = new BlockPos(p_213373_1_, p_213373_3_, p_213373_5_);
        World world = this.field_70170_p;
        boolean flag1 = false;
        while (!flag1 && blockpos.func_177956_o() > 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate = world.func_180495_p(blockpos1);
            if (blockstate.func_185904_a().func_76230_c()) {
                flag1 = true;
            } else {
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (!flag1) continue;
            this.func_70634_a(p_213373_1_, d3, p_213373_5_);
            if (!world.func_226669_j_((Entity)this)) continue;
            flag = true;
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        if (p_213373_7_) {
            world.func_72960_a((Entity)this, (byte)46);
        }
        this.func_70661_as().func_75499_g();
        return true;
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final MagicalPredatorEntity beast;

        public FindPlayerGoal(MagicalPredatorEntity beastIn) {
            super((MobEntity)beastIn, PlayerEntity.class, false);
            this.beast = beastIn;
        }

        protected AxisAlignedBB func_188511_a(double p_188511_1_) {
            PlayerEntity player = (PlayerEntity)this.field_75309_a;
            return this.field_75299_d.func_174813_aQ().func_186662_g((double)MagicalPredatorEntity.getActualDistance(player));
        }

        public void func_75246_d() {
            float diff;
            if (this.field_75309_a != null && this.field_75309_a instanceof PlayerEntity && this.beast.teleportationCooldown == 0 && (diff = (float)MagicalPredatorEntity.getActualDistance((PlayerEntity)this.field_75309_a) - this.beast.func_70032_d((Entity)this.field_75309_a)) <= 16.0f & diff >= -2.0f) {
                this.beast.teleportToEntity((Entity)this.field_75309_a);
                this.beast.teleportationCooldown = 10;
            }
        }
    }

    static class IsNearestDragonTargetGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public IsNearestDragonTargetGoal(MobEntity p_i50313_1_, boolean p_i50313_3_) {
            super(p_i50313_1_, PlayerEntity.class, p_i50313_3_);
        }

        protected AxisAlignedBB func_188511_a(double p_188511_1_) {
            PlayerEntity player = (PlayerEntity)this.field_75309_a;
            return this.field_75299_d.func_174813_aQ().func_186662_g((double)MagicalPredatorEntity.getActualDistance(player));
        }
    }

    static class DevourXP
    extends Goal {
        World world;
        MagicalPredatorEntity entity;

        public DevourXP(World worldIn, MagicalPredatorEntity entityIn) {
            this.world = worldIn;
            this.entity = entityIn;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            this.world.func_217394_a(EntityType.field_200807_u, this.entity.func_174813_aQ().func_186662_g(4.0), Objects::nonNull).forEach(xpOrb -> DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PacketSyncXPDevour(this.entity.func_145782_y(), xpOrb.func_145782_y())));
            super.func_75246_d();
        }
    }
}

