/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.entity;

import by.jackraidenph.dragonsurvival.Functions;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.entity.BolasEntity;
import by.jackraidenph.dragonsurvival.entity.Hunter;
import by.jackraidenph.dragonsurvival.entity.HunterHound;
import by.jackraidenph.dragonsurvival.entity.Squire;
import by.jackraidenph.dragonsurvival.gecko.Knight;
import by.jackraidenph.dragonsurvival.goals.AlertExceptHunters;
import by.jackraidenph.dragonsurvival.goals.CrossbowAttackGoal;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class Shooter
extends Hunter
implements ICrossbowUser {
    private static final DataParameter<Boolean> IS_CHARGING_CROSSBOW = EntityDataManager.func_187226_a(Shooter.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected int bolasCooldown = Functions.secondsToTicks(30);

    public Shooter(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, new CrossbowAttackGoal<Shooter>(this, 1.0, 8.0f));
        this.field_70714_bg.func_75776_a(8, new AlertExceptHunters<Shooter>(this, HunterHound.class, Knight.class, Squire.class));
    }

    public void func_213671_a(boolean p_213671_1_) {
        this.field_70180_af.func_187227_b(IS_CHARGING_CROSSBOW, (Object)p_213671_1_);
    }

    public void func_230284_a_(LivingEntity p_230284_1_, ItemStack p_230284_2_, ProjectileEntity p_230284_3_, float p_230284_4_) {
        this.func_234279_a_((LivingEntity)this, p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
        ItemStack crossbow = this.func_184586_b(Hand.MAIN_HAND);
        this.addArrow(crossbow);
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        this.func_234281_b_((LivingEntity)this, 1.6f);
    }

    @Override
    public void func_70071_h_() {
        LivingEntity target;
        super.func_70071_h_();
        if (((Boolean)ConfigHandler.COMMON.hunterHasBolas.get()).booleanValue() && (target = this.func_70638_az()) instanceof PlayerEntity && DragonStateProvider.isDragon((Entity)target)) {
            if (this.bolasCooldown == 0) {
                this.performBolasThrow(target);
                this.bolasCooldown = Functions.secondsToTicks(15);
            } else {
                --this.bolasCooldown;
            }
        }
    }

    public void performBolasThrow(LivingEntity target) {
        BolasEntity bolas = new BolasEntity((LivingEntity)this, this.field_70170_p);
        double d0 = target.func_226280_cw_() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - bolas.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        bolas.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187924_gx, 1.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)bolas);
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Bolas cooldown", this.bolasCooldown);
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.bolasCooldown = compoundNBT.func_74762_e("Bolas cooldown");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHARGING_CROSSBOW);
    }

    @Override
    public AbstractIllagerEntity.ArmPose getArmPose() {
        if (this.isChargingCrossbow()) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_CHARGE;
        }
        if (this.func_233634_a_(item -> item instanceof CrossbowItem)) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_HOLD;
        }
        return this.func_213398_dR() ? AbstractIllagerEntity.ArmPose.ATTACKING : AbstractIllagerEntity.ArmPose.NEUTRAL;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_222114_py);
        this.addArrow(stack);
        this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
    }

    private void addArrow(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        ListNBT listNBT = compoundNBT.func_150295_c("ChargedProjectiles", 10);
        CompoundNBT nbt = new CompoundNBT();
        new ItemStack((IItemProvider)Items.field_151032_g).func_77955_b(nbt);
        listNBT.add((Object)nbt);
        compoundNBT.func_218657_a("ChargedProjectiles", (INBT)listNBT);
    }
}

