/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gecko;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import by.jackraidenph.dragonsurvival.handlers.DragonSizeHandler;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DragonEntity
extends LivingEntity
implements IAnimatable {
    AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    public boolean isArmorModel;
    public volatile int player;

    public DragonEntity(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> animationEvent) {
        PlayerEntity player = this.getPlayer();
        AnimationController animationController = animationEvent.getController();
        AnimationBuilder builder = new AnimationBuilder();
        if (player != null) {
            DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
                boolean isMovingHorizontal;
                Vector3d motio = new Vector3d(player.func_226277_ct_() - player.field_70169_q, player.func_226278_cu_() - player.field_70167_r, player.func_226281_cx_() - player.field_70166_s);
                boolean bl = isMovingHorizontal = Math.sqrt(Math.pow(motio.field_72450_a, 2.0) + Math.pow(motio.field_72449_c, 2.0)) > 0.005;
                if (player.func_70608_bn()) {
                    builder.addAnimation("sleep", Boolean.valueOf(true));
                } else if (player.func_184218_aH()) {
                    builder.addAnimation("sit", Boolean.valueOf(true));
                } else if (player.func_184218_aH()) {
                    builder.addAnimation("idle", Boolean.valueOf(true));
                } else if (playerStateHandler.getMovementData().bite) {
                    builder.addAnimation("bite");
                } else if (player.func_213283_Z() == Pose.SWIMMING) {
                    builder.addAnimation("swim_fast", Boolean.valueOf(true));
                } else if ((player.func_180799_ab() || player.func_203005_aq()) && !player.func_233570_aj_()) {
                    builder.addAnimation("swim", Boolean.valueOf(true));
                } else if ((player.field_71075_bZ.field_75100_b || ClientEvents.dragonsFlying.getOrDefault(player.func_145782_y(), false).booleanValue()) && !player.func_233570_aj_() && !player.func_70090_H() && !player.func_180799_ab() && ((DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).hasWings()) {
                    builder.addAnimation("fly", Boolean.valueOf(true));
                } else if (!player.func_233570_aj_() && motio.func_82617_b() < 0.0) {
                    builder.addAnimation("land", Boolean.valueOf(false));
                    builder.addAnimation("idle", Boolean.valueOf(true));
                } else if (ClientEvents.dragonsJumpingTicks.getOrDefault(this.player, 0) > 0) {
                    builder.addAnimation("jump", Boolean.valueOf(false));
                } else if (player.func_225608_bj_() || !DragonSizeHandler.canPoseFit((LivingEntity)player, Pose.STANDING) && DragonSizeHandler.canPoseFit((LivingEntity)player, Pose.CROUCHING)) {
                    if (isMovingHorizontal && player.field_70721_aZ != 0.0f) {
                        builder.addAnimation("sneak_walk", Boolean.valueOf(true));
                    } else if (ClientEvents.dragonsDigging.getOrDefault(this.player, false).booleanValue()) {
                        builder.addAnimation("dig_sneak", Boolean.valueOf(true));
                    } else {
                        builder.addAnimation("sneak", Boolean.valueOf(true));
                    }
                } else if (player.func_70051_ag()) {
                    builder.addAnimation("run", Boolean.valueOf(true));
                } else if (isMovingHorizontal && player.field_70721_aZ != 0.0f) {
                    builder.addAnimation("walk", Boolean.valueOf(true));
                } else if (ClientEvents.dragonsDigging.getOrDefault(this.player, false).booleanValue()) {
                    builder.addAnimation("dig", Boolean.valueOf(true));
                } else {
                    builder.addAnimation("idle", Boolean.valueOf(true));
                }
            });
        } else {
            builder.addAnimation("idle", Boolean.valueOf(true));
        }
        animationController.setAnimation(builder);
        return PlayState.CONTINUE;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    PlayerEntity getPlayer() {
        return (PlayerEntity)Minecraft.func_71410_x().field_71439_g.field_213837_d.func_73045_a(this.player);
    }
}

