/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gecko;

import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.AnimationProcessor;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.file.AnimationFile;
import software.bernie.geckolib3.geo.exception.GeckoLibException;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class DragonModel
extends AnimatedGeoModel<DragonEntity> {
    private ResourceLocation currentTexture = new ResourceLocation("dragonsurvival", "textures/dragon/cave_newborn.png");
    public IBone neck;
    public IBone neck1;
    public IBone neck2;
    public IBone neck3;
    public IBone neck4;
    public IBone head;
    private boolean hasBones;
    private int biteTicks;

    public void setupBones() {
        if (this.hasBones || this.getAnimationProcessor().getModelRendererList().size() == 0) {
            return;
        }
        AnimationProcessor ap = this.getAnimationProcessor();
        this.neck = ap.getBone("Neck");
        this.neck1 = ap.getBone("Neck1");
        this.neck2 = ap.getBone("Neck2");
        this.neck3 = ap.getBone("Neck3");
        this.neck4 = ap.getBone("Neck4");
        this.head = ap.getBone("Head");
        this.hasBones = true;
    }

    public ResourceLocation getModelLocation(DragonEntity dragonEntity) {
        return new ResourceLocation("dragonsurvival", "geo/dragon_model.geo.json");
    }

    public void setCurrentTexture(ResourceLocation currentTexture) {
        this.currentTexture = currentTexture;
    }

    public ResourceLocation getTextureLocation(DragonEntity dragonEntity) {
        return this.currentTexture;
    }

    public Animation getAnimation(String name, IAnimatable animatable) {
        DragonEntity dragonEntity = (DragonEntity)animatable;
        ResourceLocation animLocation = new ResourceLocation("dragonsurvival", "animations/dragon.animations.json");
        AnimationFile animation = (AnimationFile)GeckoLibCache.getInstance().getAnimations().get(animLocation);
        if (animation == null) {
            throw new GeckoLibException(animLocation, "Could not find animation file. Please double check name.");
        }
        return animation.getAnimation(name);
    }

    public ResourceLocation getAnimationFileLocation(DragonEntity animatable) {
        return null;
    }

    public void setLivingAnimations(DragonEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        if (customPredicate.getController() == null || !this.hasBones) {
            return;
        }
        PlayerEntity player = entity.getPlayer();
        if (!player.func_70608_bn() && !player.func_184218_aH()) {
            DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
                float rotation = -1.0f * ((float)playerStateHandler.getMovementData().bodyYaw - (float)playerStateHandler.getMovementData().headYaw) * (float)Math.PI / 180.0f;
                if (rotation > (float)Math.PI) {
                    rotation = (float)Math.PI;
                }
                if (rotation < (float)(-Math.PI)) {
                    rotation = (float)(-Math.PI);
                }
                this.neck.setRotationY(-0.125f * rotation);
                this.neck4.setRotationZ(0.0555556f * rotation);
                this.neck3.setRotationX((rotation >= 0.0f ? -1.0f : 1.0f) * 0.06944f * rotation + 0.523599f);
                this.neck3.setRotationY(-0.083333f * rotation);
                this.neck3.setRotationZ(-0.166667f * rotation);
                this.neck3.setPositionX(0.07957f * rotation);
                this.neck2.setRotationX((rotation >= 0.0f ? -1.0f : 1.0f) * 0.0502222f * rotation + 0.523599f);
                this.neck2.setRotationY(-0.0277778f * rotation);
                this.neck2.setRotationZ(-0.1975f * rotation);
                this.neck2.setPositionY(-1.0f * (rotation >= 0.0f ? -1.0f : 1.0f) * 0.2387324f * rotation);
                this.neck1.setRotationX((rotation >= 0.0f ? -1.0f : 1.0f) * 0.02777763f * rotation + 0.174533f);
                this.neck1.setRotationY(-0.0972222f * rotation);
                this.neck1.setRotationZ(-0.1666667f * rotation);
                this.neck1.setPositionX(-0.0795775f * rotation);
                this.neck1.setPositionY(-1.0f * (rotation >= 0.0f ? -1.0f : 1.0f) * -0.0795775f * rotation);
                this.head.setRotationX((rotation >= 0.0f ? -1.0f : 1.0f) * -0.2189445f * rotation + 0.349066f);
                this.head.setRotationY(-0.1944444f * rotation);
                this.head.setRotationZ(-0.3055555f * rotation);
                this.head.setPositionX(-0.716197f * rotation);
                this.head.setPositionY(-1.0f * (rotation >= 0.0f ? -1.0f : 1.0f) * -0.397887f * rotation);
                this.head.setPositionZ((rotation >= 0.0f ? 1.0f : -1.0f) * -0.397887f * rotation);
            });
        }
    }
}

