/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gecko;

import by.jackraidenph.dragonsurvival.Functions;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.entity.DragonHunter;
import by.jackraidenph.dragonsurvival.entity.Shooter;
import by.jackraidenph.dragonsurvival.gecko.AnimationTimer;
import by.jackraidenph.dragonsurvival.gecko.CommonTraits;
import by.jackraidenph.dragonsurvival.registration.DragonEffects;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Knight
extends CreatureEntity
implements IAnimatable,
DragonHunter,
CommonTraits {
    AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    AnimationTimer animationTimer = new AnimationTimer();

    public Knight(EntityType<? extends CreatureEntity> p_i48576_1_, World world) {
        super(p_i48576_1_, world);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "everything", 3.0f, event -> {
            String name;
            Animation animation;
            AnimationBuilder animationBuilder = new AnimationBuilder();
            AnimationController animationController = event.getController();
            double movement = this.getMovementSpeed((LivingEntity)this);
            if (this.field_110158_av > 0 && (animation = animationController.getCurrentAnimation()) != null) {
                switch (name = animation.animationName) {
                    case "attack": {
                        this.animationTimer.trackAnimation("attack");
                        if (this.animationTimer.getDuration("attack2") > 0) break;
                        if (this.field_70146_Z.nextBoolean()) {
                            this.animationTimer.putAnimation("attack", 17, animationBuilder);
                            break;
                        }
                        this.animationTimer.putAnimation("attack2", 17, animationBuilder);
                        break;
                    }
                    case "attack2": {
                        this.animationTimer.trackAnimation("attack2");
                        if (this.animationTimer.getDuration("attack") > 0) break;
                        if (this.field_70146_Z.nextBoolean()) {
                            this.animationTimer.putAnimation("attack", 17, animationBuilder);
                            break;
                        }
                        this.animationTimer.putAnimation("attack2", 17, animationBuilder);
                        break;
                    }
                    default: {
                        if (this.field_70146_Z.nextBoolean()) {
                            this.animationTimer.putAnimation("attack", 17, animationBuilder);
                            break;
                        }
                        this.animationTimer.putAnimation("attack2", 17, animationBuilder);
                    }
                }
            }
            if (movement > 0.4) {
                animationBuilder.addAnimation("run");
            } else if (movement > 0.1) {
                animationBuilder.addAnimation("walk");
            } else {
                animation = animationController.getCurrentAnimation();
                if (animation == null) {
                    this.animationTimer.putAnimation("idle", 88, animationBuilder);
                } else {
                    switch (name = animation.animationName) {
                        case "idle": {
                            this.animationTimer.trackAnimation("idle");
                            if (this.animationTimer.getDuration("idle") > 0 || this.field_70146_Z.nextInt(2000) != 0) break;
                            this.animationTimer.putAnimation("idle_2", 145, animationBuilder);
                            break;
                        }
                        case "walk": 
                        case "run": {
                            this.animationTimer.putAnimation("idle", 88, animationBuilder);
                            break;
                        }
                        case "idle_2": {
                            this.animationTimer.trackAnimation("idle_2");
                            if (this.animationTimer.getDuration("idle_2") > 0) break;
                            this.animationTimer.putAnimation("idle", 88, animationBuilder);
                        }
                    }
                }
            }
            animationController.setAnimation(animationBuilder);
            return PlayState.CONTINUE;
        }));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 1, true, false, livingEntity -> livingEntity.func_70644_a(Effects.field_220309_E) || livingEntity.func_70644_a(DragonEffects.EVIL_DRAGON)));
        this.field_70715_bh.func_75776_a(6, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{Shooter.class}).func_220794_a(new Class[0]));
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151040_l));
        if (this.field_70146_Z.nextDouble() < (Double)ConfigHandler.COMMON.knightShieldChance.get()) {
            ItemStack itemStack = new ItemStack((IItemProvider)Items.field_185159_cQ);
            ListNBT listNBT = Functions.createRandomPattern(new BannerPattern.Builder(), 16);
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("Base", DyeColor.values()[this.field_70146_Z.nextInt(DyeColor.values().length)].func_196059_a());
            compoundNBT.func_218657_a("Patterns", (INBT)listNBT);
            itemStack.func_77983_a("BlockEntityTag", (INBT)compoundNBT);
            this.func_184611_a(Hand.OFF_HAND, itemStack);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld serverWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT nbt) {
        this.func_180481_a(difficultyInstance);
        return super.func_213386_a(serverWorld, difficultyInstance, spawnReason, entityData, nbt);
    }

    public void func_70071_h_() {
        this.func_82168_bl();
        super.func_70071_h_();
    }

    public boolean func_184585_cz() {
        return this.field_70146_Z.nextBoolean();
    }

    public boolean func_213397_c(double distance) {
        return this.field_70173_aa >= Functions.minutesToTicks((Integer)ConfigHandler.COMMON.hunterDespawnDelay.get());
    }
}

