/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gui;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.handlers.DragonFoodHandler;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class DragonAltarGUI
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("dragonsurvival", "textures/gui/dragon_altar_texture.png");
    private int guiLeft;
    private int guiTop;

    public DragonAltarGUI(ITextComponent title) {
        super(title);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_ == null) {
            return;
        }
        this.func_230446_a_(matrixStack);
        int startX = this.guiLeft;
        int startY = this.guiTop;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        DragonAltarGUI.func_238463_a_((MatrixStack)matrixStack, (int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)215, (int)158, (int)512, (int)512);
        if (mouseY > startY + 6 && mouseY < startY + 153) {
            boolean atTheTopOrBottom;
            boolean bl = atTheTopOrBottom = mouseY > startY + 6 && mouseY < startY + 26 || mouseY > startY + 133 && mouseY < startY + 153;
            if (mouseX > startX + 5 && mouseX < startX + 55) {
                DragonAltarGUI.func_238463_a_((MatrixStack)matrixStack, (int)(startX + 6), (int)(startY + 6), (float)217.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
                if (atTheTopOrBottom) {
                    this.renderWrappedToolTip(matrixStack, this.altarDragonInfoLocalized("cave_dragon", DragonFoodHandler.getSafeEdibleFoods(DragonType.CAVE)), mouseX, mouseY, this.field_230712_o_);
                }
            }
            if (mouseX > startX + 57 && mouseX < startX + 107) {
                DragonAltarGUI.func_238463_a_((MatrixStack)matrixStack, (int)(startX + 58), (int)(startY + 6), (float)266.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
                if (atTheTopOrBottom) {
                    this.renderWrappedToolTip(matrixStack, this.altarDragonInfoLocalized("forest_dragon", DragonFoodHandler.getSafeEdibleFoods(DragonType.FOREST)), mouseX, mouseY, this.field_230712_o_);
                }
            }
            if (mouseX > startX + 109 && mouseX < startX + 159) {
                DragonAltarGUI.func_238463_a_((MatrixStack)matrixStack, (int)(startX + 110), (int)(startY + 6), (float)315.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
                if (atTheTopOrBottom) {
                    this.renderWrappedToolTip(matrixStack, this.altarDragonInfoLocalized("sea_dragon", DragonFoodHandler.getSafeEdibleFoods(DragonType.SEA)), mouseX, mouseY, this.field_230712_o_);
                }
            }
            if (mouseX > startX + 161 && mouseX < startX + 211) {
                DragonAltarGUI.func_238463_a_((MatrixStack)matrixStack, (int)(startX + 161), (int)(startY + 6), (float)364.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
                if (atTheTopOrBottom) {
                    this.renderWrappedToolTip(matrixStack, this.altarDragonInfoLocalized("human", Collections.emptyList()), mouseX, mouseY, this.field_230712_o_);
                }
            }
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int xSize = 426;
        this.guiLeft = (this.field_230708_k_ - xSize / 2) / 2;
        int ySize = 250;
        this.guiTop = (this.field_230709_l_ - ySize) / 2;
        this.func_230480_a_((Widget)new ExtendedButton(this.guiLeft + 6, this.guiTop + 6, 49, 147, (ITextComponent)new StringTextComponent("CAVE"), button -> {
            this.initiateDragonForm(DragonType.CAVE);
            this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.cave_dragon_choice"), this.field_230706_i_.field_71439_g.func_110124_au());
        }));
        this.func_230480_a_((Widget)new ExtendedButton(this.guiLeft + 58, this.guiTop + 6, 49, 147, (ITextComponent)new StringTextComponent("FOREST"), button -> {
            this.initiateDragonForm(DragonType.FOREST);
            this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.forest_dragon_choice"), this.field_230706_i_.field_71439_g.func_110124_au());
        }));
        this.func_230480_a_((Widget)new ExtendedButton(this.guiLeft + 110, this.guiTop + 6, 49, 147, (ITextComponent)new StringTextComponent("SEA"), button -> {
            this.initiateDragonForm(DragonType.SEA);
            this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.sea_dragon_choice"), this.field_230706_i_.field_71439_g.func_110124_au());
        }));
        this.func_230480_a_((Widget)new ExtendedButton(this.guiLeft + 162, this.guiTop + 6, 49, 147, (ITextComponent)new StringTextComponent("Human"), b -> DragonStateProvider.getCap((Entity)this.field_230706_i_.field_71439_g).ifPresent(playerStateHandler -> {
            playerStateHandler.setIsHiding(false);
            playerStateHandler.setType(DragonType.NONE);
            playerStateHandler.setHasWings(false);
            playerStateHandler.setSize(20.0f);
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new SynchronizeDragonCap(this.field_230706_i_.field_71439_g.func_145782_y(), false, DragonType.NONE, 20.0f, false, (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get(), 0));
            this.field_230706_i_.field_71439_g.func_71053_j();
            this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.choice_human"), this.field_230706_i_.field_71439_g.func_110124_au());
        })));
    }

    private void initiateDragonForm(DragonType type) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        player.func_71053_j();
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new SynchronizeDragonCap(player.func_145782_y(), false, type, DragonLevel.BABY.size, (Boolean)ConfigHandler.SERVER.startWithWings.get(), (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get(), 0));
            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 0.7f);
            cap.setType(type);
            cap.setSize(DragonLevel.BABY.size, (PlayerEntity)player);
            cap.setHasWings(false);
        });
    }

    private ArrayList<ITextComponent> altarDragonInfoLocalized(String dragonType, List<Item> foodList) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        String b = "ds.altar_dragon_info." + dragonType + ".";
        int i = 0;
        if (new TranslationTextComponent(b + i).getString().equals(b + i)) {
            info.add(ITextComponent.func_244388_a((String)"none"));
        } else {
            boolean c = true;
            while (c) {
                String d = new TranslationTextComponent(b + i).getString();
                if (d.equals(b + i)) {
                    c = false;
                    continue;
                }
                if (d.contains("--food--") && DragonAltarGUI.func_231173_s_()) {
                    if (!Objects.equals(dragonType, "human")) {
                        String food = "";
                        for (Item item : foodList) {
                            food = food + item.func_200295_i(new ItemStack((IItemProvider)item)).getString() + "; ";
                        }
                        info.add(ITextComponent.func_244388_a((String)d.replaceAll("--food--", food)));
                    } else {
                        info.add(ITextComponent.func_244388_a((String)d));
                    }
                } else {
                    info.add(ITextComponent.func_244388_a((String)d));
                    if (d.equals("--food--")) {
                        info.remove(new StringTextComponent("--food--"));
                        info.add((ITextComponent)new TranslationTextComponent("ds.hold_shift.for_food"));
                    }
                }
                ++i;
            }
        }
        return info;
    }
}

