/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.Capabilities;
import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.capability.VillageRelationshipsProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.network.DiggingStatus;
import by.jackraidenph.dragonsurvival.network.RefreshDragons;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import by.jackraidenph.dragonsurvival.registration.DragonEffects;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.EffectInstance2;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class CapabilityController {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("dragonsurvival", "playerstatehandler"), (ICapabilityProvider)new DragonStateProvider());
            event.addCapability(new ResourceLocation("dragonsurvival", "village_relations"), (ICapabilityProvider)new VillageRelationshipsProvider());
            DragonSurvivalMod.LOGGER.info("Successfully attached capabilities to the " + ((Entity)event.getObject()).getClass().getSimpleName());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone e) {
        PlayerEntity player = e.getPlayer();
        PlayerEntity original = e.getOriginal();
        DragonStateProvider.getCap((Entity)player).ifPresent(capNew -> DragonStateProvider.getCap((Entity)original).ifPresent(capOld -> {
            if (capOld.isDragon()) {
                DragonStateHandler.DragonMovementData movementData = capOld.getMovementData();
                capNew.setMovementData(movementData.bodyYaw, movementData.headYaw, movementData.headPitch, movementData.bite);
                capNew.setSize(capOld.getSize());
                capNew.setType(capOld.getType());
                capNew.setHasWings(capOld.hasWings());
                capNew.setLavaAirSupply((Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get());
                DragonStateHandler.updateModifiers(original, player);
                player.func_213323_x_();
            }
        }));
        Capabilities.getVillageRelationships((Entity)player).ifPresent(villageRelationShips -> Capabilities.getVillageRelationships((Entity)original).ifPresent(old -> {
            villageRelationShips.evilStatusDuration = old.evilStatusDuration;
            villageRelationShips.crimeLevel = old.crimeLevel;
            villageRelationShips.hunterSpawnDelay = old.hunterSpawnDelay;
            if (villageRelationShips.evilStatusDuration > 0) {
                player.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, villageRelationShips.evilStatusDuration));
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity playerEntity = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && playerEntity instanceof ServerPlayerEntity) {
                PlayerInteractionManager interactionManager = ((ServerPlayerEntity)playerEntity).field_71134_c;
                boolean isMining = interactionManager.field_73088_d;
                DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new DiggingStatus(playerEntity.func_145782_y(), isMining));
            }
        });
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!(event.getTarget() instanceof PlayerEntity) || event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        PlayerEntity target = (PlayerEntity)event.getTarget();
        PlayerEntity self = event.getPlayer();
        DragonStateProvider.getCap((Entity)target).ifPresent(targetCap -> {
            if (targetCap.isDragon() && target.func_213283_Z() == Pose.CROUCHING && targetCap.getSize() >= 40.0f && !target.func_184207_aI()) {
                DragonStateProvider.getCap((Entity)self).ifPresent(selfCap -> {
                    if (!selfCap.isDragon() || selfCap.getLevel() == DragonLevel.BABY) {
                        if (event.getTarget() instanceof ServerPlayerEntity) {
                            self.func_184220_m((Entity)target);
                            ((ServerPlayerEntity)event.getTarget()).field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)target));
                            targetCap.setPassengerId(self.func_145782_y());
                            DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)new SynchronizeDragonCap(target.func_145782_y(), targetCap.isHiding(), targetCap.getType(), targetCap.getSize(), targetCap.hasWings(), targetCap.getLavaAirSupply(), self.func_145782_y()));
                        }
                        event.setCancellationResult(ActionResultType.SUCCESS);
                        event.setCanceled(true);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public static void onServerPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            int passengerId = dragonStateHandler.getPassengerId();
            Entity passenger = player.field_70170_p.func_73045_a(passengerId);
            boolean flag = false;
            if (!dragonStateHandler.isDragon() && player.func_184207_aI() && player.func_184188_bt().get(0) instanceof ServerPlayerEntity) {
                flag = true;
                ((Entity)player.func_184188_bt().get(0)).func_184210_p();
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
            } else if (player.func_175149_v() && passenger != null && player.func_184188_bt().get(0) instanceof ServerPlayerEntity) {
                flag = true;
                ((Entity)player.func_184188_bt().get(0)).func_184210_p();
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
            } else if (dragonStateHandler.isDragon() && dragonStateHandler.getSize() != 40.0f && player.func_184207_aI() && player.func_184188_bt().get(0) instanceof ServerPlayerEntity) {
                flag = true;
                ((Entity)player.func_184188_bt().get(0)).func_184210_p();
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
            } else if (player.func_70608_bn() && player.func_184207_aI() && player.func_184188_bt().get(0) instanceof ServerPlayerEntity) {
                flag = true;
                ((Entity)player.func_184188_bt().get(0)).func_184210_p();
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
            }
            if (passenger instanceof ServerPlayerEntity) {
                DragonStateHandler passengerCap = (DragonStateHandler)DragonStateProvider.getCap(passenger).orElseGet(null);
                if (passengerCap.isDragon() && passengerCap.getLevel() != DragonLevel.BABY) {
                    flag = true;
                    passenger.func_184210_p();
                    player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
                } else if (passenger.func_184208_bv() != player.func_184208_bv()) {
                    flag = true;
                    passenger.func_184210_p();
                    player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
                }
            }
            if (flag || passenger == null || !player.func_184196_w(passenger) || passenger.func_175149_v() || player.func_175149_v()) {
                dragonStateHandler.setPassengerId(0);
                DragonSurvivalMod.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SynchronizeDragonCap(player.func_145782_y(), dragonStateHandler.isHiding(), dragonStateHandler.getType(), dragonStateHandler.getSize(), dragonStateHandler.hasWings(), dragonStateHandler.getLavaAirSupply(), 0));
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        if (player.func_184187_bx() == null || !(player.func_184187_bx() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity vehicle = (ServerPlayerEntity)player.func_184187_bx();
        DragonStateProvider.getCap((Entity)player).ifPresent(playerCap -> DragonStateProvider.getCap((Entity)vehicle).ifPresent(vehicleCap -> {
            player.func_184210_p();
            vehicle.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)vehicle));
            vehicleCap.setPassengerId(0);
            DragonSurvivalMod.CHANNEL.send(PacketDistributor.PLAYER.with(() -> vehicle), (Object)new SynchronizeDragonCap(player.func_145782_y(), vehicleCap.isHiding(), vehicleCap.getType(), vehicleCap.getSize(), vehicleCap.hasWings(), vehicleCap.getLavaAirSupply(), 0));
        }));
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent changedDimensionEvent) {
        PlayerEntity playerEntity = changedDimensionEvent.getPlayer();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SynchronizeDragonCap(playerEntity.func_145782_y(), dragonStateHandler.isHiding(), dragonStateHandler.getType(), dragonStateHandler.getSize(), dragonStateHandler.hasWings(), dragonStateHandler.getLavaAirSupply(), 0));
            DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDragons(playerEntity.func_145782_y()));
        });
    }
}

