/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.config.DragonBodyMovementType;
import by.jackraidenph.dragonsurvival.entity.BolasEntity;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.gecko.DragonModel;
import by.jackraidenph.dragonsurvival.handlers.ClientFlightHandler;
import by.jackraidenph.dragonsurvival.mixins.AccessorEntityRenderer;
import by.jackraidenph.dragonsurvival.mixins.AccessorEntityRendererManager;
import by.jackraidenph.dragonsurvival.mixins.AccessorLivingRenderer;
import by.jackraidenph.dragonsurvival.network.OpenCrafting;
import by.jackraidenph.dragonsurvival.network.PacketSyncCapabilityMovement;
import by.jackraidenph.dragonsurvival.registration.ClientModEvents;
import by.jackraidenph.dragonsurvival.registration.DragonEffects;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import by.jackraidenph.dragonsurvival.registration.ItemsInit;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.ParrotVariantLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import software.bernie.geckolib3.core.processor.IBone;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static DragonModel dragonModel;
    static boolean showingInventory;
    private static final ResourceLocation DRAGON_HUD;
    static HashMap<String, Boolean> warningsForName;
    static HashMultimap<String, ResourceLocation> skinCache;
    static HashMultimap<String, ResourceLocation> skinCacheForName;
    public static AtomicReference<DragonEntity> dummyDragon2;
    public static ConcurrentHashMap<Integer, AtomicReference<DragonEntity>> playerDragonHashMap;
    public static ConcurrentHashMap<Integer, Boolean> dragonsFlying;
    public static ConcurrentHashMap<Integer, Boolean> dragonsDigging;
    public static ConcurrentHashMap<Integer, Integer> dragonsJumpingTicks;
    private static ItemStack BOLAS;

    @SubscribeEvent
    public static void decreaseJumpDuration(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.END) {
            PlayerEntity playerEntity = playerTickEvent.player;
            dragonsJumpingTicks.computeIfPresent(playerEntity.func_145782_y(), (playerEntity1, integer) -> integer > 0 ? integer - 1 : integer);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent renderHandEvent) {
        if (((Boolean)ConfigHandler.CLIENT.renderInFirstPerson.get()).booleanValue()) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (dummyDragon2 == null) {
                dummyDragon2 = new AtomicReference<Entity>(EntityTypesInit.DRAGON.func_200721_a(player.field_70170_p));
                ClientEvents.dummyDragon2.get().player = player.func_145782_y();
            }
            DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
                if (playerStateHandler.isDragon()) {
                    dragonModel.setupBones();
                    MatrixStack eventMatrixStack = renderHandEvent.getMatrixStack();
                    try {
                        eventMatrixStack.func_227860_a_();
                        float partialTicks = renderHandEvent.getPartialTicks();
                        float playerYaw = player.func_195046_g(partialTicks);
                        float playerPitch = player.func_195050_f(partialTicks);
                        ResourceLocation texture = ClientEvents.getSkin((PlayerEntity)player, playerStateHandler, playerStateHandler.getLevel());
                        eventMatrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(player.field_70125_A));
                        eventMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                        eventMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.field_70177_z));
                        eventMatrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)playerStateHandler.getMovementData().bodyYaw));
                        eventMatrixStack.func_227861_a_(0.0, -2.0, -1.0);
                        IRenderTypeBuffer buffers = renderHandEvent.getBuffers();
                        int light = renderHandEvent.getLight();
                        ClientEvents.dummyDragon2.get().isArmorModel = false;
                        EntityRenderer dragonRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)dummyDragon2.get());
                        dummyDragon2.get().func_82149_j((Entity)player);
                        dragonModel.setCurrentTexture(texture);
                        IBone neckandHead = dragonModel.getAnimationProcessor().getBone("Neck");
                        if (neckandHead != null) {
                            neckandHead.setHidden(true);
                        }
                        IBone leftwing = dragonModel.getAnimationProcessor().getBone("WingLeft");
                        IBone rightWing = dragonModel.getAnimationProcessor().getBone("WingRight");
                        if (leftwing != null) {
                            leftwing.setHidden(!playerStateHandler.hasWings());
                        }
                        if (rightWing != null) {
                            rightWing.setHidden(!playerStateHandler.hasWings());
                        }
                        if (!player.func_82150_aj()) {
                            dragonRenderer.func_225623_a_((Entity)dummyDragon2.get(), playerYaw, partialTicks, eventMatrixStack, buffers, light);
                        }
                        ClientEvents.dummyDragon2.get().isArmorModel = true;
                        eventMatrixStack.func_227862_a_(1.02f, 1.02f, 1.02f);
                        ResourceLocation chestplate = new ResourceLocation("dragonsurvival", ClientEvents.constructArmorTexture((PlayerEntity)player, EquipmentSlotType.CHEST));
                        dragonModel.setCurrentTexture(chestplate);
                        dragonRenderer.func_225623_a_((Entity)dummyDragon2.get(), playerYaw, partialTicks, eventMatrixStack, buffers, light);
                        ResourceLocation legs = new ResourceLocation("dragonsurvival", ClientEvents.constructArmorTexture((PlayerEntity)player, EquipmentSlotType.LEGS));
                        dragonModel.setCurrentTexture(legs);
                        dragonRenderer.func_225623_a_((Entity)dummyDragon2.get(), playerYaw, partialTicks, eventMatrixStack, buffers, light);
                        ResourceLocation boots = new ResourceLocation("dragonsurvival", ClientEvents.constructArmorTexture((PlayerEntity)player, EquipmentSlotType.FEET));
                        dragonModel.setCurrentTexture(boots);
                        dragonRenderer.func_225623_a_((Entity)dummyDragon2.get(), playerYaw, partialTicks, eventMatrixStack, buffers, light);
                        eventMatrixStack.func_227861_a_(0.0, 0.0, 0.15);
                    }
                    catch (Throwable ignored) {
                        if (!(ignored instanceof NullPointerException)) {
                            ignored.printStackTrace();
                        }
                    }
                    finally {
                        eventMatrixStack.func_227865_b_();
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void addCraftingButton(GuiScreenEvent.InitGuiEvent.Post initGuiEvent) {
        Screen screen = initGuiEvent.getGui();
        if (screen instanceof InventoryScreen && DragonStateProvider.isDragon((Entity)Minecraft.func_71410_x().field_71439_g)) {
            Button openCrafting = new Button(screen.field_230708_k_ / 2, screen.field_230709_l_ - 30, 60, 20, (ITextComponent)new StringTextComponent("Crafting"), p_onPress_1_ -> DragonSurvivalMod.CHANNEL.sendToServer((Object)new OpenCrafting()));
            initGuiEvent.addWidget((Widget)openCrafting);
        }
    }

    private static Vector3d getInputVector(Vector3d movement, float fricSpeed, float yRot) {
        double d0 = movement.func_189985_c();
        if (d0 < 1.0E-7) {
            return Vector3d.field_186680_a;
        }
        Vector3d vector3d = (d0 > 1.0 ? movement.func_72432_b() : movement).func_186678_a((double)fricSpeed);
        float f = MathHelper.func_76126_a((float)(yRot * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(yRot * ((float)Math.PI / 180)));
        return new Vector3d(vector3d.field_72450_a * (double)f1 - vector3d.field_72449_c * (double)f, vector3d.field_72448_b, vector3d.field_72449_c * (double)f1 + vector3d.field_72450_a * (double)f);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            if (player != null) {
                DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
                    if (playerStateHandler.isDragon()) {
                        float bodyAndHeadYawDiff = (float)playerStateHandler.getMovementData().bodyYaw - player.field_70759_as;
                        Vector3d moveVector = ClientEvents.getInputVector(new Vector3d((double)player.field_71158_b.field_78902_a, 0.0, (double)player.field_71158_b.field_192832_b), 1.0f, player.field_70177_z);
                        boolean isFlying = false;
                        if (ClientFlightHandler.wingsEnabled && !player.func_233570_aj_() && !player.func_70090_H() && !player.func_180799_ab()) {
                            moveVector = new Vector3d(player.func_226277_ct_() - player.field_70169_q, player.func_226278_cu_() - player.field_70167_r, player.func_226281_cx_() - player.field_70166_s);
                            isFlying = true;
                        }
                        float f = (float)MathHelper.func_181159_b((double)moveVector.field_72449_c, (double)moveVector.field_72450_a) * 57.295776f - 90.0f;
                        float f1 = (float)(Math.pow(moveVector.field_72450_a, 2.0) + Math.pow(moveVector.field_72449_c, 2.0));
                        if ((double)f1 > 2.8E-5) {
                            if (isFlying || minecraft.field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON && ConfigHandler.CLIENT.thirdPersonBodyMovement.get() == DragonBodyMovementType.DRAGON || minecraft.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && ConfigHandler.CLIENT.firstPersonBodyMovement.get() == DragonBodyMovementType.DRAGON) {
                                float f2 = MathHelper.func_76142_g((float)(f - (float)playerStateHandler.getMovementData().bodyYaw));
                                playerStateHandler.getMovementData().bodyYaw += (double)(0.5f * f2);
                            } else if (minecraft.field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON && ConfigHandler.CLIENT.thirdPersonBodyMovement.get() == DragonBodyMovementType.VANILLA || minecraft.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && ConfigHandler.CLIENT.firstPersonBodyMovement.get() == DragonBodyMovementType.VANILLA) {
                                boolean flag;
                                float f5 = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)player.field_70177_z) - f));
                                if (95.0f < f5 && f5 < 265.0f) {
                                    f -= 180.0f;
                                }
                                float _f = MathHelper.func_76142_g((float)(f - (float)playerStateHandler.getMovementData().bodyYaw));
                                playerStateHandler.getMovementData().bodyYaw += (double)(_f * 0.3f);
                                float _f1 = MathHelper.func_76142_g((float)(player.field_70177_z - (float)playerStateHandler.getMovementData().bodyYaw));
                                boolean bl = flag = _f1 < -90.0f || _f1 >= 90.0f;
                                if (_f1 < -75.0f) {
                                    _f1 = -75.0f;
                                }
                                if (_f1 >= 75.0f) {
                                    _f1 = 75.0f;
                                }
                                playerStateHandler.getMovementData().bodyYaw = player.field_70177_z - _f1;
                                if (_f1 * _f1 > 2500.0f) {
                                    playerStateHandler.getMovementData().bodyYaw += (double)(_f1 * 0.2f);
                                }
                            }
                            if (bodyAndHeadYawDiff > 180.0f) {
                                playerStateHandler.getMovementData().bodyYaw -= 360.0;
                            }
                            if (bodyAndHeadYawDiff <= -180.0f) {
                                playerStateHandler.getMovementData().bodyYaw += 360.0;
                            }
                            playerStateHandler.setMovementData(playerStateHandler.getMovementData().bodyYaw, player.field_70759_as, player.field_70125_A, player.field_82175_bq && player.func_184825_o(-3.0f) != 1.0f);
                            DragonSurvivalMod.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketSyncCapabilityMovement(player.func_145782_y(), playerStateHandler.getMovementData().bodyYaw, playerStateHandler.getMovementData().headYaw, playerStateHandler.getMovementData().headPitch, playerStateHandler.getMovementData().bite));
                        } else if (Math.abs(bodyAndHeadYawDiff) > 180.0f) {
                            if (Math.abs(bodyAndHeadYawDiff) > 360.0f) {
                                playerStateHandler.getMovementData().bodyYaw -= (double)bodyAndHeadYawDiff;
                            } else {
                                float turnSpeed = Math.min(1.0f + (float)Math.pow(Math.abs(bodyAndHeadYawDiff) - 180.0f, 1.5) / 30.0f, 50.0f);
                                playerStateHandler.setMovementData((float)playerStateHandler.getMovementData().bodyYaw - Math.signum(bodyAndHeadYawDiff) * turnSpeed, player.field_70759_as, player.field_70125_A, player.field_82175_bq && player.func_184825_o(-3.0f) != 1.0f);
                            }
                            DragonSurvivalMod.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketSyncCapabilityMovement(player.func_145782_y(), playerStateHandler.getMovementData().bodyYaw, playerStateHandler.getMovementData().headYaw, playerStateHandler.getMovementData().headPitch, playerStateHandler.getMovementData().bite));
                        } else if (playerStateHandler.getMovementData().bite != (player.field_82175_bq && player.func_184825_o(-3.0f) != 1.0f) || (double)player.field_70759_as != playerStateHandler.getMovementData().headYaw) {
                            playerStateHandler.setMovementData(playerStateHandler.getMovementData().bodyYaw, player.field_70759_as, player.field_70125_A, player.field_82175_bq && player.func_184825_o(-3.0f) != 1.0f);
                            DragonSurvivalMod.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketSyncCapabilityMovement(player.func_145782_y(), playerStateHandler.getMovementData().bodyYaw, playerStateHandler.getMovementData().headYaw, playerStateHandler.getMovementData().headPitch, playerStateHandler.getMovementData().bite));
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void thirdPersonPreRender(RenderPlayerEvent.Pre renderPlayerEvent) {
        PlayerEntity player = renderPlayerEvent.getPlayer();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && mc.field_71439_g.func_184196_w((Entity)player)) {
            renderPlayerEvent.setCanceled(true);
            return;
        }
        if (!playerDragonHashMap.containsKey(player.func_145782_y())) {
            DragonEntity dummyDragon = (DragonEntity)EntityTypesInit.DRAGON.func_200721_a(player.field_70170_p);
            dummyDragon.player = player.func_145782_y();
            playerDragonHashMap.put(player.func_145782_y(), new AtomicReference<DragonEntity>(dummyDragon));
        }
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (cap.isDragon()) {
                dragonModel.setupBones();
                renderPlayerEvent.setCanceled(true);
                float partialRenderTick = renderPlayerEvent.getPartialRenderTick();
                float limbSwingAmount = MathHelper.func_219799_g((float)partialRenderTick, (float)player.field_184618_aE, (float)player.field_70721_aZ);
                float yaw = player.func_195046_g(partialRenderTick);
                float pitch = player.func_195050_f(partialRenderTick);
                DragonLevel dragonStage = cap.getLevel();
                ResourceLocation texture = ClientEvents.getSkin(player, cap, dragonStage);
                MatrixStack matrixStack = renderPlayerEvent.getMatrixStack();
                try {
                    IBone neckHead;
                    matrixStack.func_227860_a_();
                    float size = cap.getSize();
                    float scale = Math.max(size / 40.0f, DragonLevel.BABY.maxWidth);
                    String playerModelType = ((AbstractClientPlayerEntity)player).func_175154_l();
                    LivingRenderer playerRenderer = (LivingRenderer)((AccessorEntityRendererManager)mc.func_175598_ae()).getPlayerRenderers().get(playerModelType);
                    int eventLight = renderPlayerEvent.getLight();
                    IRenderTypeBuffer renderTypeBuffer = renderPlayerEvent.getBuffers();
                    if (((Boolean)ConfigHandler.CLIENT.dragonNameTags.get()).booleanValue()) {
                        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)player, player.func_145748_c_(), (EntityRenderer)playerRenderer, matrixStack, renderTypeBuffer, eventLight, partialRenderTick);
                        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
                        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || ((AccessorLivingRenderer)playerRenderer).callShouldShowName((LivingEntity)player))) {
                            ((AccessorEntityRenderer)playerRenderer).callRenderNameTag((Entity)player, renderNameplateEvent.getContent(), matrixStack, renderTypeBuffer, eventLight);
                        }
                    }
                    matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)cap.getMovementData().bodyYaw));
                    matrixStack.func_227862_a_(scale, scale, scale);
                    ((AccessorEntityRenderer)renderPlayerEvent.getRenderer()).setShadowRadius((3.0f * size + 62.0f) / 260.0f);
                    DragonEntity dummyDragon = playerDragonHashMap.get(player.func_145782_y()).get();
                    dummyDragon.isArmorModel = false;
                    EntityRenderer dragonRenderer = mc.func_175598_ae().func_78713_a((Entity)dummyDragon);
                    dummyDragon.func_82149_j((Entity)player);
                    dragonModel.setCurrentTexture(texture);
                    IBone leftwing = dragonModel.getAnimationProcessor().getBone("WingLeft");
                    IBone rightWing = dragonModel.getAnimationProcessor().getBone("WingRight");
                    if (leftwing != null) {
                        leftwing.setHidden(!cap.hasWings());
                    }
                    if (rightWing != null) {
                        rightWing.setHidden(!cap.hasWings());
                    }
                    if ((neckHead = dragonModel.getAnimationProcessor().getBone("Neck")) != null) {
                        neckHead.setHidden(false);
                    }
                    if (player.func_213453_ef()) {
                        switch (dragonStage) {
                            case ADULT: {
                                matrixStack.func_227861_a_(0.0, 0.125, 0.0);
                                break;
                            }
                            case YOUNG: {
                                matrixStack.func_227861_a_(0.0, 0.25, 0.0);
                                break;
                            }
                            case BABY: {
                                matrixStack.func_227861_a_(0.0, 0.325, 0.0);
                            }
                        }
                    } else if (player.func_203007_ba() || player.func_204805_cN() || dragonsFlying.getOrDefault(player.func_145782_y(), false).booleanValue() && !player.func_233570_aj_() && !player.func_70090_H() && !player.func_180799_ab()) {
                        switch (dragonStage) {
                            case ADULT: {
                                matrixStack.func_227861_a_(0.0, -0.35, 0.0);
                                break;
                            }
                            case YOUNG: {
                                matrixStack.func_227861_a_(0.0, -0.25, 0.0);
                                break;
                            }
                            case BABY: {
                                matrixStack.func_227861_a_(0.0, -0.15, 0.0);
                            }
                        }
                    }
                    if (!player.func_82150_aj()) {
                        dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    }
                    String helmetTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.HEAD);
                    String chestPlateTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.CHEST);
                    String legsTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.LEGS);
                    String bootsTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.FEET);
                    dummyDragon.isArmorModel = true;
                    matrixStack.func_227862_a_(1.08f, 1.02f, 1.02f);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", helmetTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", chestPlateTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", legsTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", bootsTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    for (LayerRenderer layer : ((AccessorLivingRenderer)playerRenderer).getRenderLayers()) {
                        if (!(layer instanceof ParrotVariantLayer)) continue;
                        matrixStack.func_227862_a_(1.0f / scale, 1.0f / scale, 1.0f / scale);
                        matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(180.0f));
                        double height = 1.3 * (double)scale;
                        double forward = 0.3 * (double)scale;
                        float parrotHeadYaw = MathHelper.func_76131_a((float)(-1.0f * ((float)cap.getMovementData().bodyYaw - (float)cap.getMovementData().headYaw)), (float)-75.0f, (float)75.0f);
                        matrixStack.func_227861_a_(0.0, -height, -forward);
                        layer.func_225628_a_(matrixStack, renderTypeBuffer, eventLight, (Entity)player, 0.0f, 0.0f, partialRenderTick, (float)player.field_70173_aa + partialRenderTick, parrotHeadYaw, (float)cap.getMovementData().headPitch);
                        matrixStack.func_227861_a_(0.0, height, forward);
                        matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-180.0f));
                        matrixStack.func_227862_a_(scale, scale, scale);
                        break;
                    }
                    if (BOLAS == null) {
                        BOLAS = new ItemStack((IItemProvider)ItemsInit.huntingNet);
                    }
                    ItemRenderer itemRenderer = mc.func_175599_af();
                    int combinedOverlayIn = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
                    if (player.func_70644_a(DragonEffects.TRAPPED)) {
                        matrixStack.func_227860_a_();
                        matrixStack.func_227862_a_(3.0f, 3.0f, 3.0f);
                        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
                        itemRenderer.func_229110_a_(BOLAS, ItemCameraTransforms.TransformType.NONE, eventLight, combinedOverlayIn, matrixStack, renderTypeBuffer);
                        matrixStack.func_227865_b_();
                    }
                    ItemStack right = player.func_184614_ca();
                    matrixStack.func_227860_a_();
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    matrixStack.func_227861_a_(0.5, 1.0, -0.8);
                    itemRenderer.func_229110_a_(right, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, eventLight, combinedOverlayIn, matrixStack, renderTypeBuffer);
                    matrixStack.func_227865_b_();
                    matrixStack.func_227860_a_();
                    ItemStack left = player.func_184592_cb();
                    matrixStack.func_227861_a_(0.25, 1.0, 0.4);
                    itemRenderer.func_229110_a_(left, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, eventLight, combinedOverlayIn, matrixStack, renderTypeBuffer);
                    matrixStack.func_227865_b_();
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof NullPointerException)) {
                        throwable.printStackTrace();
                    }
                    matrixStack.func_227865_b_();
                }
                finally {
                    matrixStack.func_227865_b_();
                }
            } else {
                ((AccessorEntityRenderer)renderPlayerEvent.getRenderer()).setShadowRadius(0.5f);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceLocation getSkin(PlayerEntity player, DragonStateHandler cap, DragonLevel dragonStage) {
        ResourceLocation texture;
        UUID playerUniqueID = player.func_110124_au();
        String playerName = player.func_146103_bH().getName();
        Optional<ResourceLocation> skinForName = skinCacheForName.get((Object)playerName).stream().filter(location -> Boolean.parseBoolean(location.toString().endsWith(playerName.toLowerCase() + "_" + dragonStage.name) + "")).findFirst();
        if (skinForName.isPresent()) {
            return skinForName.get();
        }
        Optional<ResourceLocation> defSkin = skinCache.get((Object)playerName).stream().filter(location -> location.toString().endsWith(cap.getType().toString().toLowerCase(Locale.ROOT) + "_" + dragonStage.name + ".png")).findFirst();
        if (defSkin.isPresent()) {
            return defSkin.get();
        }
        try {
            texture = ClientModEvents.loadCustomSkinForName(player, dragonStage);
            skinCacheForName.put((Object)playerName, (Object)texture);
        }
        catch (IOException e) {
            if (warningsForName.get(playerName) == null) {
                DragonSurvivalMod.LOGGER.info("Custom skin for user {} doesn't exist", (Object)playerName);
                warningsForName.put(playerName, true);
            }
        }
        finally {
            texture = ClientEvents.constructTexture(cap.getType(), dragonStage);
            skinCache.put((Object)playerName, (Object)texture);
        }
        return texture;
    }

    private static ResourceLocation constructTexture(DragonType dragonType, DragonLevel stage) {
        String texture = "textures/dragon/";
        switch (dragonType) {
            case SEA: {
                texture = texture + "sea";
                break;
            }
            case CAVE: {
                texture = texture + "cave";
                break;
            }
            case FOREST: {
                texture = texture + "forest";
            }
        }
        switch (stage) {
            case BABY: {
                texture = texture + "_newborn";
                break;
            }
            case YOUNG: {
                texture = texture + "_young";
                break;
            }
            case ADULT: {
                texture = texture + "_adult";
            }
        }
        texture = texture + ".png";
        return new ResourceLocation("dragonsurvival", texture);
    }

    private static String constructArmorTexture(PlayerEntity playerEntity, EquipmentSlotType equipmentSlot) {
        String texture = "textures/armor/";
        Item item = playerEntity.func_184582_a(equipmentSlot).func_77973_b();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            IArmorMaterial armorMaterial = armorItem.func_200880_d();
            if (armorMaterial == ArmorMaterial.NETHERITE) {
                texture = texture + "netherite_";
            } else if (armorMaterial == ArmorMaterial.DIAMOND) {
                texture = texture + "diamond_";
            } else if (armorMaterial == ArmorMaterial.IRON) {
                texture = texture + "iron_";
            } else if (armorMaterial == ArmorMaterial.LEATHER) {
                texture = texture + "leather_";
            } else if (armorMaterial == ArmorMaterial.GOLD) {
                texture = texture + "gold_";
            } else if (armorMaterial == ArmorMaterial.CHAIN) {
                texture = texture + "chainmail_";
            } else if (armorMaterial == ArmorMaterial.TURTLE) {
                texture = texture + "turtle_";
            } else {
                return texture + "empty_armor.png";
            }
            texture = texture + "dragon_";
            switch (equipmentSlot) {
                case HEAD: {
                    texture = texture + "helmet";
                    break;
                }
                case CHEST: {
                    texture = texture + "chestplate";
                    break;
                }
                case LEGS: {
                    texture = texture + "leggings";
                    break;
                }
                case FEET: {
                    texture = texture + "boots";
                }
            }
            texture = texture + ".png";
            return texture;
        }
        return texture + "empty_armor.png";
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void removeLavaFog(EntityViewRenderEvent.FogDensity event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (cap.isDragon() && cap.getType() == DragonType.CAVE && event.getInfo().func_216771_k().func_206884_a((ITag)FluidTags.field_206960_b)) {
                event.setDensity(0.1f);
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void removeFireOverlay(RenderBlockOverlayEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (cap.isDragon() && cap.getType() == DragonType.CAVE && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void renderTrap(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> postEvent) {
        LivingEntity entity = postEvent.getEntity();
        if (!(entity instanceof PlayerEntity) && entity.func_233645_dx_().func_233790_b_(Attributes.field_233821_d_)) {
            AttributeModifier bolasTrap = new AttributeModifier(BolasEntity.DISABLE_MOVEMENT, "Bolas trap", -entity.func_110148_a(Attributes.field_233821_d_).func_111126_e(), AttributeModifier.Operation.ADDITION);
            if (entity.func_110148_a(Attributes.field_233821_d_).func_180374_a(bolasTrap)) {
                if (BOLAS == null) {
                    BOLAS = new ItemStack((IItemProvider)ItemsInit.huntingNet);
                }
                MatrixStack matrixStack = postEvent.getMatrixStack();
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(3.0f, 3.0f, 3.0f);
                matrixStack.func_227861_a_(0.0, 0.5, 0.0);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(BOLAS, ItemCameraTransforms.TransformType.NONE, postEvent.getLight(), LivingRenderer.func_229117_c_((LivingEntity)entity, (float)0.0f), matrixStack, postEvent.getBuffers());
                matrixStack.func_227865_b_();
            }
        }
    }

    static {
        DRAGON_HUD = new ResourceLocation("dragonsurvival:textures/gui/dragon_hud.png");
        warningsForName = new HashMap();
        skinCache = HashMultimap.create((int)1, (int)3);
        skinCacheForName = HashMultimap.create((int)1, (int)3);
        playerDragonHashMap = new ConcurrentHashMap(20);
        dragonsFlying = new ConcurrentHashMap(20);
        dragonsDigging = new ConcurrentHashMap(20);
        dragonsJumpingTicks = new ConcurrentHashMap(20);
    }
}

