/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DragonFoodHandler {
    private static Map<DragonType, Map<Item, Food>> DRAGON_FOODS;
    public static boolean isDrawingOverlay;
    private Minecraft mc;
    private final ResourceLocation FOOD_ICONS;
    private final Random rand;

    public DragonFoodHandler() {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.mc = Minecraft.func_71410_x();
        }
        this.rand = new Random();
        this.FOOD_ICONS = new ResourceLocation("dragonsurvival:textures/gui/dragon_hud.png");
        isDrawingOverlay = false;
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            DragonFoodHandler.rebuildFoodMap();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            DragonFoodHandler.rebuildFoodMap();
        }
    }

    private static void rebuildFoodMap() {
        HashMap<DragonType, Map<Item, Food>> dragonMap = new HashMap<DragonType, Map<Item, Food>>();
        dragonMap.put(DragonType.CAVE, DragonFoodHandler.buildDragonFoodMap(DragonType.CAVE));
        dragonMap.put(DragonType.FOREST, DragonFoodHandler.buildDragonFoodMap(DragonType.FOREST));
        dragonMap.put(DragonType.SEA, DragonFoodHandler.buildDragonFoodMap(DragonType.SEA));
        DRAGON_FOODS = new HashMap<DragonType, Map<Item, Food>>(dragonMap);
    }

    public static List<Item> getSafeEdibleFoods(DragonType dragonType) {
        ArrayList<Item> foods = new ArrayList<Item>();
        for (Item item : DRAGON_FOODS.get((Object)dragonType).keySet()) {
            boolean safe = true;
            Food food = DRAGON_FOODS.get((Object)dragonType).get(item);
            if (food == null) continue;
            for (Pair effect : food.func_221464_f()) {
                Effect e = ((EffectInstance)effect.getFirst()).func_188419_a();
                if (e.func_188408_i() || e == Effects.field_76431_k) continue;
                safe = false;
                break;
            }
            if (!safe) continue;
            foods.add(item);
        }
        return foods;
    }

    private static Map<Item, Food> buildDragonFoodMap(DragonType type) {
        String[] configFood;
        HashMap<Item, Food> foodMap = new HashMap<Item, Food>();
        switch (type) {
            case CAVE: {
                configFood = ((List)ConfigHandler.SERVER.caveDragonFoods.get()).toArray(new String[0]);
                break;
            }
            case FOREST: {
                configFood = ((List)ConfigHandler.SERVER.forestDragonFoods.get()).toArray(new String[0]);
                break;
            }
            case SEA: {
                configFood = ((List)ConfigHandler.SERVER.seaDragonFoods.get()).toArray(new String[0]);
                break;
            }
            default: {
                configFood = new String[]{};
            }
        }
        configFood = (String[])Stream.of(configFood).sorted(Comparator.reverseOrder()).toArray(String[]::new);
        for (String entry : configFood) {
            String[] sEntry = entry.split(":");
            ResourceLocation rlEntry = new ResourceLocation(sEntry[1], sEntry[2]);
            if (sEntry[0].equalsIgnoreCase("tag")) {
                ITag tag = ItemTags.func_199903_a().func_199910_a(rlEntry);
                if (tag != null && tag.func_230236_b_().size() != 0) {
                    for (Item item : tag.func_230236_b_()) {
                        foodMap.put(item, DragonFoodHandler.calculateDragonFoodProperties(item, type, sEntry.length == 5 ? Integer.parseInt(sEntry[3]) : (item.func_219967_s() != null ? item.func_219967_s().func_221466_a() : 1), sEntry.length == 5 ? Integer.parseInt(sEntry[4]) : (item.func_219967_s() != null ? (int)((float)item.func_219967_s().func_221466_a() * (item.func_219967_s().func_221469_b() * 2.0f)) : 0), true));
                    }
                    continue;
                }
                DragonSurvivalMod.LOGGER.error("Null or empty tag '{}:{}' in {} dragon food config.", (Object)sEntry[1], (Object)sEntry[2], (Object)type.toString().toLowerCase());
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rlEntry);
            if (item != null && item != Items.field_190931_a) {
                foodMap.put(item, DragonFoodHandler.calculateDragonFoodProperties(item, type, sEntry.length == 5 ? Integer.parseInt(sEntry[3]) : (item.func_219967_s() != null ? item.func_219967_s().func_221466_a() : 1), sEntry.length == 5 ? Integer.parseInt(sEntry[4]) : (item.func_219967_s() != null ? (int)((float)item.func_219967_s().func_221466_a() * (item.func_219967_s().func_221469_b() * 2.0f)) : 0), true));
                continue;
            }
            DragonSurvivalMod.LOGGER.warn("Unknown item '{}:{}' in {} dragon food config.", (Object)sEntry[1], (Object)sEntry[2], (Object)type.toString().toLowerCase());
        }
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (foodMap.containsKey(item) || !item.func_219971_r()) continue;
            foodMap.put(item, DragonFoodHandler.calculateDragonFoodProperties(item, type, 0, 0, false));
        }
        return new HashMap<Item, Food>(foodMap);
    }

    @Nullable
    private static Food calculateDragonFoodProperties(Item item, DragonType type, int nutrition, int saturation, boolean dragonFood) {
        if (!((Boolean)ConfigHandler.SERVER.customDragonFoods.get()).booleanValue() || type == DragonType.NONE) {
            return item.func_219967_s();
        }
        Food.Builder builder = new Food.Builder();
        if (dragonFood) {
            builder.func_221456_a(nutrition).func_221454_a((float)saturation / (float)nutrition / 2.0f);
            if (item.func_219967_s() != null) {
                Food humanFood = item.func_219967_s();
                if (humanFood.func_221467_c()) {
                    builder.func_221451_a();
                }
                if (humanFood.func_221468_d()) {
                    builder.func_221455_b();
                }
                if (humanFood.func_221465_e()) {
                    builder.func_221457_c();
                }
                for (Pair effect : humanFood.func_221464_f()) {
                    if (((EffectInstance)effect.getFirst()).func_188419_a() == Effects.field_76438_s || ((EffectInstance)effect.getFirst()).func_188419_a() == Effects.field_76436_u) continue;
                    builder.effect(() -> (EffectInstance)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
                }
            }
        } else {
            Food humanFood = item.func_219967_s();
            builder.func_221456_a(humanFood.func_221466_a()).func_221454_a(humanFood.func_221469_b());
            if (humanFood.func_221467_c()) {
                builder.func_221451_a();
            }
            if (humanFood.func_221468_d()) {
                builder.func_221455_b();
            }
            if (humanFood.func_221465_e()) {
                builder.func_221457_c();
            }
            for (Pair effect : humanFood.func_221464_f()) {
                if (((EffectInstance)effect.getFirst()).func_188419_a() == Effects.field_76438_s) continue;
                builder.effect(() -> (EffectInstance)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
            }
            builder.effect(() -> new EffectInstance(Effects.field_76438_s, 1200, 0), 1.0f);
        }
        return builder.func_221453_d();
    }

    @Nullable
    public static Food getDragonFoodProperties(Item item, DragonType type) {
        if (DRAGON_FOODS == null || !((Boolean)ConfigHandler.SERVER.customDragonFoods.get()).booleanValue() || type == DragonType.NONE) {
            return item.func_219967_s();
        }
        if (DRAGON_FOODS.get((Object)type).containsKey(item)) {
            return DRAGON_FOODS.get((Object)type).get(item);
        }
        return null;
    }

    public static boolean isDragonEdible(Item item, DragonType type) {
        if (((Boolean)ConfigHandler.SERVER.customDragonFoods.get()).booleanValue() && type != DragonType.NONE) {
            return DRAGON_FOODS.get((Object)type).containsKey(item);
        }
        return item.func_219967_s() != null;
    }

    public static void dragonEat(FoodStats foodStats, Item item, ItemStack itemStack, DragonType type) {
        if (DragonFoodHandler.isDragonEdible(item, type)) {
            Food food = DragonFoodHandler.getDragonFoodProperties(item, type);
            foodStats.func_75122_a(food.func_221466_a(), food.func_221469_b());
        }
    }

    public static int getUseDuration(ItemStack item, DragonType type) {
        if (DragonFoodHandler.isDragonEdible(item.func_77973_b(), type)) {
            return item.func_77973_b().func_219967_s() != null && item.func_77973_b().func_219967_s().func_221465_e() ? 16 : 32;
        }
        return item.func_77988_m();
    }

    @SubscribeEvent
    public void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        DragonStateProvider.getCap((Entity)event.getEntityLiving()).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                event.setDuration(DragonFoodHandler.getUseDuration(event.getItem(), dragonStateHandler.getType()));
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        DragonStateProvider.getCap((Entity)event.getEntityLiving()).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
                ServerWorld level = player.func_71121_q();
                Hand hand = event.getHand();
                ItemStack stack = player.func_184586_b(event.getHand());
                int i = stack.func_190916_E();
                int j = stack.func_77952_i();
                ActionResult actionresult = stack.func_77957_a((World)level, (PlayerEntity)player, hand);
                ItemStack itemstack = (ItemStack)actionresult.func_188398_b();
                if (itemstack == stack && itemstack.func_190916_E() == i && DragonFoodHandler.getUseDuration(itemstack, dragonStateHandler.getType()) <= 0 && itemstack.func_77952_i() == j) {
                    event.setCancellationResult(actionresult.func_188397_a());
                } else if (actionresult.func_188397_a() == ActionResultType.FAIL && DragonFoodHandler.getUseDuration(itemstack, dragonStateHandler.getType()) > 0 && !player.func_184587_cr()) {
                    event.setCancellationResult(actionresult.func_188397_a());
                } else {
                    player.func_184611_a(hand, itemstack);
                    if (player.func_184812_l_()) {
                        itemstack.func_190920_e(i);
                        if (itemstack.func_77984_f() && itemstack.func_77952_i() != j) {
                            itemstack.func_196085_b(j);
                        }
                    }
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    if (!player.func_184587_cr()) {
                        player.func_71120_a((Container)player.field_71069_bz);
                    }
                    event.setCancellationResult(actionresult.func_188397_a());
                }
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderFoodBar(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        boolean bl = isDrawingOverlay = !event.isCanceled() && (Boolean)ConfigHandler.SERVER.customDragonFoods.get() != false;
        if (!isDrawingOverlay) {
            return;
        }
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD || player.func_184812_l_() || player.func_175149_v()) {
                    return;
                }
                event.setCanceled(true);
                this.rand.setSeed((long)player.field_70173_aa * 312871L);
                RenderSystem.enableBlend();
                this.mc.func_110434_K().func_110577_a(this.FOOD_ICONS);
                int right_height = ForgeIngameGui.right_height;
                ForgeIngameGui.right_height += 10;
                int left = this.mc.func_228018_at_().func_198107_o() / 2 + 91;
                int top = this.mc.func_228018_at_().func_198087_p() - right_height;
                FoodStats food = player.func_71024_bL();
                int type = dragonStateHandler.getType() == DragonType.FOREST ? 0 : (dragonStateHandler.getType() == DragonType.CAVE ? 9 : 18);
                boolean hunger = player.func_70644_a(Effects.field_76438_s);
                for (int i = 0; i < 10; ++i) {
                    int idx = i * 2 + 1;
                    int y = top;
                    if (food.func_75115_e() <= 0.0f && player.field_70173_aa % (food.func_75116_a() * 3 + 1) == 0) {
                        y = top + (this.rand.nextInt(3) - 1);
                    }
                    this.mc.field_71456_v.func_238474_b_(event.getMatrixStack(), left - i * 8 - 9, y, hunger ? 117 : 0, type, 9, 9);
                    if (idx < food.func_75116_a()) {
                        this.mc.field_71456_v.func_238474_b_(event.getMatrixStack(), left - i * 8 - 9, y, hunger ? 72 : 36, type, 9, 9);
                        continue;
                    }
                    if (idx != food.func_75116_a()) continue;
                    this.mc.field_71456_v.func_238474_b_(event.getMatrixStack(), left - i * 8 - 9, y, hunger ? 81 : 45, type, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                RenderSystem.disableBlend();
            } else {
                isDrawingOverlay = false;
            }
        });
    }
}

