/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import by.jackraidenph.dragonsurvival.util.DragonType;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DragonSizeHandler {
    public static ConcurrentHashMap<Integer, Boolean> wingsStatusServer = new ConcurrentHashMap(20);
    private static ConcurrentHashMap<Integer, Boolean> wasDragon = new ConcurrentHashMap(20);
    public static ConcurrentHashMap<Integer, Float> lastSize = new ConcurrentHashMap(20);

    @SubscribeEvent
    public static void getDragonSize(EntityEvent.Size event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (!dragonStateHandler.isDragon()) {
                return;
            }
            float size = dragonStateHandler.getSize();
            float height = DragonSizeHandler.calculateDragonHeight(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get());
            float width = DragonSizeHandler.calculateDragonWidth(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get());
            float eyeHeight = DragonSizeHandler.calculateDragonEyeHeight(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get());
            if (((Boolean)ConfigHandler.SERVER.sizeChangesHitbox.get()).booleanValue()) {
                Pose overridePose = DragonSizeHandler.overridePose(player);
                height = DragonSizeHandler.calculateModifiedHeight(height, overridePose, true);
                eyeHeight = DragonSizeHandler.calculateModifiedEyeHeight(eyeHeight, overridePose);
                event.setNewEyeHeight(eyeHeight);
                event.setNewSize(new EntitySize(width, height, false));
            }
        });
    }

    public static float calculateDragonHeight(float size, boolean growsPastHuman) {
        float height = (size + 4.0f) / 20.0f;
        if (!growsPastHuman) {
            height = 9.0f * (size + 12.0f) / 260.0f;
        }
        return height;
    }

    public static float calculateDragonWidth(float size, boolean growsPastHuman) {
        float width = (3.0f * size + 62.0f) / 260.0f;
        if (!growsPastHuman) {
            width = (size + 38.0f) / 130.0f;
        }
        return width;
    }

    public static float calculateDragonEyeHeight(float size, boolean growsPastHuman) {
        float eyeHeight = (11.0f * size + 54.0f) / 260.0f;
        if (!growsPastHuman) {
            eyeHeight = (41.0f * size + 466.0f) / 1300.0f;
        }
        return eyeHeight;
    }

    public static float calculateModifiedHeight(float height, Pose pose, boolean sizeChangesHitbox) {
        if (pose == Pose.CROUCHING) {
            height = sizeChangesHitbox ? (height *= 0.8333333f) : 1.5f;
        } else if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING || pose == Pose.SPIN_ATTACK) {
            height = sizeChangesHitbox ? (height *= 0.5833333f) : 0.6f;
        }
        return height;
    }

    public static float calculateModifiedEyeHeight(float eyeHeight, Pose pose) {
        if (pose == Pose.CROUCHING) {
            eyeHeight *= 0.8333333f;
        } else if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING || pose == Pose.SPIN_ATTACK) {
            eyeHeight *= 0.5833333f;
        }
        return eyeHeight;
    }

    public static boolean canPoseFit(LivingEntity player, Pose pose) {
        if (!DragonStateProvider.getCap((Entity)player).isPresent()) {
            return false;
        }
        float size = ((DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).getSize();
        float height = DragonSizeHandler.calculateModifiedHeight(DragonSizeHandler.calculateDragonHeight(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get()), pose, (Boolean)ConfigHandler.SERVER.sizeChangesHitbox.get());
        float width = DragonSizeHandler.calculateDragonWidth(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get());
        return player.field_70170_p.func_226666_b_(null, new AxisAlignedBB(player.func_213303_ch().func_178786_a((double)width * 0.5, 0.0, (double)width * 0.5), player.func_213303_ch().func_72441_c((double)width * 0.5, (double)height, (double)width * 0.5))).count() == 0L;
    }

    private static Pose overridePose(PlayerEntity player) {
        Pose overridePose = DragonSizeHandler.getOverridePose((LivingEntity)player);
        if (player.getForcedPose() != overridePose) {
            player.setForcedPose(overridePose);
            if (player.field_70170_p.func_201670_d() && Minecraft.func_71410_x().field_175622_Z != player) {
                player.func_213323_x_();
            }
        }
        return overridePose;
    }

    public static Pose getOverridePose(LivingEntity player) {
        boolean swimming = (player.func_203005_aq() || player.func_180799_ab() && (Boolean)ConfigHandler.SERVER.bonuses.get() != false && (Boolean)ConfigHandler.SERVER.caveLavaSwimming.get() != false && ((DragonStateHandler)DragonStateProvider.getCap((Entity)player).orElseGet(null)).getType() == DragonType.CAVE) && player.func_70051_ag() && !player.func_184218_aH();
        boolean flying = player.field_70170_p.field_72995_K && ClientEvents.dragonsFlying.getOrDefault(player.func_145782_y(), false) != false && !player.func_70090_H() && !player.func_180799_ab() && !player.func_233570_aj_() && ((DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).hasWings() || !player.field_70170_p.field_72995_K && !player.func_233570_aj_() && wingsStatusServer.getOrDefault(player.func_145782_y(), false) != false && !player.func_70090_H() && !player.func_180799_ab() && ((DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).hasWings();
        boolean spinning = player.func_204805_cN();
        boolean crouching = player.func_225608_bj_();
        if (flying && !player.func_70608_bn()) {
            return Pose.FALL_FLYING;
        }
        if (swimming || (player.func_203005_aq() || player.func_180799_ab()) && !DragonSizeHandler.canPoseFit(player, Pose.STANDING) && DragonSizeHandler.canPoseFit(player, Pose.SWIMMING)) {
            return Pose.SWIMMING;
        }
        if (spinning) {
            return Pose.SPIN_ATTACK;
        }
        if (crouching || !DragonSizeHandler.canPoseFit(player, Pose.STANDING) && DragonSizeHandler.canPoseFit(player, Pose.CROUCHING)) {
            return Pose.CROUCHING;
        }
        return Pose.STANDING;
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null || event.phase == TickEvent.Phase.END || !((Boolean)ConfigHandler.SERVER.sizeChangesHitbox.get()).booleanValue()) {
            return;
        }
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                DragonSizeHandler.overridePose(player);
                if (!wasDragon.getOrDefault(player.func_145782_y(), false).booleanValue()) {
                    player.func_213323_x_();
                    wasDragon.put(player.func_145782_y(), true);
                } else if (lastSize.getOrDefault(player.func_145782_y(), Float.valueOf(20.0f)).floatValue() != dragonStateHandler.getSize()) {
                    player.func_213323_x_();
                    lastSize.put(player.func_145782_y(), Float.valueOf(dragonStateHandler.getSize()));
                }
            } else if (wasDragon.getOrDefault(player.func_145782_y(), false).booleanValue()) {
                player.setForcedPose(null);
                player.func_213323_x_();
                wasDragon.put(player.func_145782_y(), false);
            }
        });
    }
}

