/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.entity.MagicalPredatorEntity;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.registration.BlockInit;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import by.jackraidenph.dragonsurvival.registration.ItemsInit;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventHandler {
    static int cycle = 0;

    @SubscribeEvent
    public static void removeElytraFromDragon(TickEvent.PlayerTickEvent playerTickEvent) {
        if (!((Boolean)ConfigHandler.COMMON.dragonsAllowedToUseElytra.get()).booleanValue() && playerTickEvent.phase == TickEvent.Phase.START) {
            PlayerEntity playerEntity = playerTickEvent.player;
            DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
                if (dragonStateHandler.isDragon() && playerEntity instanceof ServerPlayerEntity && cycle >= 40) {
                    ItemStack stack = playerEntity.field_71071_by.func_70301_a(38);
                    Item item = stack.func_77973_b();
                    if (item instanceof ElytraItem) {
                        playerEntity.func_146097_a(playerEntity.field_71071_by.func_70304_b(38), true, false);
                    }
                    cycle = 0;
                } else {
                    ++cycle;
                }
            });
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinWorldEvent joinWorldEvent) {
        Entity entity = joinWorldEvent.getEntity();
        if (entity instanceof AnimalEntity && !(entity instanceof WolfEntity) && !(entity instanceof HoglinEntity)) {
            ((AnimalEntity)entity).field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)((AnimalEntity)entity), PlayerEntity.class, livingEntity -> DragonStateProvider.isDragon((Entity)((PlayerEntity)livingEntity)), 20.0f, (double)1.3f, 1.5, EntityPredicates.field_233583_f_));
        }
        if (entity instanceof HorseEntity) {
            HorseEntity horseEntity = (HorseEntity)entity;
            horseEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)horseEntity, PlayerEntity.class, 0, true, false, livingEntity -> ((DragonStateHandler)livingEntity.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElseGet(null)).getLevel() != DragonLevel.ADULT));
            horseEntity.field_70715_bh.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)horseEntity, PlayerEntity.class, livingEntity -> ((DragonStateHandler)livingEntity.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).getLevel() == DragonLevel.ADULT, 20.0f, 1.3, 1.5, EntityPredicates.field_233583_f_::test));
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        LivingEntity livingEntity = e.getEntityLiving();
        if (livingEntity instanceof PlayerEntity || livingEntity instanceof MagicalPredatorEntity) {
            return;
        }
        if (livingEntity instanceof AnimalEntity && livingEntity.field_70170_p.func_201674_k().nextDouble() < (Double)ConfigHandler.COMMON.predatorAnimalSpawnChance.get()) {
            MagicalPredatorEntity beast = (MagicalPredatorEntity)EntityTypesInit.MAGICAL_BEAST.func_200721_a(livingEntity.field_70170_p);
            livingEntity.field_70170_p.func_217376_c((Entity)beast);
            beast.func_223102_j(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
        }
    }

    @SubscribeEvent
    public static void sleepCheck(SleepingLocationCheckEvent sleepingLocationCheckEvent) {
        BlockPos sleepingLocation = sleepingLocationCheckEvent.getSleepingLocation();
        World world = sleepingLocationCheckEvent.getEntity().field_70170_p;
        if (world.func_226690_K_() && world.func_175625_s(sleepingLocation) instanceof NestEntity) {
            sleepingLocationCheckEvent.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void dropDragonDust(BlockEvent.BreakEvent breakEvent) {
        IWorld world;
        if (!breakEvent.isCanceled() && (world = breakEvent.getWorld()) instanceof ServerWorld) {
            BlockState blockState = breakEvent.getState();
            BlockPos blockPos = breakEvent.getPos();
            PlayerEntity playerEntity = breakEvent.getPlayer();
            Block block = blockState.func_177230_c();
            ItemStack mainHandItem = playerEntity.func_184586_b(Hand.MAIN_HAND);
            String[] tagStringSplit = ((String)ConfigHandler.SERVER.oresTag.get()).split(":");
            ResourceLocation ores = new ResourceLocation(tagStringSplit[0], tagStringSplit[1]);
            ITag oresTag = ItemTags.func_199903_a().func_199910_a(ores);
            if (!oresTag.func_230235_a_((Object)block.func_199767_j())) {
                return;
            }
            List drops = block.func_220076_a(blockState, new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p())).func_216015_a(LootParameters.field_216289_i, (Object)mainHandItem));
            DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
                boolean suitableOre;
                boolean bl = suitableOre = (playerEntity.func_184614_ca().func_150998_b(blockState) || dragonStateHandler.isDragon() && dragonStateHandler.canHarvestWithPaw(blockState)) && drops.stream().noneMatch(item -> oresTag.func_230235_a_((Object)item.func_77973_b()));
                if (suitableOre && !playerEntity.func_184812_l_()) {
                    if (dragonStateHandler.isDragon()) {
                        if (playerEntity.func_70681_au().nextDouble() < (Double)ConfigHandler.SERVER.dragonOreDustChance.get()) {
                            world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonDust)));
                        }
                        if (playerEntity.func_70681_au().nextDouble() < (Double)ConfigHandler.SERVER.dragonOreBoneChance.get()) {
                            world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonBone)));
                        }
                    } else {
                        if (playerEntity.func_70681_au().nextDouble() < (Double)ConfigHandler.SERVER.humanOreDustChance.get()) {
                            world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonDust)));
                        }
                        if (playerEntity.func_70681_au().nextDouble() < (Double)ConfigHandler.SERVER.humanOreBoneChance.get()) {
                            world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonBone)));
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void createAltar(PlayerInteractEvent.RightClickBlock rightClickBlock) {
        ItemStack itemStack = rightClickBlock.getItemStack();
        if (itemStack.func_77973_b() == ItemsInit.elderDragonBone && !rightClickBlock.getPlayer().func_175149_v()) {
            World world = rightClickBlock.getWorld();
            BlockPos blockPos = rightClickBlock.getPos();
            BlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean replace = false;
            rightClickBlock.getPlayer().func_175149_v();
            rightClickBlock.getPlayer().func_184812_l_();
            BlockItemUseContext deirection = new BlockItemUseContext(rightClickBlock.getPlayer(), rightClickBlock.getHand(), rightClickBlock.getItemStack(), new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), rightClickBlock.getPlayer().func_174811_aO(), blockPos, false));
            if (block == Blocks.field_150348_b) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_stone.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_150341_Y) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_mossy_cobblestone.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_150322_A) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_sandstone.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_180395_cM) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_red_sandstone.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_196617_K) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_oak_log.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_185767_cT) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_purpur_block.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_196653_dH) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar_nether_bricks.func_196258_a(deirection));
                replace = true;
            } else if (block == Blocks.field_235406_np_) {
                rightClickBlock.getPlayer().func_174811_aO();
                world.func_175656_a(blockPos, BlockInit.dragon_altar_blackstone.func_196258_a(deirection));
                replace = true;
            }
            if (replace) {
                if (!rightClickBlock.getPlayer().func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
                rightClickBlock.setCanceled(true);
                world.func_184133_a(rightClickBlock.getPlayer(), blockPos, SoundEvents.field_187855_gD, SoundCategory.PLAYERS, 1.0f, 1.0f);
                rightClickBlock.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }
}

