/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.handlers.DragonSizeHandler;
import by.jackraidenph.dragonsurvival.network.StartJump;
import by.jackraidenph.dragonsurvival.network.SyncCapabilityDebuff;
import by.jackraidenph.dragonsurvival.registration.DragonEffects;
import by.jackraidenph.dragonsurvival.renderer.CaveLavaFluidRenderer;
import by.jackraidenph.dragonsurvival.util.DamageSources;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpecificsHandler {
    private static final ResourceLocation DRAGON_HUD = new ResourceLocation("dragonsurvival:textures/gui/dragon_hud.png");
    private static Map<DragonType, List<Block>> DRAGON_SPEEDUP_BLOCKS;
    private static List<Block> SEA_DRAGON_HYDRATION_BLOCKS;
    private static List<Item> SEA_DRAGON_HYDRATION_USE_ALTERNATIVES;
    private static boolean wasCaveDragon;
    private static FluidBlockRenderer prevFluidRenderer;

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            SpecificsHandler.rebuildSpeedupBlocksMap();
            SpecificsHandler.rebuildSeaHydrationLists();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            SpecificsHandler.rebuildSpeedupBlocksMap();
            SpecificsHandler.rebuildSeaHydrationLists();
        }
    }

    private static void rebuildSpeedupBlocksMap() {
        HashMap<DragonType, List<Block>> speedupMap = new HashMap<DragonType, List<Block>>();
        speedupMap.put(DragonType.CAVE, SpecificsHandler.buildDragonSpeedupMap(DragonType.CAVE));
        speedupMap.put(DragonType.FOREST, SpecificsHandler.buildDragonSpeedupMap(DragonType.FOREST));
        speedupMap.put(DragonType.SEA, SpecificsHandler.buildDragonSpeedupMap(DragonType.SEA));
        DRAGON_SPEEDUP_BLOCKS = speedupMap;
    }

    private static List<Block> buildDragonSpeedupMap(DragonType type) {
        String[] configSpeedups;
        ArrayList<Block> speedupMap = new ArrayList<Block>();
        switch (type) {
            case CAVE: {
                configSpeedups = ((List)ConfigHandler.SERVER.caveSpeedupBlocks.get()).toArray(new String[0]);
                break;
            }
            case FOREST: {
                configSpeedups = ((List)ConfigHandler.SERVER.forestSpeedupBlocks.get()).toArray(new String[0]);
                break;
            }
            case SEA: {
                configSpeedups = ((List)ConfigHandler.SERVER.seaSpeedupBlocks.get()).toArray(new String[0]);
                break;
            }
            default: {
                configSpeedups = new String[]{};
            }
        }
        for (String entry : configSpeedups) {
            String[] sEntry = entry.split(":");
            ResourceLocation rlEntry = new ResourceLocation(sEntry[1], sEntry[2]);
            if (sEntry[0].equalsIgnoreCase("tag")) {
                ITag tag = BlockTags.func_199896_a().func_199910_a(rlEntry);
                if (tag != null && tag.func_230236_b_().size() != 0) {
                    for (Block block : tag.func_230236_b_()) {
                        speedupMap.add(block);
                    }
                    continue;
                }
                DragonSurvivalMod.LOGGER.error("Null or empty tag '{}:{}' in {} dragon speedup block config.", (Object)sEntry[1], (Object)sEntry[2], (Object)type.toString().toLowerCase());
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(rlEntry);
            if (block != null) {
                speedupMap.add(block);
                continue;
            }
            DragonSurvivalMod.LOGGER.error("Unknown block '{}:{}' in {} dragon speedup block config.", (Object)sEntry[1], (Object)sEntry[2], (Object)type.toString().toLowerCase());
        }
        return speedupMap;
    }

    private static void rebuildSeaHydrationLists() {
        String[] configHydrationItems;
        String[] configHydrationBlocks;
        ArrayList<Block> hydrationBlocks = new ArrayList<Block>();
        for (String entry : configHydrationBlocks = ((List)ConfigHandler.SERVER.seaHydrationBlocks.get()).toArray(new String[0])) {
            String[] sEntry = entry.split(":");
            ResourceLocation rlEntry = new ResourceLocation(sEntry[1], sEntry[2]);
            if (sEntry[0].equalsIgnoreCase("tag")) {
                ITag tag = BlockTags.func_199896_a().func_199910_a(rlEntry);
                if (tag != null && tag.func_230236_b_().size() != 0) {
                    for (Block block : tag.func_230236_b_()) {
                        hydrationBlocks.add(block);
                    }
                    continue;
                }
                DragonSurvivalMod.LOGGER.error("Null or empty tag '{}:{}' in sea dragon hydraton block config.", (Object)sEntry[1], (Object)sEntry[2]);
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(rlEntry);
            if (block != null) {
                hydrationBlocks.add(block);
                continue;
            }
            DragonSurvivalMod.LOGGER.error("Unknown block '{}:{}' in sea dragon hydration block config.", (Object)sEntry[1], (Object)sEntry[2]);
        }
        SEA_DRAGON_HYDRATION_BLOCKS = hydrationBlocks;
        ArrayList<Item> hydrationItems = new ArrayList<Item>();
        for (String entry : configHydrationItems = ((List)ConfigHandler.SERVER.seaAdditionalWaterUseables.get()).toArray(new String[0])) {
            String[] sEntry = entry.split(":");
            ResourceLocation rlEntry = new ResourceLocation(sEntry[1], sEntry[2]);
            if (sEntry[0].equalsIgnoreCase("tag")) {
                ITag tag = ItemTags.func_199903_a().func_199910_a(rlEntry);
                if (tag != null && tag.func_230236_b_().size() != 0) {
                    for (Item item : tag.func_230236_b_()) {
                        hydrationItems.add(item);
                    }
                    continue;
                }
                DragonSurvivalMod.LOGGER.error("Null or empty tag '{}:{}' in sea dragon hydration block config.", (Object)sEntry[1], (Object)sEntry[2]);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rlEntry);
            if (item != null) {
                hydrationItems.add(item);
                continue;
            }
            DragonSurvivalMod.LOGGER.error("Unknown block '{}:{}' in sea dragon hydration block config.", (Object)sEntry[1], (Object)sEntry[2]);
        }
        SEA_DRAGON_HYDRATION_USE_ALTERNATIVES = hydrationItems;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderOverlayPreTick(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
            if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
                int right_height;
                if (playerStateHandler.getType() == DragonType.SEA && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.seaSwimmingBonuses.get()).booleanValue()) {
                    event.setCanceled(true);
                }
                if (playerStateHandler.getDebuffData().timeWithoutWater > 0 && playerStateHandler.getType() == DragonType.SEA && ((Boolean)ConfigHandler.SERVER.penalties.get()).booleanValue() && (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() != 0) {
                    RenderSystem.enableBlend();
                    mc.func_110434_K().func_110577_a(DRAGON_HUD);
                    right_height = ForgeIngameGui.right_height;
                    ForgeIngameGui.right_height += 10;
                    int maxTimeWithoutWater = (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get();
                    int timeWithoutWater = maxTimeWithoutWater - playerStateHandler.getDebuffData().timeWithoutWater;
                    boolean flag = false;
                    if (timeWithoutWater < 0) {
                        flag = true;
                        timeWithoutWater = Math.abs(timeWithoutWater);
                    }
                    int left = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + 91;
                    int top = Minecraft.func_71410_x().func_228018_at_().func_198087_p() - right_height;
                    int full = flag ? MathHelper.func_76128_c((double)((double)timeWithoutWater * 10.0 / (double)maxTimeWithoutWater)) : MathHelper.func_76143_f((double)((double)(timeWithoutWater - 2) * 10.0 / (double)maxTimeWithoutWater));
                    int partial = MathHelper.func_76143_f((double)((double)timeWithoutWater * 10.0 / (double)maxTimeWithoutWater)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        Minecraft.func_71410_x().field_71456_v.func_238474_b_(event.getMatrixStack(), left - i * 8 - 9, top, flag ? 18 : (i < full ? 0 : 9), 36, 9, 9);
                    }
                    mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                    RenderSystem.disableBlend();
                }
                if (playerStateHandler.getLavaAirSupply() < (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get() && playerStateHandler.getType() == DragonType.CAVE && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get() != 0 && ((Boolean)ConfigHandler.SERVER.caveLavaSwimming.get()).booleanValue()) {
                    RenderSystem.enableBlend();
                    mc.func_110434_K().func_110577_a(DRAGON_HUD);
                    right_height = ForgeIngameGui.right_height;
                    ForgeIngameGui.right_height += 10;
                    int left = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + 91;
                    int top = Minecraft.func_71410_x().func_228018_at_().func_198087_p() - right_height;
                    int full = MathHelper.func_76143_f((double)((double)(playerStateHandler.getLavaAirSupply() - 2) * 10.0 / (double)((Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get()).intValue()));
                    int partial = MathHelper.func_76143_f((double)((double)playerStateHandler.getLavaAirSupply() * 10.0 / (double)((Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get()).intValue())) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        Minecraft.func_71410_x().field_71456_v.func_238474_b_(event.getMatrixStack(), left - i * 8 - 9, top, i < full ? 0 : 9, 27, 9, 9);
                    }
                    mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                    RenderSystem.disableBlend();
                }
                if (playerStateHandler.getDebuffData().timeInDarkness > 0 && playerStateHandler.getType() == DragonType.FOREST && ((Boolean)ConfigHandler.SERVER.penalties.get()).booleanValue() && (Integer)ConfigHandler.SERVER.forestStressTicks.get() != 0 && !player.func_70644_a(DragonEffects.STRESS)) {
                    RenderSystem.enableBlend();
                    mc.func_110434_K().func_110577_a(DRAGON_HUD);
                    right_height = ForgeIngameGui.right_height;
                    ForgeIngameGui.right_height += 10;
                    int maxTimeInDarkness = (Integer)ConfigHandler.SERVER.forestStressTicks.get();
                    int timeInDarkness = maxTimeInDarkness - Math.min(playerStateHandler.getDebuffData().timeInDarkness, maxTimeInDarkness);
                    int left = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + 91;
                    int top = Minecraft.func_71410_x().func_228018_at_().func_198087_p() - right_height;
                    int full = MathHelper.func_76143_f((double)((double)(timeInDarkness - 2) * 10.0 / (double)maxTimeInDarkness));
                    int partial = MathHelper.func_76143_f((double)((double)timeInDarkness * 10.0 / (double)maxTimeInDarkness)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        Minecraft.func_71410_x().field_71456_v.func_238474_b_(event.getMatrixStack(), left - i * 8 - 9, top, i < full ? 0 : 9, 45, 9, 9);
                    }
                    mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                    RenderSystem.disableBlend();
                }
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
            if (playerStateHandler.getType() == DragonType.CAVE && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveLavaSwimming.get()).booleanValue()) {
                if (!wasCaveDragon) {
                    RenderType lavaType = RenderType.func_228645_f_();
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_204547_b, (RenderType)lavaType);
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_207213_d, (RenderType)lavaType);
                    try {
                        FluidBlockRenderer fluidRenderer;
                        Field field = BlockRendererDispatcher.class.getDeclaredFields()[2];
                        field.setAccessible(true);
                        prevFluidRenderer = fluidRenderer = (FluidBlockRenderer)field.get(Minecraft.func_71410_x().func_175602_ab());
                        field.set(Minecraft.func_71410_x().func_175602_ab(), (Object)new CaveLavaFluidRenderer());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Minecraft.func_71410_x().field_71438_f.func_72712_a();
                }
            } else if (wasCaveDragon) {
                if (prevFluidRenderer != null) {
                    RenderType lavaType = RenderType.func_228639_c_();
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_204547_b, (RenderType)lavaType);
                    RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_207213_d, (RenderType)lavaType);
                    try {
                        Field field = BlockRendererDispatcher.class.getDeclaredFields()[2];
                        field.setAccessible(true);
                        FluidBlockRenderer fluidRenderer = (FluidBlockRenderer)field.get(Minecraft.func_71410_x().func_175602_ab());
                        field.set(Minecraft.func_71410_x().func_175602_ab(), prevFluidRenderer);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
            }
            wasCaveDragon = playerStateHandler.getType() == DragonType.CAVE;
        });
    }

    @SubscribeEvent
    public void onDamage(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                if (damageSource.func_76347_k() && dragonStateHandler.getType() == DragonType.CAVE && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveFireImmunity.get()).booleanValue()) {
                    event.setCanceled(true);
                } else if (damageSource == DamageSource.field_220302_v && dragonStateHandler.getType() == DragonType.FOREST && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.forestBushImmunity.get()).booleanValue()) {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public void removeLavaFootsteps(PlaySoundAtEntityEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.getType() == DragonType.CAVE && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveLavaSwimming.get()).booleanValue() && DragonSizeHandler.getOverridePose((LivingEntity)player) == Pose.SWIMMING && event.getSound().getRegistryName().func_110623_a().contains(".step")) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity playerEntity = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                World world = playerEntity.field_70170_p;
                BlockState blockUnder = world.func_180495_p(playerEntity.func_233580_cy_().func_177977_b());
                Block block = blockUnder.func_177230_c();
                if (!world.field_72995_K && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && (Integer)ConfigHandler.SERVER.speedupEffectLevel.get() > 0 && DRAGON_SPEEDUP_BLOCKS != null && DRAGON_SPEEDUP_BLOCKS.get((Object)dragonStateHandler.getType()).contains(block)) {
                    playerEntity.func_195064_c(new EffectInstance(Effects.field_76424_c, 65, (Integer)ConfigHandler.SERVER.speedupEffectLevel.get() - 1, false, false));
                }
                switch (dragonStateHandler.getType()) {
                    case CAVE: {
                        if (((Boolean)ConfigHandler.SERVER.penalties.get()).booleanValue() && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && (playerEntity.func_203005_aq() && (Double)ConfigHandler.SERVER.caveWaterDamage.get() != 0.0 || playerEntity.func_70026_G() && !playerEntity.func_70090_H() && (Double)ConfigHandler.SERVER.caveRainDamage.get() != 0.0 || SEA_DRAGON_HYDRATION_BLOCKS != null && (SEA_DRAGON_HYDRATION_BLOCKS.contains(block) || SEA_DRAGON_HYDRATION_BLOCKS.contains(world.func_180495_p(playerEntity.func_233580_cy_()).func_177230_c())) && (Double)ConfigHandler.SERVER.caveRainDamage.get() != 0.0)) {
                            if (playerEntity.func_203005_aq() && playerEntity.field_70173_aa % 10 == 0 && (Double)ConfigHandler.SERVER.caveWaterDamage.get() != 0.0) {
                                playerEntity.func_70097_a(DamageSources.WATER_BURN, ((Double)ConfigHandler.SERVER.caveWaterDamage.get()).floatValue());
                            } else if ((playerEntity.func_70026_G() && !playerEntity.func_203005_aq() || SEA_DRAGON_HYDRATION_BLOCKS != null && (SEA_DRAGON_HYDRATION_BLOCKS.contains(block) || SEA_DRAGON_HYDRATION_BLOCKS.contains(world.func_180495_p(playerEntity.func_233580_cy_()).func_177230_c()))) && playerEntity.field_70173_aa % 40 == 0 && (Double)ConfigHandler.SERVER.caveRainDamage.get() != 0.0) {
                                playerEntity.func_70097_a(DamageSources.WATER_BURN, ((Double)ConfigHandler.SERVER.caveRainDamage.get()).floatValue());
                            }
                            if (playerEntity.field_70173_aa % 5 == 0) {
                                playerEntity.func_184185_a(SoundEvents.field_187659_cY, 1.0f, (playerEntity.func_70681_au().nextFloat() - playerEntity.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                            }
                            if (world.field_72995_K) {
                                world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, playerEntity.func_226277_ct_() + world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1), playerEntity.func_226278_cu_() + 0.5, playerEntity.func_226281_cx_() + world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                            }
                        }
                        if (playerEntity.func_70027_ad() && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveFireImmunity.get()).booleanValue()) {
                            playerEntity.func_70066_B();
                        }
                        if (playerEntity.func_208600_a((ITag)FluidTags.field_206960_b) && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveLavaSwimming.get()).booleanValue() && (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get() != 0) {
                            if (!playerEntity.func_70648_aU() && !playerEntity.field_71075_bZ.field_75102_a) {
                                dragonStateHandler.setLavaAirSupply(dragonStateHandler.getLavaAirSupply() - 1);
                                if (dragonStateHandler.getLavaAirSupply() == -20) {
                                    dragonStateHandler.setLavaAirSupply(0);
                                    if (!playerEntity.field_70170_p.field_72995_K) {
                                        playerEntity.func_70097_a(DamageSource.field_76369_e, 2.0f);
                                    }
                                }
                            }
                            if (playerEntity.field_70170_p.field_72995_K || !playerEntity.func_184218_aH() || playerEntity.func_184187_bx() == null || playerEntity.func_184187_bx().canBeRiddenInWater((Entity)playerEntity)) break;
                            playerEntity.func_184210_p();
                            break;
                        }
                        if (dragonStateHandler.getLavaAirSupply() >= (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get() || playerEntity.func_208600_a((ITag)FluidTags.field_206959_a)) break;
                        dragonStateHandler.setLavaAirSupply(Math.min(dragonStateHandler.getLavaAirSupply() + (int)Math.ceil((float)((Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get()).intValue() * 0.0133333f), (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get()));
                        break;
                    }
                    case FOREST: {
                        if (!((Boolean)ConfigHandler.SERVER.penalties.get()).booleanValue() || (Integer)ConfigHandler.SERVER.forestStressTicks.get() <= 0 || playerEntity.func_184812_l_() || playerEntity.func_175149_v()) break;
                        WorldLightManager lightManager = world.func_72863_F().func_212863_j_();
                        if (lightManager.func_215569_a(LightType.BLOCK).func_215611_b(playerEntity.func_233580_cy_()) < 3 && lightManager.func_215569_a(LightType.SKY).func_215611_b(playerEntity.func_233580_cy_()) < 3) {
                            if (dragonStateHandler.getDebuffData().timeInDarkness < (Integer)ConfigHandler.SERVER.forestStressTicks.get()) {
                                ++dragonStateHandler.getDebuffData().timeInDarkness;
                            }
                            if (dragonStateHandler.getDebuffData().timeInDarkness == 1 && !playerEntity.field_70170_p.field_72995_K) {
                                DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new SyncCapabilityDebuff(playerEntity.func_145782_y(), dragonStateHandler.getDebuffData().timeWithoutWater, dragonStateHandler.getDebuffData().timeInDarkness));
                            }
                            if (dragonStateHandler.getDebuffData().timeInDarkness != (Integer)ConfigHandler.SERVER.forestStressTicks.get() || world.field_72995_K || playerEntity.field_70173_aa % 21 != 0) break;
                            playerEntity.func_195064_c(new EffectInstance(DragonEffects.STRESS, (Integer)ConfigHandler.SERVER.forestStressEffectDuration.get() * 20));
                            break;
                        }
                        if (dragonStateHandler.getDebuffData().timeInDarkness <= 0) break;
                        dragonStateHandler.getDebuffData().timeInDarkness = Math.max(dragonStateHandler.getDebuffData().timeInDarkness - (int)Math.ceil((float)((Integer)ConfigHandler.SERVER.forestStressTicks.get()).intValue() * 0.02f), 0);
                        if (dragonStateHandler.getDebuffData().timeInDarkness != 0 || playerEntity.field_70170_p.field_72995_K) break;
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new SyncCapabilityDebuff(playerEntity.func_145782_y(), dragonStateHandler.getDebuffData().timeWithoutWater, dragonStateHandler.getDebuffData().timeInDarkness));
                        break;
                    }
                    case SEA: {
                        if (playerEntity.func_208600_a((ITag)FluidTags.field_206959_a) && playerEntity.func_70086_ai() < playerEntity.func_205010_bg()) {
                            playerEntity.func_70050_g(playerEntity.func_205010_bg());
                        }
                        if (!((Boolean)ConfigHandler.SERVER.penalties.get()).booleanValue() || (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() <= 0 || playerEntity.func_184812_l_() || playerEntity.func_175149_v()) break;
                        if (!(playerEntity.func_203008_ap() || SEA_DRAGON_HYDRATION_BLOCKS == null || SEA_DRAGON_HYDRATION_BLOCKS.contains(block) || SEA_DRAGON_HYDRATION_BLOCKS.contains(world.func_180495_p(playerEntity.func_233580_cy_()).func_177230_c()))) {
                            if (dragonStateHandler.getDebuffData().timeWithoutWater < (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() * 2) {
                                ++dragonStateHandler.getDebuffData().timeWithoutWater;
                            }
                            if (dragonStateHandler.getDebuffData().timeWithoutWater == (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() + 1 && !playerEntity.field_70170_p.field_72995_K) {
                                DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new SyncCapabilityDebuff(playerEntity.func_145782_y(), dragonStateHandler.getDebuffData().timeWithoutWater, dragonStateHandler.getDebuffData().timeInDarkness));
                            }
                        } else if (dragonStateHandler.getDebuffData().timeWithoutWater > 0) {
                            int old = dragonStateHandler.getDebuffData().timeWithoutWater;
                            dragonStateHandler.getDebuffData().timeWithoutWater = Math.max(dragonStateHandler.getDebuffData().timeWithoutWater - (int)Math.ceil((float)((Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get()).intValue() * 0.005f), 0);
                            if (old > (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() + 1 && dragonStateHandler.getDebuffData().timeWithoutWater <= (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() && !playerEntity.field_70170_p.field_72995_K) {
                                DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new SyncCapabilityDebuff(playerEntity.func_145782_y(), dragonStateHandler.getDebuffData().timeWithoutWater, dragonStateHandler.getDebuffData().timeInDarkness));
                            }
                        }
                        if (!world.field_72995_K && dragonStateHandler.getDebuffData().timeWithoutWater > (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() && dragonStateHandler.getDebuffData().timeWithoutWater < (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() * 2) {
                            if (playerEntity.field_70173_aa % 40 != 0) break;
                            playerEntity.func_70097_a(DamageSources.DEHYDRATION, ((Double)ConfigHandler.SERVER.seaDehydrationDamage.get()).floatValue());
                            break;
                        }
                        if (world.field_72995_K || dragonStateHandler.getDebuffData().timeWithoutWater < (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() * 2 || playerEntity.field_70173_aa % 20 != 0) break;
                        playerEntity.func_70097_a(DamageSources.DEHYDRATION, ((Double)ConfigHandler.SERVER.seaDehydrationDamage.get()).floatValue());
                    }
                }
                if (world.field_72995_K && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v()) {
                    if (dragonStateHandler.getType() == DragonType.SEA && dragonStateHandler.getDebuffData().timeWithoutWater >= (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get()) {
                        world.func_195594_a((IParticleData)ParticleTypes.field_239820_at_, playerEntity.func_226277_ct_() + world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1), playerEntity.func_226278_cu_() + 0.5, playerEntity.func_226281_cx_() + world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                    }
                    if (dragonStateHandler.getType() == DragonType.FOREST && dragonStateHandler.getDebuffData().timeInDarkness == (Integer)ConfigHandler.SERVER.forestStressTicks.get()) {
                        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, playerEntity.func_226277_ct_() + world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1), playerEntity.func_226278_cu_() + 0.5, playerEntity.func_226281_cx_() + world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void modifyBreakSpeed(PlayerEvent.BreakSpeed breakSpeedEvent) {
        if (!((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() || !((Boolean)ConfigHandler.SERVER.clawsAreTools.get()).booleanValue()) {
            return;
        }
        PlayerEntity playerEntity = breakSpeedEvent.getPlayer();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (!dragonStateHandler.isDragon()) return;
            ItemStack mainStack = playerEntity.func_184614_ca();
            BlockState blockState = breakSpeedEvent.getState();
            Item item = mainStack.func_77973_b();
            if (!(item instanceof ToolItem || item instanceof SwordItem || item instanceof ShearsItem)) {
                block0 : switch (dragonStateHandler.getLevel()) {
                    case BABY: {
                        if (ConfigHandler.SERVER.bonusUnlockedAt.get() != DragonLevel.BABY) {
                            breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 2.0f);
                            return;
                        }
                    }
                    case YOUNG: {
                        if (ConfigHandler.SERVER.bonusUnlockedAt.get() == DragonLevel.ADULT && dragonStateHandler.getLevel() != DragonLevel.BABY) {
                            breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 2.0f);
                            return;
                        }
                    }
                    case ADULT: {
                        switch (dragonStateHandler.getType()) {
                            case FOREST: {
                                if (blockState.isToolEffective(ToolType.AXE)) {
                                    breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 4.0f);
                                    break block0;
                                }
                                breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 2.0f);
                                break block0;
                            }
                            case CAVE: {
                                if (blockState.isToolEffective(ToolType.PICKAXE)) {
                                    breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 4.0f);
                                    break block0;
                                }
                                breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 2.0f);
                                break block0;
                            }
                            case SEA: {
                                if (blockState.isToolEffective(ToolType.SHOVEL)) {
                                    breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 4.0f);
                                } else {
                                    breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 2.0f);
                                }
                                if (!playerEntity.func_203005_aq()) return;
                                breakSpeedEvent.setNewSpeed(breakSpeedEvent.getNewSpeed() * 1.4f);
                            }
                        }
                    }
                }
                return;
            } else {
                breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 0.7f);
            }
        });
    }

    @SubscribeEvent
    public void dropBlocksMinedByPaw(PlayerEvent.HarvestCheck harvestCheck) {
        if (!((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() || !((Boolean)ConfigHandler.SERVER.clawsAreTools.get()).booleanValue()) {
            return;
        }
        PlayerEntity playerEntity = harvestCheck.getPlayer();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                ItemStack stack = playerEntity.func_184614_ca();
                Item item = stack.func_77973_b();
                BlockState blockState = harvestCheck.getTargetBlock();
                if (!(item instanceof ToolItem || item instanceof SwordItem || item instanceof ShearsItem || harvestCheck.canHarvest())) {
                    harvestCheck.setCanHarvest(dragonStateHandler.canHarvestWithPaw(blockState));
                }
            }
        });
    }

    @SubscribeEvent
    public void disableMounts(EntityMountEvent mountEvent) {
        Entity mounting = mountEvent.getEntityMounting();
        DragonStateProvider.getCap(mounting).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && (mountEvent.getEntityBeingMounted() instanceof AbstractHorseEntity || mountEvent.getEntityBeingMounted() instanceof PigEntity || mountEvent.getEntityBeingMounted() instanceof StriderEntity)) {
                mountEvent.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void onItemDestroyed(LivingEntityUseItemEvent.Finish destroyItemEvent) {
        if (!((Boolean)ConfigHandler.SERVER.penalties.get()).booleanValue() || (Integer)ConfigHandler.SERVER.seaTicksWithoutWater.get() == 0) {
            return;
        }
        ItemStack itemStack = destroyItemEvent.getItem();
        DragonStateProvider.getCap((Entity)destroyItemEvent.getEntityLiving()).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                PlayerEntity playerEntity = (PlayerEntity)destroyItemEvent.getEntityLiving();
                if (((Boolean)ConfigHandler.SERVER.seaAllowWaterBottles.get()).booleanValue() && itemStack.func_77973_b() instanceof PotionItem) {
                    PotionItem potionItem = (PotionItem)itemStack.func_77973_b();
                    if (PotionUtils.func_185191_c((ItemStack)itemStack) == Potions.field_185230_b && dragonStateHandler.getType() == DragonType.SEA && !playerEntity.field_70170_p.field_72995_K) {
                        dragonStateHandler.getDebuffData().timeWithoutWater = Math.max(dragonStateHandler.getDebuffData().timeWithoutWater - (Integer)ConfigHandler.SERVER.seaTicksWithoutWaterRestored.get(), 0);
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new SyncCapabilityDebuff(playerEntity.func_145782_y(), dragonStateHandler.getDebuffData().timeWithoutWater, dragonStateHandler.getDebuffData().timeInDarkness));
                    }
                }
                if (SEA_DRAGON_HYDRATION_USE_ALTERNATIVES.contains(itemStack.func_77973_b()) && !playerEntity.field_70170_p.field_72995_K) {
                    dragonStateHandler.getDebuffData().timeWithoutWater = Math.max(dragonStateHandler.getDebuffData().timeWithoutWater - (Integer)ConfigHandler.SERVER.seaTicksWithoutWaterRestored.get(), 0);
                    DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new SyncCapabilityDebuff(playerEntity.func_145782_y(), dragonStateHandler.getDebuffData().timeWithoutWater, dragonStateHandler.getDebuffData().timeInDarkness));
                }
            }
        });
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent jumpEvent) {
        LivingEntity livingEntity = jumpEvent.getEntityLiving();
        DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                switch (dragonStateHandler.getLevel()) {
                    case BABY: {
                        livingEntity.func_70024_g(0.0, 0.025, 0.0);
                        break;
                    }
                    case YOUNG: {
                        livingEntity.func_70024_g(0.0, 0.1, 0.0);
                        break;
                    }
                    case ADULT: {
                        livingEntity.func_70024_g(0.0, 0.15, 0.0);
                    }
                }
                if (livingEntity instanceof ServerPlayerEntity) {
                    if (livingEntity.func_184102_h().func_71264_H()) {
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StartJump(livingEntity.func_145782_y(), 20));
                    } else {
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StartJump(livingEntity.func_145782_y(), 10));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void reduceFallDistance(LivingFallEvent livingFallEvent) {
        if (!((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() || (Double)ConfigHandler.SERVER.forestFallReduction.get() == 0.0) {
            return;
        }
        LivingEntity livingEntity = livingFallEvent.getEntityLiving();
        DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && dragonStateHandler.getType() == DragonType.FOREST) {
                livingFallEvent.setDistance(livingFallEvent.getDistance() - ((Double)ConfigHandler.SERVER.forestFallReduction.get()).floatValue());
            }
        });
    }

    static {
        wasCaveDragon = false;
    }
}

