/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.Functions;
import by.jackraidenph.dragonsurvival.capability.Capabilities;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.entity.DragonHunter;
import by.jackraidenph.dragonsurvival.entity.PrincessEntity;
import by.jackraidenph.dragonsurvival.gecko.Knight;
import by.jackraidenph.dragonsurvival.gecko.Prince;
import by.jackraidenph.dragonsurvival.gecko.Princess;
import by.jackraidenph.dragonsurvival.goals.FollowMobGoal;
import by.jackraidenph.dragonsurvival.registration.DragonEffects;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import by.jackraidenph.dragonsurvival.util.EffectInstance2;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VillagerRelationsHandler {
    public static List<? extends EntityType<? extends CreatureEntity>> dragonHunters;
    private static int timeLeft;

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent deathEvent) {
        LivingEntity livingEntity = deathEvent.getEntityLiving();
        Entity killer = deathEvent.getSource().func_76346_g();
        if (killer instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)killer;
            if (livingEntity instanceof AbstractVillagerEntity) {
                World world = killer.field_70170_p;
                livingEntity.func_200600_R().getRegistryName();
                if (!(livingEntity instanceof Princess) && DragonStateProvider.isDragon(killer)) {
                    AbstractVillagerEntity villagerEntity = (AbstractVillagerEntity)livingEntity;
                    MerchantOffers merchantOffers = villagerEntity.func_213706_dY();
                    if (villagerEntity instanceof VillagerEntity) {
                        VillagerEntity villager = (VillagerEntity)villagerEntity;
                        int level = villager.func_213700_eh().func_221132_c();
                        if (world.field_73012_v.nextInt(100) < 30) {
                            Optional offer = merchantOffers.stream().filter(merchantOffer -> merchantOffer.func_222200_d().func_77973_b() != Items.field_151166_bC).collect(Collectors.toList()).stream().findAny();
                            offer.ifPresent(merchantOffer -> world.func_217376_c((Entity)new ItemEntity(world, villager.func_226277_ct_(), villager.func_226278_cu_(), villager.func_226281_cx_(), merchantOffer.func_222200_d())));
                        }
                        if (!world.field_72995_K) {
                            playerEntity.func_195068_e(level * (Integer)ConfigHandler.COMMON.xpGain.get());
                        }
                    } else if (villagerEntity instanceof WanderingTraderEntity) {
                        WanderingTraderEntity wanderingTrader = (WanderingTraderEntity)villagerEntity;
                        if (!world.field_72995_K) {
                            playerEntity.func_195068_e(2 * (Integer)ConfigHandler.COMMON.xpGain.get());
                            if (world.field_73012_v.nextInt(100) < 30) {
                                ItemStack itemStack = ((MerchantOffer)wanderingTrader.func_213706_dY().stream().filter(merchantOffer -> merchantOffer.func_222200_d().func_77973_b() != Items.field_151166_bC).collect(Collectors.toList()).get(wanderingTrader.func_70681_au().nextInt(wanderingTrader.func_213706_dY().size()))).func_222200_d();
                                world.func_217376_c((Entity)new ItemEntity(world, wanderingTrader.func_226277_ct_(), wanderingTrader.func_226278_cu_(), wanderingTrader.func_226281_cx_(), itemStack));
                            }
                        }
                    }
                }
            } else if (livingEntity instanceof DragonHunter && !DragonStateProvider.isDragon((Entity)playerEntity) && livingEntity instanceof Knight) {
                playerEntity.func_195064_c(new EffectInstance(Effects.field_220309_E, Functions.minutesToTicks(5)));
            }
            String typeName = livingEntity.func_200600_R().getRegistryName().toString();
            if (DragonStateProvider.isDragon((Entity)playerEntity) && ((List)ConfigHandler.COMMON.evilDragonStatusGivers.get()).contains(typeName)) {
                VillagerRelationsHandler.applyEvilMarker(playerEntity);
            }
        }
    }

    @SubscribeEvent
    public static void entityTargets(LivingSetAttackTargetEvent setAttackTargetEvent) {
        Entity entity = setAttackTargetEvent.getEntity();
        LivingEntity target = setAttackTargetEvent.getTarget();
        if (entity instanceof IronGolemEntity) {
            if (target instanceof DragonHunter) {
                ((IronGolemEntity)entity).func_70624_b(null);
            }
        } else if (entity instanceof ZombieEntity && (target instanceof PrincessEntity || target instanceof Princess)) {
            ((ZombieEntity)entity).func_70624_b(null);
        }
    }

    public static void applyEvilMarker(PlayerEntity playerEntity) {
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                EffectInstance effectInstance = playerEntity.func_70660_b(DragonEffects.EVIL_DRAGON);
                if (effectInstance == null) {
                    playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(10)));
                } else {
                    int duration = effectInstance.func_76459_b();
                    if (duration <= Functions.minutesToTicks(10)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(30), 1));
                    } else if (duration <= Functions.minutesToTicks(30)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(60), 2));
                    } else if (duration <= Functions.minutesToTicks(60)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(100), 3));
                    } else if (duration <= Functions.minutesToTicks(100)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(120), 4));
                    } else if (duration <= Functions.minutesToTicks(120)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(150), 5));
                    } else if (duration <= Functions.minutesToTicks(150)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(200), 6));
                    } else if (duration <= Functions.minutesToTicks(200)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(250), 7));
                    } else if (duration <= Functions.minutesToTicks(250)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(300), 8));
                    } else if (duration <= Functions.minutesToTicks(300)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(350), 9));
                    } else if (duration <= Functions.minutesToTicks(350)) {
                        playerEntity.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.minutesToTicks(400), 10));
                    }
                }
            }
        });
    }

    public static int computeLevelOfEvil(PlayerEntity playerEntity) {
        if (DragonStateProvider.isDragon((Entity)playerEntity) && playerEntity.func_70644_a(DragonEffects.EVIL_DRAGON)) {
            EffectInstance effectInstance = playerEntity.func_70660_b(DragonEffects.EVIL_DRAGON);
            assert (effectInstance != null);
            int timeLeft = effectInstance.func_76459_b();
            if (timeLeft >= Functions.minutesToTicks(350)) {
                return 10;
            }
            if (timeLeft >= Functions.minutesToTicks(300)) {
                return 9;
            }
            if (timeLeft >= Functions.minutesToTicks(250)) {
                return 8;
            }
            if (timeLeft >= Functions.minutesToTicks(200)) {
                return 7;
            }
            if (timeLeft >= Functions.minutesToTicks(150)) {
                return 6;
            }
            if (timeLeft >= Functions.minutesToTicks(120)) {
                return 5;
            }
            if (timeLeft >= Functions.minutesToTicks(100)) {
                return 4;
            }
            if (timeLeft >= Functions.minutesToTicks(60)) {
                return 3;
            }
            if (timeLeft >= Functions.minutesToTicks(30)) {
                return 2;
            }
            if (timeLeft >= Functions.minutesToTicks(10)) {
                return 1;
            }
        }
        return 0;
    }

    @SubscribeEvent
    public static void voidEvilStatus(PotionEvent.PotionAddedEvent potionAddedEvent) {
        EffectInstance effectInstance = potionAddedEvent.getPotionEffect();
        LivingEntity livingEntity = potionAddedEvent.getEntityLiving();
        if (effectInstance.func_188419_a() == Effects.field_220310_F) {
            livingEntity.func_195063_d(DragonEffects.EVIL_DRAGON);
        }
    }

    @SubscribeEvent
    public static void specialTasks(EntityJoinWorldEvent joinWorldEvent) {
        World world = joinWorldEvent.getWorld();
        Entity entity = joinWorldEvent.getEntity();
        if (entity instanceof IronGolemEntity) {
            IronGolemEntity golemEntity = (IronGolemEntity)entity;
            golemEntity.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)golemEntity, PlayerEntity.class, 0, true, false, livingEntity -> DragonStateProvider.isDragon((Entity)livingEntity) && livingEntity.func_70644_a(DragonEffects.EVIL_DRAGON)));
        }
        if (entity instanceof AbstractVillagerEntity && !(entity instanceof Prince)) {
            AbstractVillagerEntity abstractVillagerEntity = (AbstractVillagerEntity)entity;
            abstractVillagerEntity.field_70714_bg.func_75776_a(10, (Goal)new AvoidEntityGoal((CreatureEntity)abstractVillagerEntity, PlayerEntity.class, livingEntity -> DragonStateProvider.isDragon((Entity)livingEntity) && livingEntity.func_70644_a(DragonEffects.EVIL_DRAGON), 16.0f, 1.0, 1.0, EntityPredicates.field_188444_d::test));
        }
    }

    @SubscribeEvent
    public static void interactions(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity playerEntity = event.getPlayer();
        Entity livingEntity = event.getTarget();
        if (livingEntity instanceof AbstractVillagerEntity && DragonStateProvider.isDragon((Entity)playerEntity) && playerEntity.func_70644_a(DragonEffects.EVIL_DRAGON)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEntity(AttackEntityEvent attackEntityEvent) {
        Entity attacked = attackEntityEvent.getTarget();
        PlayerEntity attacker = attackEntityEvent.getPlayer();
        if (attacked instanceof AbstractVillagerEntity) {
            if (attacker.func_70644_a(DragonEffects.EVIL_DRAGON)) {
                int duration = attacker.func_70660_b(DragonEffects.EVIL_DRAGON).func_76459_b();
                attacker.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, duration + Functions.secondsToTicks(5)));
            } else {
                attacker.func_195064_c((EffectInstance)new EffectInstance2(DragonEffects.EVIL_DRAGON, Functions.secondsToTicks(5)));
            }
        }
    }

    @SubscribeEvent
    public static void spawnHunters(TickEvent.PlayerTickEvent playerTickEvent) {
        ServerWorld serverWorld;
        PlayerEntity player;
        if (!dragonHunters.isEmpty() && playerTickEvent.phase == TickEvent.Phase.END && DragonStateProvider.isDragon((Entity)(player = playerTickEvent.player)) && player.func_70644_a(DragonEffects.EVIL_DRAGON) && !player.field_70170_p.field_72995_K && !player.func_184812_l_() && !player.func_175149_v() && player.func_70089_S() && (serverWorld = (ServerWorld)player.field_70170_p).func_234923_W_() == World.field_234918_g_) {
            Capabilities.getVillageRelationships((Entity)player).ifPresent(villageRelationShips -> {
                if (villageRelationShips.hunterSpawnDelay == 0) {
                    BlockPos spawnPosition = Functions.findRandomSpawnPosition(player, 1, 4, 14.0f);
                    if (spawnPosition != null) {
                        int levelOfEvil = VillagerRelationsHandler.computeLevelOfEvil(player);
                        for (int i = 0; i < levelOfEvil; ++i) {
                            Functions.spawn((MobEntity)Objects.requireNonNull(dragonHunters.get(serverWorld.field_73012_v.nextInt(dragonHunters.size())).func_200721_a((World)serverWorld)), spawnPosition, serverWorld);
                        }
                        villageRelationShips.hunterSpawnDelay = serverWorld.func_241119_a_(player.func_233580_cy_(), 3) ? Functions.minutesToTicks((Integer)ConfigHandler.COMMON.hunterSpawnDelay.get() / 3) + Functions.minutesToTicks(serverWorld.field_73012_v.nextInt((Integer)ConfigHandler.COMMON.hunterSpawnDelay.get() / 6)) : Functions.minutesToTicks((Integer)ConfigHandler.COMMON.hunterSpawnDelay.get()) + Functions.minutesToTicks(serverWorld.field_73012_v.nextInt((Integer)ConfigHandler.COMMON.hunterSpawnDelay.get() / 3));
                    }
                } else {
                    --villageRelationShips.hunterSpawnDelay;
                }
            });
        }
    }

    @SubscribeEvent
    public static void spawnPrinceOrPrincess(TickEvent.WorldTickEvent serverTickEvent) {
        ServerWorld serverWorld;
        World world = serverTickEvent.world;
        if (world instanceof ServerWorld && !(serverWorld = (ServerWorld)world).func_217369_A().isEmpty() && serverWorld.func_234923_W_() == World.field_234918_g_) {
            if (timeLeft == 0) {
                BlockPos blockPos;
                ServerPlayerEntity player = serverWorld.func_217472_l_();
                if (player != null && player.func_70089_S() && !player.func_184812_l_() && !player.func_175149_v() && (blockPos = Functions.findRandomSpawnPosition((PlayerEntity)player, 1, 2, 20.0f)) != null) {
                    EntityType<Princess> entityType = world.field_73012_v.nextBoolean() ? EntityTypesInit.PRINCESS_ON_HORSE : EntityTypesInit.PRINCE_ON_HORSE;
                    Princess princessEntity = (Princess)entityType.func_200721_a(world);
                    princessEntity.func_70107_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                    princessEntity.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(player.func_233580_cy_()), SpawnReason.NATURAL, null, null);
                    serverWorld.func_217376_c((Entity)princessEntity);
                    ListNBT pattern = new BannerPattern.Builder().func_222477_a(BannerPattern.values()[world.field_73012_v.nextInt(BannerPattern.values().length)], DyeColor.values()[world.field_73012_v.nextInt(DyeColor.values().length)]).func_222476_a();
                    int knights = world.field_73012_v.nextInt(3) + 3;
                    for (int i = 0; i < knights; ++i) {
                        Knight knightHunter = (Knight)EntityTypesInit.KNIGHT.func_200721_a((World)serverWorld);
                        knightHunter.func_70107_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                        knightHunter.field_70714_bg.func_75776_a(5, new FollowMobGoal<Class<Princess>>(Princess.class, (MobEntity)knightHunter, 8));
                        knightHunter.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(player.func_233580_cy_()), SpawnReason.NATURAL, null, null);
                        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_185159_cQ);
                        CompoundNBT compoundNBT = new CompoundNBT();
                        compoundNBT.func_74768_a("Base", princessEntity.getColor());
                        compoundNBT.func_218657_a("Patterns", (INBT)pattern);
                        itemStack.func_77983_a("BlockEntityTag", (INBT)compoundNBT);
                        knightHunter.func_184611_a(Hand.OFF_HAND, itemStack);
                        serverWorld.func_217376_c((Entity)knightHunter);
                    }
                    timeLeft = Functions.minutesToTicks((Integer)ConfigHandler.COMMON.princessSpawnDelay.get()) + Functions.minutesToTicks(world.field_73012_v.nextInt((Integer)ConfigHandler.COMMON.princessSpawnDelay.get() / 2));
                }
            } else {
                --timeLeft;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.END) {
            PlayerEntity playerEntity = playerTickEvent.player;
            if (!playerEntity.field_70170_p.field_72995_K && playerEntity.func_70644_a(DragonEffects.EVIL_DRAGON)) {
                Capabilities.getVillageRelationships((Entity)playerEntity).ifPresent(villageRelationShips -> {
                    villageRelationShips.evilStatusDuration = playerEntity.func_70660_b(DragonEffects.EVIL_DRAGON).func_76459_b();
                });
            }
        }
    }

    static {
        timeLeft = Functions.minutesToTicks((Integer)ConfigHandler.COMMON.princessSpawnDelay.get()) + Functions.minutesToTicks(ThreadLocalRandom.current().nextInt(30));
    }
}

