/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.network.RefreshDragons;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class WingObtainmentController {
    private static Map<String, Integer> dragonPhrases = new HashMap<String, Integer>();
    private static UUID enderDragonUUID = UUID.fromString("426642b9-2e88-4350-afa8-f99f75af5479");

    public static void loadDragonPhrases() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            return;
        }
        try {
            String file;
            ArrayList<String> langs = new ArrayList<String>();
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/dragonsurvival/lang");
            if (stream == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((file = reader.readLine()) != null) {
                langs.add(file);
            }
            reader.close();
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            for (String langFile : langs) {
                URL resource = Thread.currentThread().getContextClassLoader().getResource("assets/dragonsurvival/lang/" + langFile);
                Map langData = (Map)gson.fromJson(new String(Files.readAllBytes(Paths.get(resource.toURI()))), type);
                int phraseCount = 0;
                for (String key : langData.keySet()) {
                    if (!key.contains("ds.endmessage")) continue;
                    ++phraseCount;
                }
                if (phraseCount <= 0) continue;
                dragonPhrases.put(langFile.replace(".json", ""), phraseCount);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void inTheEnd(PlayerEvent.PlayerChangedDimensionEvent changedDimensionEvent) {
        PlayerEntity playerEntity = changedDimensionEvent.getPlayer();
        if (changedDimensionEvent.getTo() == World.field_234920_i_) {
            DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
                if (dragonStateHandler.isDragon() && !dragonStateHandler.hasWings()) {
                    Thread thread = new Thread(() -> {
                        try {
                            Thread.sleep(3000L);
                            playerEntity.func_145747_a((ITextComponent)new StringTextComponent("ds.endmessage"), enderDragonUUID);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    });
                    thread.start();
                }
            });
        }
    }

    @SubscribeEvent
    public static void clientMessageRecieved(ClientChatReceivedEvent event) {
        DragonSurvivalMod.LOGGER.info(event.getMessage().getString());
        if (event.getSenderUUID().equals(enderDragonUUID)) {
            if (event.getMessage().getString().equals("ds.endmessage")) {
                Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                int messageId = player.func_70681_au().nextInt(dragonPhrases.getOrDefault(language.getCode(), dragonPhrases.getOrDefault("en_us", 1))) + 1;
                event.setMessage((ITextComponent)new StringTextComponent(new TranslationTextComponent("ds.endmessage." + messageId).getString().replace("()", player.func_145748_c_().getString())));
            } else if (event.getMessage().getString().equals("ds.dragon.grants.wings")) {
                event.setMessage((ITextComponent)new TranslationTextComponent("ds.dragon.grants.wings"));
            }
        }
    }

    @SubscribeEvent
    public static void serverChatEvent(ServerChatEvent chatEvent) {
        String message = chatEvent.getMessage();
        ServerPlayerEntity playerEntity = chatEvent.getPlayer();
        String lowercase = message.toLowerCase();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && !dragonStateHandler.hasWings() && playerEntity.func_71121_q().func_234923_W_() == World.field_234920_i_ && !playerEntity.func_71121_q().func_217439_j().isEmpty() && !lowercase.isEmpty()) {
                Thread thread = new Thread(() -> {
                    try {
                        Thread.sleep(2000L);
                        playerEntity.func_145747_a((ITextComponent)new StringTextComponent("ds.dragon.grants.wings"), enderDragonUUID);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                });
                thread.start();
                dragonStateHandler.setHasWings(true);
                DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SynchronizeDragonCap(playerEntity.func_145782_y(), dragonStateHandler.isHiding(), dragonStateHandler.getType(), dragonStateHandler.getSize(), true, dragonStateHandler.getLavaAirSupply(), dragonStateHandler.getPassengerId()));
            }
        });
    }

    @SubscribeEvent
    public static void teleportAway(LivingDamageEvent damageEvent) {
        if (!((Boolean)ConfigHandler.COMMON.endVoidTeleport.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = damageEvent.getEntityLiving();
        if (livingEntity instanceof PlayerEntity) {
            DamageSource damageSource = damageEvent.getSource();
            if (livingEntity.field_70170_p.func_234923_W_() == World.field_234920_i_ && damageSource == DamageSource.field_76380_i && livingEntity.func_213303_ch().field_72448_b < -60.0) {
                DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
                    if (dragonStateHandler.isDragon()) {
                        livingEntity.func_241206_a_(livingEntity.func_184102_h().func_241755_D_());
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDragons(livingEntity.func_145782_y()));
                        damageEvent.setCanceled(true);
                    }
                });
            }
        }
    }
}

