/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.mixins;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.handlers.DragonSizeHandler;
import by.jackraidenph.dragonsurvival.util.DragonType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
extends CapabilityProvider<Entity> {
    @Shadow
    private EntitySize field_213325_aI;

    protected MixinEntity(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/entity/Entity;displayFireAnimation()Z"}, cancellable=true)
    private void hideCaveDragonFireAnimation(CallbackInfoReturnable<Boolean> ci) {
        DragonStateProvider.getCap((Entity)this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.getType() == DragonType.CAVE) {
                ci.setReturnValue((Object)false);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/entity/Entity;getPassengersRidingOffset()D"}, cancellable=true)
    public void getDragonPassengersRidingOffset(CallbackInfoReturnable<Double> ci) {
        if (DragonStateProvider.isDragon((Entity)this)) {
            switch (this.func_213283_Z()) {
                case FALL_FLYING: 
                case SWIMMING: 
                case SPIN_ATTACK: {
                    ci.setReturnValue((Object)((double)this.field_213325_aI.field_220316_b * 0.6));
                    break;
                }
                case CROUCHING: {
                    ci.setReturnValue((Object)((double)this.field_213325_aI.field_220316_b * 0.45));
                    break;
                }
                default: {
                    ci.setReturnValue((Object)((double)this.field_213325_aI.field_220316_b * 0.5));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/entity/Entity;isVisuallyCrawling()Z"}, cancellable=true)
    public void isDragonVisuallyCrawling(CallbackInfoReturnable<Boolean> ci) {
        if (DragonStateProvider.isDragon((Entity)this)) {
            ci.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"canEnterPose(Lnet/minecraft/entity/Pose;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getBoundingBoxForPose(Lnet/minecraft/entity/Pose;)Lnet/minecraft/util/math/AxisAlignedBB;"))
    public AxisAlignedBB dragonPoseBB(Entity entity, Pose pose) {
        if (DragonStateProvider.isDragon(entity) && ((Boolean)ConfigHandler.SERVER.sizeChangesHitbox.get()).booleanValue()) {
            float size = ((DragonStateHandler)DragonStateProvider.getCap(entity).orElseGet(null)).getSize();
            float height = DragonSizeHandler.calculateModifiedHeight(DragonSizeHandler.calculateDragonHeight(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get()), pose, (Boolean)ConfigHandler.SERVER.sizeChangesHitbox.get());
            float width = DragonSizeHandler.calculateDragonWidth(size, (Boolean)ConfigHandler.SERVER.hitboxGrowsPastHuman.get()) / 2.0f;
            Vector3d vector3d = new Vector3d(this.func_226277_ct_() - (double)width, this.func_226278_cu_(), this.func_226281_cx_() - (double)width);
            Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() + (double)width, this.func_226278_cu_() + (double)height, this.func_226281_cx_() + (double)width);
            return new AxisAlignedBB(vector3d, vector3d1);
        }
        return this.func_213321_d(pose);
    }

    @Shadow
    public Pose func_213283_Z() {
        throw new IllegalStateException("Mixin failed to shadow getPose()");
    }

    @Shadow
    public AxisAlignedBB func_213321_d(Pose pose) {
        throw new IllegalStateException("Mixin failed to shadow getBoundingBoxForPose()");
    }

    @Shadow
    public double func_226277_ct_() {
        throw new IllegalStateException("Mixin failed to shadow getX()");
    }

    @Shadow
    public double func_226278_cu_() {
        throw new IllegalStateException("Mixin failed to shadow getY()");
    }

    @Shadow
    public double func_226281_cx_() {
        throw new IllegalStateException("Mixin failed to shadow getZ()");
    }
}

