/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.mixins;

import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.handlers.DragonFoodHandler;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    @Shadow
    private ItemStack field_184627_bm;
    @Shadow
    private int field_184628_bn;

    public MixinLivingEntity(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/entity/LivingEntity;rideableUnderWater()Z"}, cancellable=true)
    public void dragonRideableUnderWater(CallbackInfoReturnable<Boolean> ci) {
        if (DragonStateProvider.isDragon(this)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"eat"}, cancellable=true)
    public void dragonEat(World level, ItemStack itemStack, CallbackInfoReturnable<ItemStack> ci) {
        DragonStateProvider.getCap(this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                if (DragonFoodHandler.isDragonEdible(itemStack.func_77973_b(), dragonStateHandler.getType())) {
                    level.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213353_d(itemStack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (level.field_73012_v.nextFloat() - level.field_73012_v.nextFloat()) * 0.4f);
                    this.func_213349_a(itemStack, level, (LivingEntity)this);
                    if (!(this instanceof PlayerEntity) || !((PlayerEntity)this).field_71075_bZ.field_75098_d) {
                        itemStack.func_190918_g(1);
                    }
                }
                ci.setReturnValue((Object)itemStack);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"addEatEffect"}, cancellable=true)
    public void addDragonEatEffect(ItemStack itemStack, World level, LivingEntity livingEntity, CallbackInfo ci) {
        DragonStateProvider.getCap(this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                Item item = itemStack.func_77973_b();
                if (DragonFoodHandler.isDragonEdible(item, dragonStateHandler.getType())) {
                    block4: for (Pair pair : DragonFoodHandler.getDragonFoodProperties(item, dragonStateHandler.getType()).func_221464_f()) {
                        if (level.field_72995_K || pair.getFirst() == null) continue;
                        if (!level.field_72995_K && pair.getFirst() != null && ((EffectInstance)pair.getFirst()).func_188419_a() != Effects.field_76438_s && level.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue()) {
                            livingEntity.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
                        }
                        if (((EffectInstance)pair.getFirst()).func_188419_a() != Effects.field_76438_s) continue;
                        if (livingEntity.func_70644_a(Effects.field_76438_s)) {
                            switch (livingEntity.func_70660_b(Effects.field_76438_s).func_76458_c()) {
                                case 0: {
                                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, ((EffectInstance)pair.getFirst()).func_76459_b(), ((EffectInstance)pair.getFirst()).func_76458_c() + 1));
                                    if (!(level.field_73012_v.nextFloat() < 0.25f)) continue block4;
                                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, ((EffectInstance)pair.getFirst()).func_76459_b(), 0));
                                    continue block4;
                                }
                                case 1: {
                                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, ((EffectInstance)pair.getFirst()).func_76459_b(), ((EffectInstance)pair.getFirst()).func_76458_c() + 2));
                                    if (!(level.field_73012_v.nextFloat() < 0.5f)) continue block4;
                                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, ((EffectInstance)pair.getFirst()).func_76459_b(), 0));
                                    continue block4;
                                }
                            }
                            livingEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, ((EffectInstance)pair.getFirst()).func_76459_b(), ((EffectInstance)pair.getFirst()).func_76458_c() + 2));
                            livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, ((EffectInstance)pair.getFirst()).func_76459_b(), 0));
                            continue;
                        }
                        if (!(level.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                        livingEntity.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
                    }
                }
                ci.cancel();
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldTriggerItemUseEffects"}, cancellable=true)
    public void shouldDragonTriggerItemUseEffects(CallbackInfoReturnable<Boolean> ci) {
        DragonStateProvider.getCap(this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                int i = this.func_184605_cv();
                Food food = this.field_184627_bm.func_77973_b().func_219967_s();
                boolean flag = food != null && food.func_221465_e();
                flag = flag || i <= DragonFoodHandler.getUseDuration(this.field_184627_bm, dragonStateHandler.getType()) - 7;
                ci.setReturnValue((Object)(flag && i % 4 == 0 ? 1 : 0));
            }
        });
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getUseDuration()I", shift=At.Shift.AFTER)}, method={"onSyncedDataUpdated"})
    public void onDragonSyncedDataUpdated(DataParameter<?> data, CallbackInfo ci) {
        DragonStateProvider.getCap(this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                this.field_184628_bn = DragonFoodHandler.getUseDuration(this.field_184627_bm, dragonStateHandler.getType());
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"triggerItemUseEffects"}, cancellable=true)
    public void triggerDragonItemUseEffects(ItemStack stack, int count, CallbackInfo ci) {
        DragonStateProvider.getCap(this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && !stack.func_190926_b() && this.func_184587_cr() && stack.func_77975_n() == UseAction.NONE && DragonFoodHandler.isDragonEdible(stack.func_77973_b(), dragonStateHandler.getType())) {
                this.func_195062_a(stack, count);
                this.func_184185_a(this.func_213353_d(stack), 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                ci.cancel();
            }
        });
    }

    @Shadow
    public void func_195062_a(ItemStack stack, int count) {
        throw new IllegalStateException("Mixin failed to shadow spawnItemParticles()");
    }

    @Shadow
    public boolean func_184587_cr() {
        throw new IllegalStateException("Mixin failed to shadow isUsingItem()");
    }

    @Shadow
    public int func_184605_cv() {
        throw new IllegalStateException("Mixin failed to shadow getUseItemRemainingTicks()");
    }

    @Shadow
    public void func_213349_a(ItemStack itemStack, World level, LivingEntity object) {
        throw new IllegalStateException("Mixin failed to shadow addEatEffect()");
    }

    @Shadow
    public SoundEvent func_213353_d(ItemStack itemStack) {
        throw new IllegalStateException("Mixin failed to shadow getEatingSound()");
    }
}

