/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.mixins;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.handlers.DragonFoodHandler;
import by.jackraidenph.dragonsurvival.handlers.DragonSizeHandler;
import by.jackraidenph.dragonsurvival.util.DragonType;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerEntity.class})
public abstract class MixinPlayerEntity
extends LivingEntity {
    @Shadow
    @Final
    public PlayerAbilities field_71075_bZ;
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> p_i48577_1_, World p_i48577_2_) {
        super(p_i48577_1_, p_i48577_2_);
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    public void travel(Vector3d p_213352_1_, CallbackInfo ci) {
        if (DragonStateProvider.isDragon((Entity)this)) {
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_();
            double d2 = this.func_226281_cx_();
            if (DragonStateProvider.getCap((Entity)this).isPresent() && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveLavaSwimming.get()).booleanValue() && ((DragonStateHandler)DragonStateProvider.getCap((Entity)this).orElseGet(null)).getType() == DragonType.CAVE && DragonSizeHandler.getOverridePose(this) == Pose.SWIMMING || this.func_203007_ba() && !this.func_184218_aH()) {
                double d4;
                double d3 = this.func_70040_Z().field_72448_b;
                double d = d4 = d3 < -0.2 ? 0.085 : 0.06;
                if (d3 <= 0.0 || this.field_70703_bu || !this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() + 1.0 - 0.1, this.func_226281_cx_())).func_204520_s().func_206888_e()) {
                    Vector3d vector3d1 = this.func_213322_ci();
                    this.func_213317_d(vector3d1.func_72441_c(0.0, (d3 - vector3d1.field_72448_b) * d4, 0.0));
                }
            }
            if (this.field_71075_bZ.field_75100_b && !this.func_184218_aH()) {
                double d5 = this.func_213322_ci().field_72448_b;
                float f = this.field_70747_aH;
                this.field_70747_aH = this.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
                this.dragonTravel(p_213352_1_);
                Vector3d vector3d = this.func_213322_ci();
                this.func_213293_j(vector3d.field_72450_a, d5 * 0.6, vector3d.field_72449_c);
                this.field_70747_aH = f;
                this.field_70143_R = 0.0f;
                this.func_70052_a(7, false);
            } else {
                this.dragonTravel(p_213352_1_);
            }
            this.func_71000_j(this.func_226277_ct_() - d0, this.func_226278_cu_() - d1, this.func_226281_cx_() - d2);
            ci.cancel();
        }
    }

    public void dragonTravel(Vector3d p_213352_1_) {
        if (!DragonStateProvider.isDragon((Entity)this)) {
            super.func_213352_e(p_213352_1_);
            return;
        }
        if (this.func_70613_aW() || this.func_184186_bw()) {
            boolean flag;
            double d0 = 0.08;
            ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = flag = this.func_213322_ci().field_72448_b <= 0.0;
            if (flag && this.func_70644_a(Effects.field_204839_B)) {
                if (!gravity.func_180374_a(SLOW_FALLING)) {
                    gravity.func_233767_b_(SLOW_FALLING);
                }
                this.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(SLOW_FALLING)) {
                gravity.func_111124_b(SLOW_FALLING);
            }
            d0 = gravity.func_111126_e();
            FluidState fluidstate = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d8 = this.func_226278_cu_();
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.02f;
                float f7 = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f5 = 0.96f;
                }
                this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d vector3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
                }
                this.func_213317_d(vector3d6.func_216372_d((double)f5, (double)0.8f, (double)f5));
                Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d2);
                if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + d8, vector3d2.field_72449_c)) {
                    this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c()) && ((Boolean)ConfigHandler.SERVER.bonuses.get()).booleanValue() && ((Boolean)ConfigHandler.SERVER.caveLavaSwimming.get()).booleanValue() && DragonStateProvider.getCap((Entity)this).isPresent() && ((DragonStateHandler)DragonStateProvider.getCap((Entity)this).orElseGet(null)).getType() == DragonType.CAVE) {
                double d8 = this.func_226278_cu_();
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.02f;
                float f7 = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f5 = 0.96f;
                }
                this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d vector3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
                }
                this.func_213317_d(vector3d6.func_216372_d((double)f5, (double)0.8f, (double)f5));
                Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d2);
                if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + d8, vector3d2.field_72449_c)) {
                    this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d7 = this.func_226278_cu_();
                this.func_213309_a(0.02f, p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.func_233571_b_((ITag)FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                    Vector3d vector3d3 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                    this.func_213317_d(vector3d3);
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                }
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                }
                Vector3d vector3d4 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                    this.func_213293_j(vector3d4.field_72450_a, 0.3f, vector3d4.field_72449_c);
                }
            } else if (this.func_184613_cA()) {
                double d10;
                double d6;
                float f2;
                Vector3d vector3d = this.func_213322_ci();
                if (vector3d.field_72448_b > -0.5) {
                    this.field_70143_R = 1.0f;
                }
                Vector3d vector3d1 = this.func_70040_Z();
                float f = this.field_70125_A * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vector3d1.field_72450_a * vector3d1.field_72450_a + vector3d1.field_72449_c * vector3d1.field_72449_c);
                double d3 = Math.sqrt(MixinPlayerEntity.func_213296_b((Vector3d)vector3d));
                double d4 = vector3d1.func_72433_c();
                float f1 = MathHelper.func_76134_b((float)f);
                f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
                vector3d = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
                if (vector3d.field_72448_b < 0.0 && d1 > 0.0) {
                    double d5 = vector3d.field_72448_b * -0.1 * (double)f1;
                    vector3d = vector3d.func_72441_c(vector3d1.field_72450_a * d5 / d1, d5, vector3d1.field_72449_c * d5 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d9 = d3 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                    vector3d = vector3d.func_72441_c(-vector3d1.field_72450_a * d9 / d1, d9 * 3.2, -vector3d1.field_72449_c * d9 / d1);
                }
                if (d1 > 0.0) {
                    vector3d = vector3d.func_72441_c((vector3d1.field_72450_a / d1 * d3 - vector3d.field_72450_a) * 0.1, 0.0, (vector3d1.field_72449_c / d1 * d3 - vector3d.field_72449_c) * 0.1);
                }
                this.func_213317_d(vector3d.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f2 = (float)((d6 = d3 - (d10 = Math.sqrt(MixinPlayerEntity.func_213296_b((Vector3d)this.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                    this.func_184185_a(this.func_184588_d((int)f2), 1.0f, 1.0f);
                    this.func_70097_a(DamageSource.field_188406_j, f2);
                }
                if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                    this.func_70052_a(7, false);
                }
            } else {
                BlockPos blockpos = this.func_226270_aj_();
                float f3 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).getSlipperiness((IWorldReader)this.field_70170_p, this.func_226270_aj_(), (Entity)this);
                float f4 = this.field_70122_E ? f3 * 0.91f : 0.91f;
                Vector3d vector3d5 = this.func_233633_a_(p_213352_1_, f3);
                double d2 = vector3d5.field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d2 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vector3d5.field_72448_b) * 0.2;
                    this.field_70143_R = 0.0f;
                } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                    d2 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.func_189652_ae()) {
                    d2 -= d0;
                }
                this.func_213293_j(vector3d5.field_72450_a * (double)f4, d2 * (double)0.98f, vector3d5.field_72449_c * (double)f4);
            }
        }
        this.func_233629_a_(this, this instanceof IFlyingAnimal);
    }

    @Inject(at={@At(value="HEAD")}, method={"eat"}, cancellable=true)
    public void dragonEat(World level, ItemStack itemStack, CallbackInfoReturnable<ItemStack> ci) {
        DragonStateProvider.getCap((Entity)this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                DragonFoodHandler.dragonEat(this.func_71024_bL(), itemStack.func_77973_b(), itemStack, dragonStateHandler.getType());
                this.func_71029_a((Stat<Item>)Stats.field_75929_E.func_199076_b((Object)itemStack.func_77973_b()));
                level.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if ((PlayerEntity)this instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)this, itemStack);
                }
                ci.setReturnValue((Object)super.func_213357_a(level, itemStack));
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/entity/player/PlayerEntity;getMyRidingOffset()D"}, cancellable=true)
    public void dragonRidingOffset(CallbackInfoReturnable<Double> ci) {
        DragonStateProvider.getCap((Entity)this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                ci.setReturnValue((Object)0.25);
            }
        });
    }

    @Shadow
    public FoodStats func_71024_bL() {
        throw new IllegalStateException("Mixin failed to shadow getFoodData()");
    }

    @Shadow
    public void func_71029_a(Stat<Item> stat) {
        throw new IllegalStateException("Mixin failed to shadow awardStat()");
    }

    @Shadow
    public void func_71000_j(double d, double e, double f) {
        throw new IllegalStateException("Mixin failed to shadow checkMovementStatistics()");
    }
}

