/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.network;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.PacketProxy;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class PacketSyncCapabilityMovement
implements IMessage<PacketSyncCapabilityMovement> {
    public int playerId;
    public double bodyYaw;
    public double headYaw;
    public double headPitch;
    public boolean bite;

    public PacketSyncCapabilityMovement() {
    }

    public PacketSyncCapabilityMovement(int playerId, double bodyYaw, double headYaw, double headPitch, boolean bite) {
        this.bodyYaw = bodyYaw;
        this.headYaw = headYaw;
        this.headPitch = headPitch;
        this.playerId = playerId;
        this.bite = bite;
    }

    @Override
    public void encode(PacketSyncCapabilityMovement m, PacketBuffer b) {
        b.writeInt(m.playerId);
        b.writeDouble(m.bodyYaw);
        b.writeDouble(m.headYaw);
        b.writeDouble(m.headPitch);
        b.writeBoolean(m.bite);
    }

    @Override
    public PacketSyncCapabilityMovement decode(PacketBuffer b) {
        return new PacketSyncCapabilityMovement(b.readInt(), b.readDouble(), b.readDouble(), b.readDouble(), b.readBoolean());
    }

    private void writeVec3d(PacketBuffer buffer, Vector3d vec) {
        buffer.writeDouble(vec.field_72450_a);
        buffer.writeDouble(vec.field_72448_b);
        buffer.writeDouble(vec.field_72449_c);
    }

    private Vector3d readVec3d(PacketBuffer buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        return new Vector3d(x, y, z);
    }

    @Override
    public void handle(PacketSyncCapabilityMovement syncCapabilityMovement, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> new PacketProxy().handleCapabilityMovement(syncCapabilityMovement, supplier));
            return;
        }
        Entity entity = player.field_70170_p.func_73045_a(syncCapabilityMovement.playerId);
        if (entity == null || entity.field_70170_p == null) {
            context.setPacketHandled(true);
            return;
        }
        if (entity instanceof PlayerEntity) {
            DragonStateProvider.getCap(entity).ifPresent(dragonStateHandler -> dragonStateHandler.setMovementData(syncCapabilityMovement.bodyYaw, syncCapabilityMovement.headYaw, syncCapabilityMovement.headPitch, syncCapabilityMovement.bite));
        }
        if (!entity.field_70170_p.field_72995_K) {
            DragonSurvivalMod.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)syncCapabilityMovement);
        }
        context.setPacketHandled(true);
    }
}

