/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.registration;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.gecko.DragonModel;
import by.jackraidenph.dragonsurvival.gecko.DragonRenderer;
import by.jackraidenph.dragonsurvival.gecko.KnightModel;
import by.jackraidenph.dragonsurvival.gecko.KnightRenderer;
import by.jackraidenph.dragonsurvival.gecko.PrinceModel;
import by.jackraidenph.dragonsurvival.gecko.PrinceRenderer;
import by.jackraidenph.dragonsurvival.gecko.PrincessModel;
import by.jackraidenph.dragonsurvival.gecko.PrincessRenderer;
import by.jackraidenph.dragonsurvival.gui.DragonScreen;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import by.jackraidenph.dragonsurvival.nest.NestScreen;
import by.jackraidenph.dragonsurvival.registration.BlockInit;
import by.jackraidenph.dragonsurvival.registration.Containers;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import by.jackraidenph.dragonsurvival.registration.TileEntityTypesInit;
import by.jackraidenph.dragonsurvival.renderer.HelmetEntityRenderer;
import by.jackraidenph.dragonsurvival.renderer.HunterHoundRenderer;
import by.jackraidenph.dragonsurvival.renderer.MagicalPredatorRenderer;
import by.jackraidenph.dragonsurvival.renderer.PredatorStarTESR;
import by.jackraidenph.dragonsurvival.renderer.ShooterHunterRenderer;
import by.jackraidenph.dragonsurvival.renderer.SquireHunterRenderer;
import by.jackraidenph.dragonsurvival.shader.ShaderHelper;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    public static KeyBinding TOGGLE_WINGS;
    public static final String SKINS = "https://raw.githubusercontent.com/DragonSurvivalTeam/DragonSurvival/master/src/test/resources/";

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("dragonsurvival", "te/star/cage"));
        event.addSprite(new ResourceLocation("dragonsurvival", "te/star/wind"));
        event.addSprite(new ResourceLocation("dragonsurvival", "te/star/open_eye"));
        event.addSprite(new ResourceLocation("dragonsurvival", "te/star/wind_vertical"));
        DragonSurvivalMod.LOGGER.info("Successfully added sprites!");
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        Minecraft minecraft = (Minecraft)event.getMinecraftSupplier().get();
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_stone, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_sandstone, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_red_sandstone, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_purpur_block, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_oak_log, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_nether_bricks, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_mossy_cobblestone, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.dragon_altar_blackstone, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.mediumCaveNest, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.mediumForestNest, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.mediumSeaNest, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.bigCaveNest, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.bigForestNest, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.bigSeaNest, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.birchDoor, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BlockInit.acaciaDoor, (RenderType)RenderType.func_228643_e_());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.MAGICAL_BEAST, MagicalPredatorRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.BOLAS_ENTITY, manager -> new SpriteRenderer(manager, minecraft.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.PRINCESS, manager -> new by.jackraidenph.dragonsurvival.renderer.PrincessRenderer(manager, (IReloadableResourceManager)minecraft.func_195551_G()));
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.HUNTER_HOUND, HunterHoundRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.SHOOTER_HUNTER, ShooterHunterRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.SQUIRE_HUNTER, SquireHunterRenderer::new);
        ClientRegistry.bindTileEntityRenderer(TileEntityTypesInit.PREDATOR_STAR_TILE_ENTITY_TYPE, PredatorStarTESR::new);
        ClientRegistry.bindTileEntityRenderer(TileEntityTypesInit.helmetTile, HelmetEntityRenderer::new);
        ShaderHelper.initShaders();
        ScreenManager.func_216911_a(Containers.nestContainer, NestScreen::new);
        ScreenManager.func_216911_a(Containers.dragonContainer, DragonScreen::new);
        TOGGLE_WINGS = new KeyBinding("Toggle wings", 71, "Dragon Survival");
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE_WINGS);
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.DRAGON, manager -> {
            ClientEvents.dragonModel = new DragonModel();
            return new DragonRenderer(manager, ClientEvents.dragonModel);
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.KNIGHT, manager -> new KnightRenderer(manager, new KnightModel()));
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.PRINCESS_ON_HORSE, manager -> new PrincessRenderer(manager, new PrincessModel()));
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesInit.PRINCE_ON_HORSE, manager -> new PrinceRenderer(manager, new PrinceModel()));
    }

    public static ResourceLocation loadCustomSkinForName(PlayerEntity playerEntity, DragonLevel dragonStage) throws IOException {
        URL url;
        String name = playerEntity.func_146103_bH().getName();
        switch (dragonStage) {
            case BABY: {
                url = new URL(SKINS + name + "_newborn.png");
                break;
            }
            case YOUNG: {
                url = new URL(SKINS + name + "_young.png");
                break;
            }
            case ADULT: {
                url = new URL(SKINS + name + "_adult.png");
                break;
            }
            default: {
                url = null;
            }
        }
        InputStream inputStream = url.openConnection().getInputStream();
        NativeImage customTexture = NativeImage.func_195713_a((InputStream)inputStream);
        ResourceLocation resourceLocation = new ResourceLocation("dragonsurvival", name.toLowerCase() + "_" + dragonStage.name);
        Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)new DynamicTexture(customTexture));
        return resourceLocation;
    }
}

