/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.registration;

import by.jackraidenph.dragonsurvival.entity.BolasEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.FoodStats;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DragonEffects {
    public static Effect STRESS;
    public static Effect TRAPPED;
    public static Effect EVIL_DRAGON;

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<Effect> effectRegister) {
        IForgeRegistry forgeRegistry = effectRegister.getRegistry();
        STRESS = (Effect)new Stress(16032488).setRegistryName("dragonsurvival", "stress");
        forgeRegistry.register((IForgeRegistryEntry)STRESS);
        TRAPPED = (Effect)new Trapped(EffectType.NEUTRAL, 0xDDDDDD).setRegistryName("dragonsurvival", "trapped");
        forgeRegistry.register((IForgeRegistryEntry)TRAPPED);
        EVIL_DRAGON = (Effect)new EvilDragon(EffectType.NEUTRAL).setRegistryName("dragonsurvival", "evil_dragon");
        forgeRegistry.register((IForgeRegistryEntry)EVIL_DRAGON);
    }

    private static class EvilDragon
    extends Effect {
        protected EvilDragon(EffectType p_i50391_1_) {
            super(p_i50391_1_, 13700608);
        }

        public List<ItemStack> getCurativeItems() {
            return Collections.emptyList();
        }
    }

    private static class Trapped
    extends Effect {
        protected Trapped(EffectType effectType, int color) {
            super(effectType, color);
        }

        public List<ItemStack> getCurativeItems() {
            return Collections.emptyList();
        }

        public boolean func_76397_a(int timeLeft, int p_76397_2_) {
            return timeLeft == 1;
        }

        public void func_76394_a(LivingEntity livingEntity, int strength) {
            livingEntity.func_110148_a(Attributes.field_233821_d_).func_188479_b(BolasEntity.DISABLE_MOVEMENT);
            livingEntity.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_188479_b(BolasEntity.DISABLE_JUMP);
        }
    }

    private static class Stress
    extends Effect {
        protected Stress(int color) {
            super(EffectType.HARMFUL, color);
        }

        public void func_76394_a(LivingEntity livingEntity, int p_76394_2_) {
            if (livingEntity instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)livingEntity;
                FoodStats food = playerEntity.func_71024_bL();
                if (food.func_75115_e() > 0.0f) {
                    int oldFood = food.func_75116_a();
                    food.func_75122_a(1, -0.5f * food.func_75115_e());
                    if (oldFood != 20) {
                        food.func_75114_a(food.func_75116_a() - 1);
                    }
                }
                playerEntity.func_71020_j(1.0f);
            }
        }

        public boolean func_76397_a(int p_76397_1_, int p_76397_2_) {
            int i = 20 >> p_76397_2_;
            if (i > 0) {
                return p_76397_1_ % i == 0;
            }
            return true;
        }
    }
}

