/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.registration;

import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.entity.BolasEntity;
import by.jackraidenph.dragonsurvival.entity.HunterHound;
import by.jackraidenph.dragonsurvival.entity.MagicalPredatorEntity;
import by.jackraidenph.dragonsurvival.entity.PrincessEntity;
import by.jackraidenph.dragonsurvival.entity.Shooter;
import by.jackraidenph.dragonsurvival.entity.Squire;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.gecko.Knight;
import by.jackraidenph.dragonsurvival.gecko.Prince;
import by.jackraidenph.dragonsurvival.gecko.Princess;
import by.jackraidenph.dragonsurvival.handlers.VillagerRelationsHandler;
import by.jackraidenph.dragonsurvival.registration.ItemsInit;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityTypesInit {
    private static final List<EntityType<?>> entities = Lists.newArrayList();
    private static final List<Item> spawnEggs = Lists.newArrayList();
    public static EntityType<MagicalPredatorEntity> MAGICAL_BEAST;
    public static EntityType<DragonEntity> DRAGON;
    public static EntityType<BolasEntity> BOLAS_ENTITY;
    public static EntityType<HunterHound> HUNTER_HOUND;
    public static EntityType<Shooter> SHOOTER_HUNTER;
    public static EntityType<Squire> SQUIRE_HUNTER;
    public static EntityType<PrincessEntity> PRINCESS;
    public static EntityType<Knight> KNIGHT;
    public static EntityType<Princess> PRINCESS_ON_HORSE;
    public static EntityType<Prince> PRINCE_ON_HORSE;

    private static <T extends CreatureEntity> EntityType<T> createEntity(Class<T> entityClass, EntityType.IFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("dragonsurvival", EntityTypesInit.classToString(entityClass));
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MONSTER).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        entity.setRegistryName(location);
        entities.add(entity);
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(ItemsInit.items));
        spawnEgg.setRegistryName(new ResourceLocation("dragonsurvival", EntityTypesInit.classToString(entityClass) + "_spawn_egg"));
        spawnEggs.add((Item)spawnEgg);
        return entity;
    }

    private static String classToString(Class<? extends CreatureEntity> entityClass) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
    }

    private static <T extends EntityType<?>> T cast(EntityType<?> entityType) {
        return (T)entityType;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        for (EntityType<?> entity : entities) {
            Preconditions.checkNotNull((Object)entity.getRegistryName(), (Object)"registryName");
            registry.register(entity);
            EntitySpawnPlacementRegistry.func_209343_a(entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        }
        DRAGON = new EntityType(DragonEntity::new, EntityClassification.MISC, true, false, false, false, ImmutableSet.of(), EntitySize.func_220311_c((float)0.9f, (float)1.9f), 0, 0);
        DRAGON.setRegistryName(new ResourceLocation("dragonsurvival", "dummy_dragon"));
        registry.register(DRAGON);
        BOLAS_ENTITY = EntityTypesInit.cast(EntityType.Builder.func_220322_a((p_create_1_, p_create_2_) -> new BolasEntity(p_create_2_), (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10).func_206830_a("bolas"));
        BOLAS_ENTITY.setRegistryName("dragonsurvival", "bolas");
        registry.register(BOLAS_ENTITY);
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        MAGICAL_BEAST = EntityTypesInit.createEntity(MagicalPredatorEntity.class, MagicalPredatorEntity::new, 1.1f, 1.5625f, 0, 0xFFFFFF);
        HUNTER_HOUND = EntityTypesInit.createEntity(HunterHound.class, HunterHound::new, 0.6f, 0.85f, 10510648, 8934192);
        SHOOTER_HUNTER = EntityTypesInit.createEntity(Shooter.class, Shooter::new, 0.6f, 1.95f, 12486764, 2690565);
        SQUIRE_HUNTER = EntityTypesInit.createEntity(Squire.class, Squire::new, 0.6f, 1.95f, 12486764, 5318420);
        PRINCESS = EntityTypesInit.createEntity(PrincessEntity.class, PrincessEntity::new, 0.6f, 1.9f, 16766495, 174864);
        KNIGHT = EntityTypesInit.createEntity(Knight.class, Knight::new, 0.8f, 2.5f, 0, 5310215);
        PRINCE_ON_HORSE = EntityTypesInit.createEntity(Prince.class, Prince::new, 0.8f, 2.5f, 0xFFDD1F, 174864);
        VillagerRelationsHandler.dragonHunters = new ArrayList<EntityType<? extends CreatureEntity>>(4);
        if (((Boolean)ConfigHandler.COMMON.spawnHound.get()).booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((EntityType<? extends CreatureEntity>)EntityTypesInit.cast(HUNTER_HOUND));
        }
        if (((Boolean)ConfigHandler.COMMON.spawnSquire.get()).booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((EntityType<? extends CreatureEntity>)EntityTypesInit.cast(SQUIRE_HUNTER));
        }
        if (((Boolean)ConfigHandler.COMMON.spawnHunter.get()).booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((EntityType<? extends CreatureEntity>)EntityTypesInit.cast(SHOOTER_HUNTER));
        }
        if (((Boolean)ConfigHandler.COMMON.spawnKnight.get()).booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((EntityType<? extends CreatureEntity>)EntityTypesInit.cast(KNIGHT));
        }
        PRINCESS_ON_HORSE = EntityTypesInit.createEntity(Princess.class, Princess::new, 0.8f, 2.5f, 16766495, 174864);
        for (Item spawnEgg : spawnEggs) {
            Preconditions.checkNotNull((Object)spawnEgg.getRegistryName(), (Object)"registry name is null");
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }

    @SubscribeEvent
    public static void attributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put(MAGICAL_BEAST, MagicalPredatorEntity.createMonsterAttributes().func_233813_a_());
        event.put(DRAGON, DragonEntity.func_233639_cI_().func_233813_a_());
        event.put(HUNTER_HOUND, WolfEntity.func_234233_eS_().func_233815_a_(Attributes.field_233821_d_, ((Double)ConfigHandler.COMMON.houndSpeed.get()).doubleValue()).func_233815_a_(Attributes.field_233823_f_, ((Double)ConfigHandler.COMMON.houndDamage.get()).doubleValue()).func_233815_a_(Attributes.field_233818_a_, ((Double)ConfigHandler.COMMON.houndHealth.get()).doubleValue()).func_233813_a_());
        event.put(SHOOTER_HUNTER, PillagerEntity.func_234296_eI_().func_233815_a_(Attributes.field_233821_d_, ((Double)ConfigHandler.COMMON.hunterSpeed.get()).doubleValue()).func_233815_a_(Attributes.field_233818_a_, ((Double)ConfigHandler.COMMON.houndHealth.get()).doubleValue()).func_233815_a_(Attributes.field_233826_i_, ((Double)ConfigHandler.COMMON.hunterArmor.get()).doubleValue()).func_233815_a_(Attributes.field_233823_f_, ((Double)ConfigHandler.COMMON.hunterDamage.get()).doubleValue()).func_233813_a_());
        event.put(SQUIRE_HUNTER, VindicatorEntity.func_234322_eI_().func_233815_a_(Attributes.field_233821_d_, ((Double)ConfigHandler.COMMON.squireSpeed.get()).doubleValue()).func_233815_a_(Attributes.field_233823_f_, ((Double)ConfigHandler.COMMON.squireDamage.get()).doubleValue()).func_233815_a_(Attributes.field_233826_i_, ((Double)ConfigHandler.COMMON.squireArmor.get()).doubleValue()).func_233815_a_(Attributes.field_233818_a_, ((Double)ConfigHandler.COMMON.squireHealth.get()).doubleValue()).func_233813_a_());
        event.put(PRINCESS, VillagerEntity.func_234551_eU_().func_233813_a_());
        event.put(PRINCESS_ON_HORSE, VillagerEntity.func_234551_eU_().func_233813_a_());
        event.put(KNIGHT, Knight.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, ((Double)ConfigHandler.COMMON.knightSpeed.get()).doubleValue()).func_233815_a_(Attributes.field_233823_f_, ((Double)ConfigHandler.COMMON.knightDamage.get()).doubleValue()).func_233815_a_(Attributes.field_233826_i_, ((Double)ConfigHandler.COMMON.knightArmor.get()).doubleValue()).func_233815_a_(Attributes.field_233818_a_, ((Double)ConfigHandler.COMMON.knightHealth.get()).doubleValue()).func_233813_a_());
        event.put(PRINCE_ON_HORSE, VillagerEntity.func_234551_eU_().func_233815_a_(Attributes.field_233823_f_, ((Double)ConfigHandler.COMMON.princeDamage.get()).doubleValue()).func_233815_a_(Attributes.field_233818_a_, ((Double)ConfigHandler.COMMON.princeHealth.get()).doubleValue()).func_233815_a_(Attributes.field_233826_i_, ((Double)ConfigHandler.COMMON.princeArmor.get()).doubleValue()).func_233815_a_(Attributes.field_233821_d_, ((Double)ConfigHandler.COMMON.princeSpeed.get()).doubleValue()).func_233813_a_());
    }
}

