/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.renderer;

import by.jackraidenph.dragonsurvival.registration.BlockInit;
import by.jackraidenph.dragonsurvival.tiles.HelmetEntity;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class HelmetEntityRenderer
extends TileEntityRenderer<HelmetEntity> {
    private static final Map<Block, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.func_200696_a((Object)Maps.newHashMap(), resourceLocationHashMap -> {
        resourceLocationHashMap.put(BlockInit.helmet1, new ResourceLocation("dragonsurvival", "textures/block/broken_knight_helmet_0.png"));
        resourceLocationHashMap.put(BlockInit.helmet2, new ResourceLocation("dragonsurvival", "textures/block/broken_knight_helmet_1.png"));
        resourceLocationHashMap.put(BlockInit.helmet3, new ResourceLocation("dragonsurvival", "textures/block/broken_knight_helmet_2.png"));
    });
    static GenericHeadModel humanoidHeadModel = new HumanoidHeadModel();

    public HelmetEntityRenderer(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void render(HelmetEntity helmetEntity, float p_225616_2_, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int p_225616_5_, int p_225616_6_) {
        BlockState blockstate = helmetEntity.func_195044_w();
        float f1 = 22.5f * (float)((Integer)blockstate.func_177229_b((Property)SkullBlock.field_196294_a)).intValue();
        HelmetEntityRenderer.renderHelmet(null, f1, blockstate.func_177230_c(), 0.0f, matrixStack, renderTypeBuffer, p_225616_5_);
    }

    public static void renderHelmet(@Nullable Direction direction, float p_228879_1_, Block helmetBlock, float p_228879_4_, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int p_228879_7_) {
        matrixStack.func_227860_a_();
        if (direction == null) {
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        } else {
            matrixStack.func_227861_a_((double)(0.5f - (float)direction.func_82601_c() * 0.25f), 0.25, (double)(0.5f - (float)direction.func_82599_e() * 0.25f));
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = renderTypeBuffer.getBuffer(HelmetEntityRenderer.getRenderType(helmetBlock));
        humanoidHeadModel.func_225603_a_(p_228879_4_, p_228879_1_, 0.0f);
        humanoidHeadModel.func_225598_a_(matrixStack, ivertexbuilder, p_228879_7_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    private static RenderType getRenderType(Block block) {
        ResourceLocation resourcelocation = TEXTURE_BY_TYPE.get(block);
        return RenderType.func_239267_e_((ResourceLocation)resourcelocation);
    }
}

