/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dynamical_compass.elements.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.dynamical_compass.elements.items.ModItems;
import de.geheimagentnr1.dynamical_compass.elements.items.dynamical_compass.DynamicalCompassItemStackHelper;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class GiveDCCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder giveDC = (LiteralArgumentBuilder)Commands.m_82127_((String)"giveDC").requires(source -> source.m_6761_(2));
        giveDC.then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"destination", (ArgumentType)Vec2Argument.m_120822_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"locked", (ArgumentType)BoolArgumentType.bool()).executes(GiveDCCommand::giveDC)))));
        dispatcher.register(giveDC);
    }

    private static int giveDC(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection playerEntities = EntityArgument.m_91477_(context, (String)"targets");
        ServerLevel level = DimensionArgument.m_88808_(context, (String)"dimension");
        Vec2 vecPos = Vec2Argument.m_120825_(context, (String)"destination");
        BlockPos pos = new BlockPos((double)vecPos.f_82470_, 0.0, (double)vecPos.f_82471_);
        boolean locked = BoolArgumentType.getBool(context, (String)"locked");
        for (ServerPlayer player : playerEntities) {
            ItemEntity entity;
            ItemStack stack = GiveDCCommand.createItemstack(level, pos, locked);
            boolean couldAdd = player.m_150109_().m_36054_(stack);
            if (couldAdd && stack.m_41619_()) {
                stack.m_41764_(1);
                entity = player.m_36176_(stack, false);
                if (entity != null) {
                    entity.m_32065_();
                }
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_21187_().nextFloat() - player.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.f_36095_.m_38946_();
                continue;
            }
            entity = player.m_36176_(stack, false);
            if (entity == null) continue;
            entity.m_32061_();
            entity.m_32047_(player.m_142081_());
        }
        ItemStack stack = GiveDCCommand.createItemstack(level, pos, locked);
        if (playerEntities.size() == 1) {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, stack.m_41611_(), ((ServerPlayer)playerEntities.iterator().next()).m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, stack.m_41611_(), playerEntities.size()}), true);
        }
        return playerEntities.size();
    }

    private static ItemStack createItemstack(ServerLevel level, BlockPos pos, boolean locked) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DYNAMICAL_COMPASS);
        DynamicalCompassItemStackHelper.setDimensionAndPos(stack, (Level)level, pos);
        DynamicalCompassItemStackHelper.setLocked(stack, locked);
        return stack;
    }
}

