/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.IngredientSerializers;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.MatchType;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NBTIngredient
extends Ingredient {
    static final String registry_name = "nbt";
    private final ItemStack stack;
    private final MatchType matchType;

    private NBTIngredient(ItemStack _stack, MatchType _matchType) {
        super(Stream.of(new Ingredient.ItemValue(_stack)));
        this.stack = _stack;
        this.matchType = _matchType;
    }

    public static NBTIngredient fromStack(ItemStack _stack, MatchType _matchType) {
        return new NBTIngredient(_stack, _matchType);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || this.stack.m_41720_() != input.m_41720_() || this.stack.m_41773_() != input.m_41773_()) {
            return false;
        }
        return switch (this.matchType) {
            case MatchType.EQUAL -> this.stack.areShareTagsEqual(input);
            case MatchType.CONTAINS -> this.containsNBT((Tag)this.stack.m_41783_(), (Tag)input.m_41783_());
            case MatchType.CONTAINS_NONE -> this.containsNoneNBT((Tag)this.stack.m_41783_(), (Tag)input.m_41783_());
            case MatchType.NOT_EQUAL -> {
                if (!this.stack.areShareTagsEqual(input)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private boolean containsNBT(@Nullable Tag nbt1, @Nullable Tag nbt2) {
        if (nbt1 == nbt2) {
            return true;
        }
        if (nbt1 == null) {
            return true;
        }
        if (nbt2 == null) {
            return false;
        }
        if (nbt1.getClass().equals(nbt2.getClass())) {
            Tag tag = nbt1;
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                CompoundTag compoundTag1 = (CompoundTag)nbt2;
                for (String key : compoundTag.m_128431_()) {
                    Tag inbt1 = compoundTag.m_128423_(key);
                    if (this.containsNBT(inbt1, compoundTag1.m_128423_(key))) continue;
                    return false;
                }
                return true;
            }
            Tag tag2 = nbt1;
            if (tag2 instanceof ListTag) {
                ListTag listTag = (ListTag)tag2;
                ListTag listTag1 = (ListTag)nbt2;
                if (listTag.isEmpty()) {
                    return listTag1.isEmpty();
                }
                for (Tag inbt : listTag) {
                    boolean containsNone = true;
                    for (Tag value : listTag1) {
                        if (!this.containsNBT(inbt, value)) continue;
                        containsNone = false;
                        break;
                    }
                    if (!containsNone) continue;
                    return false;
                }
                return true;
            }
            return nbt1.equals(nbt2);
        }
        return false;
    }

    private boolean containsNoneNBT(@Nullable Tag nbt1, @Nullable Tag nbt2) {
        if (nbt1 == nbt2) {
            return false;
        }
        if (nbt1 == null) {
            return false;
        }
        if (nbt2 == null) {
            return true;
        }
        if (nbt1.getClass().equals(nbt2.getClass())) {
            Tag tag = nbt1;
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                CompoundTag compoundTag1 = (CompoundTag)nbt2;
                for (String key : compoundTag.m_128431_()) {
                    Tag inbt1 = compoundTag.m_128423_(key);
                    if (this.containsNoneNBT(inbt1, compoundTag1.m_128423_(key))) continue;
                    return false;
                }
                return true;
            }
            Tag tag2 = nbt1;
            if (tag2 instanceof ListTag) {
                ListTag listTag = (ListTag)tag2;
                ListTag listTag1 = (ListTag)nbt2;
                if (listTag.isEmpty()) {
                    return false;
                }
                for (Tag inbt : listTag) {
                    boolean contains = false;
                    for (Tag value : listTag1) {
                        if (this.containsNoneNBT(inbt, value)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    return false;
                }
                return true;
            }
            return !nbt1.equals(nbt2);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializers.NBT_INGREDIENT;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID(IngredientSerializers.NBT_INGREDIENT)).toString());
        json.addProperty("item", Objects.requireNonNull(this.stack.m_41720_().getRegistryName()).toString());
        json.addProperty("count", (Number)this.stack.m_41613_());
        if (this.stack.m_41782_()) {
            json.addProperty(registry_name, this.stack.m_41784_().toString());
        }
        return json;
    }

    ItemStack getStack() {
        return this.stack;
    }

    MatchType getMatchType() {
        return this.matchType;
    }
}

