/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.renaming;

import de.geheimagentnr1.recipes_lib.elements.recipes.RecipeSerializers;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.MatchType;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.NBTIngredient;
import de.geheimagentnr1.recipes_lib.helpers.ShaplessRecipesHelper;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RenamingRecipe
implements CraftingRecipe {
    public static final String registry_name = "renaming";
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    RenamingRecipe(ResourceLocation _id, Ingredient _ingredient) {
        this.id = _id;
        this.ingredient = _ingredient;
        this.ingredients = NonNullList.m_122779_();
        this.ingredients.addAll(Arrays.asList(this.buildNameTagIngredient(), this.ingredient));
        this.isSimple = this.ingredients.stream().allMatch(Ingredient::isSimple);
    }

    private Ingredient buildNameTagIngredient() {
        CompoundTag name_tag_nbt = new CompoundTag();
        name_tag_nbt.m_128365_("display", (Tag)new CompoundTag());
        ItemStack stack = new ItemStack((ItemLike)Items.f_42656_);
        stack.m_41751_(name_tag_nbt);
        return NBTIngredient.fromStack(stack, MatchType.CONTAINS);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializers.RENAMING;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.ingredient.m_43908_()[0];
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean matches(@Nonnull CraftingContainer container, @Nonnull Level level) {
        return ShaplessRecipesHelper.matches(this, container, this.ingredients, this.isSimple);
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer container) {
        ItemStack stack;
        int j;
        ItemStack result = ItemStack.f_41583_;
        Component resultDisplayName = null;
        for (j = 0; j < container.m_6643_(); ++j) {
            stack = container.m_8020_(j);
            if (stack.m_41619_() || stack.m_41720_() == Items.f_42656_) continue;
            result = stack.m_41777_();
        }
        for (j = 0; j < container.m_6643_(); ++j) {
            stack = container.m_8020_(j);
            if (stack.m_41720_() != Items.f_42656_) continue;
            resultDisplayName = stack.m_41786_();
        }
        if (result.m_41786_().equals(resultDisplayName)) {
            return ItemStack.f_41583_;
        }
        result.m_41714_(resultDisplayName);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }
}

