/*
 * Decompiled with CFR 0.152.
 */
package com.danczer.excavator;

import com.danczer.excavator.ExcavatorContainer;
import com.danczer.excavator.ExcavatorMinecartLogic;
import com.danczer.excavator.ExcavatorMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExcavatorMinecartEntity
extends ContainerMinecartEntity
implements IHopper {
    private static final DataParameter<Integer> MINING_STATUS = EntityDataManager.func_187226_a(FurnaceMinecartEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double CollectBlockWithHardness = 3.0;
    private static final double MinecartPushForce = 0.005;
    private final ExcavatorMinecartLogic logic = new ExcavatorMinecartLogic(this);
    private final List<Item> Rails = new ArrayList<Item>();
    private final List<Item> Torches = new ArrayList<Item>();
    private boolean isBlocked = true;
    private int transferTicker = -1;
    private final BlockPos lastPosition = BlockPos.field_177992_a;

    public ExcavatorMinecartEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ExcavatorMod.EXCAVATOR_ENTITY, worldIn);
        this.Init();
    }

    public ExcavatorMinecartEntity(EntityType<? extends ExcavatorMinecartEntity> type, World worldIn) {
        super(type, worldIn);
        this.Init();
    }

    public ExcavatorMinecartEntity(World worldIn, double x, double y, double z) {
        super(ExcavatorMod.EXCAVATOR_ENTITY, x, y, z, worldIn);
        this.Init();
    }

    private void Init() {
        this.Torches.clear();
        this.Torches.add(Items.field_221657_bQ);
        this.Torches.add(Items.field_221764_cr);
        this.Torches.add(Items.field_234737_dp_);
        this.Rails.clear();
        this.Rails.add(Items.field_221742_cg);
        this.Rails.add(Items.field_221666_au);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MINING_STATUS, (Object)ExcavatorMinecartLogic.MiningStatus.Rolling.ordinal());
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return null;
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)ExcavatorMod.EXCAVATOR_ITEM);
    }

    public BlockState func_180457_u() {
        return Blocks.field_150451_bX.func_176223_P();
    }

    public int func_94085_r() {
        return 1;
    }

    public int func_70302_i_() {
        return 9;
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        boolean flag;
        boolean bl = flag = !receivingPower;
        if (flag != this.getBlocked()) {
            this.setBlocked(flag);
        }
    }

    public boolean getBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public World func_145831_w() {
        return this.field_70170_p;
    }

    public double func_96107_aA() {
        return this.func_226277_ct_();
    }

    public double func_96109_aB() {
        return this.func_226278_cu_() + 0.5;
    }

    public double func_96108_aC() {
        return this.func_226281_cx_();
    }

    public boolean isInventoryFull() {
        if (this.func_191420_l()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_77973_b() == this.logic.railTypeItem || itemStack.func_77973_b() == this.logic.torchTypeItem || !itemStack.func_190926_b() && itemStack.func_190916_E() >= itemStack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.logic.writeAdditional(compound);
        compound.func_74768_a("TransferCooldown", this.transferTicker);
        compound.func_74757_a("Enabled", this.isBlocked);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.logic.readAdditional(compound);
        this.transferTicker = compound.func_74762_e("TransferCooldown");
        this.isBlocked = compound.func_74764_b("Enabled") ? compound.func_74767_n("Enabled") : true;
    }

    public void func_70071_h_() {
        ExcavatorMinecartLogic.MiningStatus prevStatus = this.logic.miningStatus;
        this.excavatorTick();
        if (this.logic.miningStatus == ExcavatorMinecartLogic.MiningStatus.Rolling) {
            if (prevStatus == ExcavatorMinecartLogic.MiningStatus.Mining) {
                LOGGER.debug("Minecart Pushed");
                this.func_213317_d(this.logic.getDirectoryVector().func_186678_a(0.005));
            }
            super.func_70071_h_();
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.hopperTick();
    }

    private void excavatorTick() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.getBlocked()) {
            this.logic.railTypeItem = this.findRailTypeItem();
            this.logic.torchTypeItem = this.findTorchTypeItem();
            boolean isFull = this.isInventoryFull();
            LOGGER.debug("isFull: " + isFull);
            if (!isFull) {
                this.logic.tick();
                this.setMiningStatus(this.logic.miningStatus);
                LOGGER.debug("Logic MiningStatus: " + (Object)((Object)this.logic.miningStatus));
            } else {
                this.setMiningStatus(ExcavatorMinecartLogic.MiningStatus.DepletedConsumable);
            }
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.showMiningStatus();
        }
    }

    public BlockItem findRailTypeItem() {
        return this.findInventoryItem(this.Rails);
    }

    public BlockItem findTorchTypeItem() {
        return this.findInventoryItem(this.Torches);
    }

    public BlockItem findInventoryItem(List<Item> items) {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            Item item = itemStack.func_77973_b();
            if (itemStack.func_190926_b() || !items.contains(item) || !(item instanceof BlockItem)) continue;
            return (BlockItem)item;
        }
        return null;
    }

    public boolean reduceInventoryItem(Item item) {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != item) continue;
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    private void showMiningStatus() {
        ExcavatorMinecartLogic.MiningStatus miningStatus = this.getMiningStatus();
        LOGGER.debug("Hazard: " + (Object)((Object)miningStatus));
        BasicParticleType particleType = null;
        switch (miningStatus) {
            case Mining: {
                particleType = ParticleTypes.field_197594_E;
                break;
            }
            case HazardCliff: {
                particleType = ParticleTypes.field_197625_r;
                break;
            }
            case HazardLava: {
                particleType = ParticleTypes.field_218423_k;
                break;
            }
            case HazardWater: {
                particleType = ParticleTypes.field_218425_n;
                break;
            }
            case HazardUnknownFluid: {
                particleType = ParticleTypes.field_197612_e;
                break;
            }
            case DepletedConsumable: {
                particleType = ParticleTypes.field_197607_R;
                break;
            }
            case EmergencyStop: {
                particleType = ParticleTypes.field_218420_D;
                break;
            }
        }
        if (particleType != null) {
            this.field_70170_p.func_195594_a((IParticleData)particleType, this.func_226277_ct_(), this.func_226278_cu_() + 0.8, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private ExcavatorMinecartLogic.MiningStatus getMiningStatus() {
        return ExcavatorMinecartLogic.MiningStatus.Find((Integer)this.field_70180_af.func_187225_a(MINING_STATUS));
    }

    private void setMiningStatus(ExcavatorMinecartLogic.MiningStatus miningStatus) {
        this.field_70180_af.func_187227_b(MINING_STATUS, (Object)miningStatus.Value);
    }

    private void hopperTick() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.getBlocked()) {
            BlockPos blockpos = this.func_233580_cy_();
            if (blockpos.equals((Object)this.lastPosition)) {
                --this.transferTicker;
            } else {
                this.setTransferTicker(0);
            }
            if (!this.canTransfer()) {
                this.setTransferTicker(0);
                if (this.captureDroppedItems()) {
                    this.setTransferTicker(4);
                    this.func_70296_d();
                }
            }
        }
    }

    public void setTransferTicker(int transferTickerIn) {
        this.transferTicker = transferTickerIn;
    }

    public boolean canTransfer() {
        return this.transferTicker > 0;
    }

    public boolean captureDroppedItems() {
        List list = this.field_70170_p.func_175647_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(0.25, 0.0, 0.25), EntityPredicates.field_94557_a);
        for (ItemEntity itemEntity : list) {
            Item item = itemEntity.func_92059_d().func_77973_b();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                BlockState blockState = blockItem.func_179223_d().func_176223_P();
                if (item != Items.field_151137_ax && (!blockState.func_235783_q_() || !((double)blockState.func_185887_b((IBlockReader)this.field_70170_p, this.func_233580_cy_()) >= 3.0))) continue;
                HopperTileEntity.func_200114_a((IInventory)this, (ItemEntity)itemEntity);
                continue;
            }
            HopperTileEntity.func_200114_a((IInventory)this, (ItemEntity)itemEntity);
        }
        return false;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)Blocks.field_190976_dk);
            this.func_199703_a((IItemProvider)Blocks.field_150451_bX);
            this.func_199703_a((IItemProvider)Blocks.field_150438_bZ);
        }
    }

    public Container func_213968_a(int id, PlayerInventory playerInventoryIn) {
        return new ExcavatorContainer(id, playerInventoryIn, (IInventory)this);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

