/*
 * Decompiled with CFR 0.152.
 */
package com.danczer.excavator;

import com.danczer.excavator.ExcavatorMinecartEntity;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExcavatorMinecartLogic {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MiningTimeShovel = 8;
    private static final int MiningTimePickAxe = 19;
    private static final int MiningCountZ = 3;
    private static final int TorchPlacementDistance = 6;
    private static final float MaxMiningHardness = 50.0f;
    private final World world;
    private final ExcavatorMinecartEntity minecartEntity;
    private static final Item pickaxeItem = Items.field_151035_b;
    private static final Item shovelItem = Items.field_151037_a;
    private BlockPos lastTorchPos;
    private BlockPos miningPos;
    private Direction miningDir;
    private int miningBlockTick = 0;
    private int miningStackTick = 0;
    private int previousProgress = 0;
    private boolean isMinecartTurning;
    public BlockItem railTypeItem;
    public BlockItem torchTypeItem;
    public MiningStatus miningStatus = MiningStatus.Rolling;

    public ExcavatorMinecartLogic(ExcavatorMinecartEntity minecartEntity) {
        this.minecartEntity = minecartEntity;
        this.world = minecartEntity.field_70170_p;
    }

    public void readAdditional(CompoundNBT compound) {
        long miningPos = compound.func_74763_f("miningPos");
        this.miningPos = miningPos == 0L ? null : BlockPos.func_218283_e((long)miningPos);
        long torchPos = compound.func_74763_f("lastTorchPos");
        this.lastTorchPos = torchPos == 0L ? null : BlockPos.func_218283_e((long)torchPos);
        int dirIndex = compound.func_74762_e("miningDir");
        this.miningDir = dirIndex == 0 ? null : Direction.func_82600_a((int)dirIndex);
        this.miningBlockTick = compound.func_74762_e("miningTimerTick");
        this.miningStackTick = compound.func_74762_e("miningCountTick");
    }

    public void writeAdditional(CompoundNBT compound) {
        compound.func_74772_a("miningPos", this.miningPos == null ? 0L : this.miningPos.func_218275_a());
        compound.func_74772_a("lastTorchPos", this.lastTorchPos == null ? 0L : this.lastTorchPos.func_218275_a());
        compound.func_74768_a("miningDir", this.miningDir == null ? 0 : this.miningDir.func_176745_a());
        compound.func_74768_a("miningTimerTick", this.miningBlockTick);
        compound.func_74768_a("miningCountTick", this.miningStackTick);
    }

    public Vector3d getDirectoryVector() {
        if (this.miningDir == null) {
            return Vector3d.field_186680_a;
        }
        switch (this.miningDir) {
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return new Vector3d(this.toVector3f(this.miningDir)).func_72432_b();
            }
        }
        return Vector3d.field_186680_a;
    }

    public Vector3f toVector3f(Direction dir) {
        return new Vector3f((float)dir.func_82601_c(), (float)dir.func_96559_d(), (float)dir.func_82599_e());
    }

    public void tick() {
        if (this.railTypeItem == null || this.torchTypeItem == null) {
            this.resetMining();
            this.miningStatus = MiningStatus.DepletedConsumable;
            return;
        }
        BlockPos minecartPos = this.minecartEntity.func_233580_cy_();
        LOGGER.debug("minecartEntity minecartPos: " + minecartPos);
        BlockPos frontPos = this.getMiningPlace(minecartPos);
        LOGGER.debug("FrontPos: " + frontPos);
        if (frontPos == null) {
            this.resetMining();
        } else {
            this.miningStatus = this.checkFrontStatus(frontPos, minecartPos);
            LOGGER.debug("miningStatus: " + (Object)((Object)this.miningStatus));
            if (this.miningStatus == MiningStatus.Rolling) {
                this.miningDone(frontPos);
            } else if (this.miningStatus == MiningStatus.Mining) {
                if (this.miningPos == null) {
                    this.beginMining(frontPos.func_177967_a(Direction.UP, 2));
                    this.miningStackTick = 0;
                    LOGGER.debug("beginMining");
                } else {
                    boolean isBlockMined = this.tickBlockMining();
                    if (isBlockMined) {
                        ++this.miningStackTick;
                        if (this.miningStackTick > 3) {
                            this.miningDone(frontPos);
                        } else {
                            this.beginMining(this.miningPos.func_177977_b());
                        }
                    }
                }
            }
        }
    }

    private BlockPos getMiningPlace(BlockPos pos) {
        if (!this.isRailTrack(pos)) {
            return null;
        }
        Vector3d motion = this.minecartEntity.func_213322_ci();
        LOGGER.debug("minecartEntity getMotion: " + motion);
        Direction dir = motion.func_189985_c() <= 1.0E-4 ? this.miningDir : Direction.func_210769_a((double)motion.field_72450_a, (double)motion.field_72448_b, (double)motion.field_72449_c);
        LOGGER.debug("minecartEntity dir: " + dir);
        if (dir == null) {
            return null;
        }
        BlockState bs = this.world.func_180495_p(pos);
        AbstractRailBlock railBlock = (AbstractRailBlock)bs.func_177230_c();
        RailShape railShape = railBlock.getRailDirection(bs, (IBlockReader)this.world, pos, (AbstractMinecartEntity)this.minecartEntity);
        LOGGER.debug("minecartEntity railShape: " + railShape);
        this.isMinecartTurning = false;
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            if (railShape == RailShape.NORTH_WEST || railShape == RailShape.SOUTH_WEST) {
                this.lastTorchPos = null;
                dir = Direction.WEST;
                this.isMinecartTurning = true;
            }
            if (railShape == RailShape.NORTH_EAST || railShape == RailShape.SOUTH_EAST) {
                this.lastTorchPos = null;
                dir = Direction.EAST;
                this.isMinecartTurning = true;
            }
        } else if (dir == Direction.WEST || dir == Direction.EAST) {
            if (railShape == RailShape.NORTH_WEST || railShape == RailShape.NORTH_EAST) {
                this.lastTorchPos = null;
                dir = Direction.NORTH;
                this.isMinecartTurning = true;
            }
            if (railShape == RailShape.SOUTH_WEST || railShape == RailShape.SOUTH_EAST) {
                this.lastTorchPos = null;
                dir = Direction.SOUTH;
                this.isMinecartTurning = true;
            }
        }
        boolean isMinecartAscending = railShape == RailShape.ASCENDING_EAST && dir == Direction.EAST || railShape == RailShape.ASCENDING_WEST && dir == Direction.WEST || railShape == RailShape.ASCENDING_NORTH && dir == Direction.NORTH || railShape == RailShape.ASCENDING_SOUTH && dir == Direction.SOUTH;
        LOGGER.debug("minecartEntity isMinecartTurning: " + this.isMinecartTurning);
        LOGGER.debug("minecartEntity adjusted dir: " + dir);
        this.miningDir = dir;
        BlockPos resultPos = pos.func_177972_a(dir);
        if (isMinecartAscending) {
            return resultPos.func_177984_a();
        }
        return resultPos;
    }

    private boolean isRailTrack(BlockPos targetPos) {
        BlockState blockState = this.world.func_180495_p(targetPos);
        return blockState.func_235714_a_((ITag)BlockTags.field_203437_y);
    }

    private boolean isFrontHarvested(BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            if (!this.isBlockHarvested(pos)) {
                return false;
            }
            pos = pos.func_177984_a();
        }
        return true;
    }

    private MiningStatus checkFrontStatus(BlockPos frontPos, BlockPos minecartPos) {
        if (this.isStopSign(minecartPos) || this.isStopSign(frontPos)) {
            return MiningStatus.EmergencyStop;
        }
        BlockPos frontDown = frontPos.func_177977_b();
        BlockPos behindFrontDown = frontPos.func_177977_b().func_177972_a(this.miningDir);
        if (this.isAir(frontDown)) {
            return MiningStatus.HazardCliff;
        }
        if (this.isAir(behindFrontDown)) {
            return MiningStatus.HazardCliff;
        }
        MiningStatus miningStatus = this.checkStatusAt(frontDown);
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        miningStatus = this.checkStatusAt(behindFrontDown);
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        miningStatus = this.checkStatusAt(frontPos.func_177972_a(this.miningDir).func_177977_b());
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        miningStatus = this.checkStatusAt(frontPos.func_177981_b(3));
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        miningStatus = this.checkPosStackStatus(frontPos.func_177972_a(this.miningDir));
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        miningStatus = this.checkPosStackStatus(frontPos.func_177972_a(this.miningDir.func_176746_e()));
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        miningStatus = this.checkPosStackStatus(frontPos.func_177972_a(this.miningDir.func_176735_f()));
        if (miningStatus != MiningStatus.Mining) {
            return miningStatus;
        }
        if (this.isFrontHarvested(frontPos)) {
            return MiningStatus.Rolling;
        }
        return MiningStatus.Mining;
    }

    private MiningStatus checkPosStackStatus(BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            MiningStatus miningStatus = this.checkStatusAt(pos);
            if (miningStatus != MiningStatus.Mining) {
                return miningStatus;
            }
            pos = pos.func_177984_a();
        }
        return MiningStatus.Mining;
    }

    private boolean isBlockHarvested(BlockPos blockPos) {
        BlockState blockState = this.world.func_180495_p(blockPos);
        return blockState.func_196952_d((IBlockReader)this.world, blockPos).func_197766_b() || blockState.func_235714_a_((ITag)BlockTags.field_203437_y);
    }

    private boolean isStopSign(BlockPos blockPos) {
        for (int i = 0; i < 3; ++i) {
            BlockState blockState = this.world.func_180495_p(blockPos);
            if (blockState.func_235714_a_((ITag)BlockTags.field_219753_V) || blockState.func_235714_a_((ITag)BlockTags.field_219752_U) || blockState.func_235714_a_((ITag)BlockTags.field_219751_T)) {
                return true;
            }
            blockPos = blockPos.func_177984_a();
        }
        return false;
    }

    private boolean isAir(BlockPos pos) {
        return this.world.func_180495_p(pos).func_196958_f();
    }

    private MiningStatus checkStatusAt(BlockPos pos) {
        FluidState fLuidState = this.world.func_180495_p(pos).func_204520_s();
        if (!fLuidState.func_206888_e()) {
            if (fLuidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                return MiningStatus.HazardLava;
            }
            if (fLuidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
                return MiningStatus.HazardWater;
            }
            return MiningStatus.HazardUnknownFluid;
        }
        return MiningStatus.Mining;
    }

    private void beginMining(BlockPos blockPos) {
        this.miningStatus = MiningStatus.Mining;
        this.miningPos = blockPos;
        this.miningBlockTick = 0;
        if (this.miningPos != null) {
            this.world.func_175715_c(0, this.miningPos, -1);
        }
    }

    private void miningDone(BlockPos frontPos) {
        this.createRailAndTorch(frontPos);
        this.resetMining();
    }

    private void resetMining() {
        if (this.miningPos != null) {
            this.world.func_175715_c(0, this.miningPos, -1);
        }
        this.miningStatus = MiningStatus.Rolling;
        this.miningPos = null;
        this.miningBlockTick = 0;
        this.miningStackTick = 0;
    }

    private boolean tickBlockMining() {
        if (this.isBlockHarvested(this.miningPos)) {
            return true;
        }
        BlockState blockState = this.world.func_180495_p(this.miningPos);
        float blockHardness = blockState.func_185887_b((IBlockReader)this.world, this.miningPos);
        boolean mineAllowed = blockHardness >= 0.0f && blockHardness < 50.0f;
        boolean byHand = !blockState.func_235783_q_();
        boolean isPickAxe = pickaxeItem.func_150897_b(blockState);
        boolean isShovel = shovelItem.func_150897_b(blockState);
        float pickAxeSpeed = pickaxeItem.func_150893_a(new ItemStack((IItemProvider)pickaxeItem), blockState);
        float shovelSpeed = shovelItem.func_150893_a(new ItemStack((IItemProvider)shovelItem), blockState);
        LOGGER.debug("tickMining on " + blockState.func_177230_c().getRegistryName() + " at " + this.miningPos + ", mineAllowed: " + mineAllowed + ", byHand: " + byHand + ", pickaxe canHarvestBlock: " + isPickAxe + " ,pickaxe getDestroySpeed: " + pickAxeSpeed + " ,shovelItem canHarvestBlock: " + isShovel + " ,shovelItem getDestroySpeed: " + shovelSpeed + " ,BlockHardness: " + blockHardness);
        int miningTime = -1;
        if (mineAllowed && (byHand || isPickAxe || isShovel)) {
            float miningSpeed;
            ++this.miningBlockTick;
            LOGGER.debug("byHand:" + byHand + "isPickAxe:" + isPickAxe + ", isShovel:" + isShovel + ", miningBlockTick:" + this.miningBlockTick);
            if (isPickAxe) {
                this.world.func_184134_a(0.0, 0.0, 0.0, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                miningTime = 19;
                miningSpeed = pickAxeSpeed;
            } else {
                this.world.func_184134_a(0.0, 0.0, 0.0, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                miningTime = 8;
                miningSpeed = shovelSpeed;
            }
            float damage = miningSpeed / blockHardness / 30.0f;
            if (damage > 1.0f) {
                damage = 1.0f;
            }
            float ticks = (float)Math.ceil(1.0f / damage);
            float seconds = ticks / 20.0f;
            LOGGER.debug("Mining time in ticks:" + ticks + ", sec:" + seconds);
            int progress = (int)((float)this.miningBlockTick / (float)miningTime * 10.0f);
            if (progress != this.previousProgress && progress % 5 == 0) {
                this.world.func_175715_c(0, this.miningPos, progress);
                this.previousProgress = progress;
            }
            if (this.miningBlockTick > miningTime) {
                this.world.func_175655_b(this.miningPos, true);
                return true;
            }
            return false;
        }
        this.miningStatus = MiningStatus.EmergencyStop;
        return false;
    }

    private void createRailAndTorch(BlockPos frontPos) {
        boolean railCreated = this.createRail(frontPos.func_177967_a(Direction.UP, 0));
        if (railCreated) {
            this.createTorch(frontPos.func_177967_a(Direction.UP, 2));
        }
    }

    private boolean createRail(BlockPos blockPos) {
        if (this.isRailTrack(blockPos) || this.isRailTrack(blockPos.func_177967_a(Direction.DOWN, 1))) {
            return false;
        }
        if (this.railTypeItem != null && this.minecartEntity.reduceInventoryItem((Item)this.railTypeItem)) {
            this.world.func_175656_a(blockPos, this.railTypeItem.func_179223_d().func_176223_P().rotate((IWorld)this.world, blockPos, this.getRailRotation()));
            return true;
        }
        return false;
    }

    private Rotation getRailRotation() {
        return Rotation.NONE;
    }

    private void createTorch(BlockPos blockPos) {
        Object torchBlock;
        if (this.lastTorchPos != null && this.lastTorchPos.func_218137_a((IPosition)new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), 6.0)) {
            return;
        }
        if (this.miningDir == null) {
            return;
        }
        if (this.torchTypeItem == null) {
            return;
        }
        if (this.torchTypeItem == Items.field_221657_bQ) {
            torchBlock = Blocks.field_196591_bQ;
        } else if (this.torchTypeItem == Items.field_221764_cr) {
            torchBlock = Blocks.field_196677_cy;
            blockPos = blockPos.func_177977_b();
        } else {
            torchBlock = this.torchTypeItem == Items.field_234737_dp_ ? Blocks.field_235340_cR_ : null;
        }
        BlockState targetBlockState = this.world.func_180495_p(blockPos);
        if (targetBlockState.func_203425_a(Blocks.field_196591_bQ) || targetBlockState.func_203425_a(Blocks.field_150429_aA) || targetBlockState.func_203425_a(Blocks.field_235339_cQ_)) {
            this.lastTorchPos = blockPos;
            return;
        }
        if (torchBlock != null) {
            Direction torchDir = null;
            if (!this.isAir(blockPos.func_177967_a(this.miningDir.func_176746_e(), 1))) {
                torchDir = this.miningDir.func_176735_f();
            } else if (!this.isAir(blockPos.func_177967_a(this.miningDir.func_176735_f(), 1))) {
                torchDir = this.miningDir.func_176746_e();
            }
            if (torchDir != null && this.minecartEntity.reduceInventoryItem((Item)this.torchTypeItem)) {
                this.world.func_175656_a(blockPos, (BlockState)torchBlock.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)torchDir));
                this.lastTorchPos = blockPos;
            }
        }
    }

    public static enum MiningStatus {
        Rolling(0),
        Mining(1),
        HazardCliff(2),
        HazardLava(3),
        HazardWater(4),
        HazardUnknownFluid(5),
        DepletedConsumable(6),
        EmergencyStop(7);

        public final int Value;

        private MiningStatus(int value) {
            this.Value = value;
        }

        public static MiningStatus Find(int value) {
            switch (value) {
                case 1: {
                    return Mining;
                }
                case 2: {
                    return HazardCliff;
                }
                case 3: {
                    return HazardLava;
                }
                case 4: {
                    return HazardWater;
                }
                case 5: {
                    return HazardUnknownFluid;
                }
                case 6: {
                    return DepletedConsumable;
                }
                case 7: {
                    return EmergencyStop;
                }
            }
            return Rolling;
        }
    }
}

