/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.block.UtilityBlock;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class GlowBlock
extends UtilityBlock {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);
    public static final int UPDATE_TICKS = 6;

    public GlowBlock(Material m, float defaultLight) {
        super(BlockBehaviour.Properties.m_60939_((Material)m).m_60977_().m_60953_(state -> (Integer)state.m_61143_((Property)LIGHT_LEVEL)), 6);
        int light = (int)(defaultLight * 15.0f);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(light)));
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        boolean hasLightGolem;
        AABB toCheck = new AABB(pos).m_82400_(0.5);
        List list = worldIn.m_45976_(GolemBase.class, toCheck);
        boolean bl = hasLightGolem = !list.isEmpty() && GlowBlock.hasLightGolem(list);
        if (hasLightGolem) {
            worldIn.m_186460_(pos, state.m_60734_(), this.tickRate);
        } else {
            this.remove((Level)worldIn, state, pos, 3);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT_LEVEL});
    }

    public static boolean hasLightGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.isProvidingLight()) continue;
            return true;
        }
        return false;
    }
}

