/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public final class GolemHeadBlock
extends HorizontalDirectionalBlock {
    public GolemHeadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        GolemHeadBlock.trySpawnGolem((Entity)placer, worldIn, pos);
    }

    public static boolean trySpawnGolem(@Nullable Entity placer, Level world, BlockPos headPos) {
        if (world.m_5776_()) {
            return false;
        }
        BlockState stateBelow1 = world.m_8055_(headPos.m_6625_(1));
        BlockState stateBelow2 = world.m_8055_(headPos.m_6625_(2));
        BlockState stateArmNorth = world.m_8055_(headPos.m_6625_(1).m_142390_(1));
        BlockState stateArmSouth = world.m_8055_(headPos.m_6625_(1).m_142383_(1));
        BlockState stateArmEast = world.m_8055_(headPos.m_6625_(1).m_142385_(1));
        BlockState stateArmWest = world.m_8055_(headPos.m_6625_(1).m_142386_(1));
        Block blockBelow1 = stateBelow1.m_60734_();
        Block blockBelow2 = stateBelow2.m_60734_();
        Block blockArmNorth = stateArmNorth.m_60734_();
        Block blockArmSouth = stateArmSouth.m_60734_();
        Block blockArmEast = stateArmEast.m_60734_();
        Block blockArmWest = stateArmWest.m_60734_();
        double spawnX = (double)headPos.m_123341_() + 0.5;
        double spawnY = (double)headPos.m_123342_() - 1.95;
        double spawnZ = (double)headPos.m_123343_() + 0.5;
        if (GolemHeadBlock.doBlocksMatch(Blocks.f_50127_, blockBelow1, blockBelow2)) {
            GolemHeadBlock.removeGolemBody(world, headPos);
            SnowGolem entitysnowman = (SnowGolem)EntityType.f_20528_.m_20615_(world);
            ExtraGolems.LOGGER.debug("[Extra Golems]: Building regular boring Snow Golem");
            entitysnowman.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.m_7967_((Entity)entitysnowman);
            return true;
        }
        boolean isIron = GolemHeadBlock.doBlocksMatch(Blocks.f_50075_, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        boolean flagX = false;
        if (!isIron) {
            isIron = GolemHeadBlock.doBlocksMatch(Blocks.f_50075_, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            flagX = true;
        }
        if (isIron) {
            GolemHeadBlock.removeAllGolemBlocks(world, headPos, flagX);
            IronGolem ironGolem = (IronGolem)EntityType.f_20460_.m_20615_(world);
            ExtraGolems.LOGGER.debug("[Extra Golems]: Building regular boring Iron Golem");
            ironGolem.m_28887_(true);
            ironGolem.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.m_7967_((Entity)ironGolem);
            return true;
        }
        if (GolemHeadBlock.isInvalidBlock(blockBelow1) || GolemHeadBlock.isInvalidBlock(blockBelow2)) {
            return false;
        }
        GolemBase golem = ExtraGolems.getGolem(world, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        flagX = false;
        if (golem == null) {
            golem = ExtraGolems.getGolem(world, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            flagX = true;
        }
        if (golem != null) {
            GolemHeadBlock.removeAllGolemBlocks(world, headPos, flagX);
            golem.m_28887_(true);
            golem.m_7678_(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            ExtraGolems.LOGGER.debug("[Extra Golems]: Building golem " + golem);
            world.m_7967_((Entity)golem);
            if (placer != null && placer.m_20193_() instanceof ServerLevel) {
                golem.m_6518_((ServerLevelAccessor)((ServerLevel)placer.m_20193_()), world.m_6436_(headPos), MobSpawnType.MOB_SUMMONED, null, null);
            }
            golem.onBuilt(stateBelow1, stateBelow2, flagX ? stateArmEast : stateArmWest, flagX ? stateArmNorth : stateArmSouth);
            return true;
        }
        return false;
    }

    public static boolean doBlocksMatch(Block master, Block ... toCheck) {
        boolean success = toCheck != null && toCheck.length > 0;
        for (Block b : toCheck) {
            success &= b == master;
        }
        return success;
    }

    public static void removeAllGolemBlocks(Level world, BlockPos pos, boolean isXAligned) {
        GolemHeadBlock.removeGolemBody(world, pos);
        GolemHeadBlock.removeGolemArms(world, pos, isXAligned);
    }

    public static void removeGolemBody(Level world, BlockPos head) {
        world.m_46961_(head, false);
        world.m_46961_(head.m_6625_(1), false);
        world.m_46961_(head.m_6625_(2), false);
    }

    public static void removeGolemArms(Level world, BlockPos pos, boolean isXAligned) {
        if (isXAligned) {
            world.m_46961_(pos.m_6625_(1).m_142386_(1), false);
            world.m_46961_(pos.m_6625_(1).m_142385_(1), false);
        } else {
            world.m_46961_(pos.m_6625_(1).m_142390_(1), false);
            world.m_46961_(pos.m_6625_(1).m_142383_(1), false);
        }
    }

    private static boolean isInvalidBlock(Block b) {
        return b == null || b == Blocks.f_50016_ || b == Blocks.f_49990_;
    }
}

