/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.parameter.ChangeTexturesBehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.ChangeTextureGoal;
import com.mcmoddev.golems.util.ResourcePair;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

@Immutable
public class ChangeTextureBehavior
extends GolemBehavior {
    private final ChangeTexturesBehaviorParameter tickTextures;
    private final ChangeTexturesBehaviorParameter wetTextures;
    private final ChangeTexturesBehaviorParameter dryTextures;
    private final ChangeTexturesBehaviorParameter fueledTextures;
    private final ChangeTexturesBehaviorParameter emptyTextures;
    private final Map<ResourcePair, ChangeTexturesBehaviorParameter> itemParameters;

    public ChangeTextureBehavior(CompoundTag tag) {
        super(tag);
        this.tickTextures = tag.m_128441_("tick") ? new ChangeTexturesBehaviorParameter(tag.m_128469_("tick")) : null;
        this.wetTextures = tag.m_128441_("wet") ? new ChangeTexturesBehaviorParameter(tag.m_128469_("wet")) : null;
        this.dryTextures = tag.m_128441_("dry") ? new ChangeTexturesBehaviorParameter(tag.m_128469_("dry")) : null;
        this.fueledTextures = tag.m_128441_("fuel") ? new ChangeTexturesBehaviorParameter(tag.m_128469_("fuel")) : null;
        this.emptyTextures = tag.m_128441_("fuel_empty") ? new ChangeTexturesBehaviorParameter(tag.m_128469_("fuel_empty")) : null;
        this.itemParameters = ImmutableMap.copyOf(ChangeTextureBehavior.readParameters(tag.m_128469_("items"), ChangeTexturesBehaviorParameter::new));
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        if (entity.getContainer().getMultitexture().isPresent()) {
            entity.f_21345_.m_25352_(1, new ChangeTextureGoal<GolemBase>(entity, this.tickTextures, this.wetTextures, this.dryTextures, this.fueledTextures, this.emptyTextures));
        }
    }

    @Override
    public void onMobInteract(GolemBase entity, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        int textureId = entity.getTextureId();
        ResourcePair itemId = new ResourcePair(item.m_41720_().getRegistryName(), false);
        if (this.itemParameters.containsKey(itemId) && this.apply(entity, player, hand, this.itemParameters.get(itemId), textureId)) {
            return;
        }
        for (Map.Entry<ResourcePair, ChangeTexturesBehaviorParameter> entry : this.itemParameters.entrySet()) {
            TagKey tagKey;
            if (!entry.getKey().flag() || !item.m_204117_(tagKey = ForgeRegistries.ITEMS.tags().createTagKey(entry.getKey().resource())) || !this.apply(entity, player, hand, entry.getValue(), textureId)) continue;
            return;
        }
    }

    private boolean apply(GolemBase entity, Player player, InteractionHand hand, ChangeTexturesBehaviorParameter param, int textureId) {
        int updateTextureId;
        if ((double)entity.m_21187_().nextFloat() < param.getChance() && (updateTextureId = param.getTextureId(String.valueOf(textureId), textureId)) != textureId) {
            entity.setTextureId((byte)updateTextureId);
            ChangeTextureBehavior.sendParticles((Entity)entity, (ParticleOptions)ParticleTypes.f_123751_, 12);
            player.m_6674_(hand);
            return true;
        }
        return false;
    }
}

