/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.FireBehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.MobEffectBehaviorParameter;
import com.mcmoddev.golems.container.behavior.parameter.SummonEntityBehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

@Immutable
public class OnActuallyHurtBehavior
extends GolemBehavior {
    protected final FireBehaviorParameter fire;
    protected final MobEffectBehaviorParameter effect;
    protected final SummonEntityBehaviorParameter summon;

    public OnActuallyHurtBehavior(CompoundTag tag) {
        super(tag);
        this.fire = tag.m_128441_("fire") ? new FireBehaviorParameter(tag.m_128469_("fire")) : null;
        this.effect = tag.m_128441_("effect") ? new MobEffectBehaviorParameter(tag.m_128469_("effect")) : null;
        this.summon = tag.m_128441_("summon") ? new SummonEntityBehaviorParameter(tag.m_128469_("summon")) : null;
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        if (!entity.m_6162_()) {
            if (this.fire != null) {
                this.fire.apply(entity, source.m_7639_());
            }
            if (this.effect != null && source.m_7639_() instanceof LivingEntity) {
                this.effect.apply(entity, (LivingEntity)source.m_7639_());
            }
            if (this.summon != null) {
                this.summon.apply(entity, source.m_7639_());
            }
        }
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        Component desc;
        if (this.fire != null && this.fire.getTarget() != BehaviorParameter.Target.SELF && !list.contains(FIRE_DESC)) {
            list.add((Component)FIRE_DESC);
        }
        if (this.effect != null) {
            if (this.effect.getTarget() == BehaviorParameter.Target.SELF && !list.contains(EFFECTS_SELF_DESC)) {
                list.add((Component)EFFECTS_SELF_DESC);
            } else if (this.effect.getTarget() != BehaviorParameter.Target.SELF && !list.contains(EFFECTS_ENEMY_DESC)) {
                list.add((Component)EFFECTS_ENEMY_DESC);
            }
        }
        if (this.summon != null && !list.contains(desc = this.summon.getDescription())) {
            list.add(desc);
        }
    }
}

