/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.PlaceBlocksGoal;
import com.mcmoddev.golems.util.ResourcePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;

@Immutable
public class PlaceBlocksBehavior
extends GolemBehavior {
    private final int interval;
    private final List<ResourceLocation> blocks = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> blockTags = new ArrayList<ResourceLocation>();
    private final Component component;

    public PlaceBlocksBehavior(CompoundTag tag) {
        super(tag);
        this.interval = tag.m_128451_("interval");
        ListTag blocksTag = (ListTag)tag.m_128423_("blocks");
        int l = blocksTag.size();
        for (int i = 0; i < l; ++i) {
            Optional result = ResourcePair.read(blocksTag.m_128778_(i)).resultOrPartial(s -> ExtraGolems.LOGGER.error("Error reading 'blocks' from NBT\n" + s));
            result.ifPresent(p -> {
                if (p.flag()) {
                    this.blockTags.add(p.resource());
                } else {
                    this.blocks.add(p.resource());
                }
            });
        }
        this.component = tag.m_128441_("translation_key") ? new TranslatableComponent(tag.m_128461_("translation_key")) : new TranslatableComponent("entitytip.places_blocks");
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        ArrayList<Block> blockList = new ArrayList<Block>(GolemContainer.getAllBlocks(this.blocks, this.blockTags));
        entity.f_21345_.m_25352_(2, (Goal)new PlaceBlocksGoal(entity, this.interval, blockList.toArray(new Block[0])));
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        if (!list.contains(this.component)) {
            list.add(this.component);
        }
    }
}

