/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;

@Immutable
public class SplitBehavior
extends GolemBehavior {
    protected final int children;

    public SplitBehavior(CompoundTag tag) {
        super(tag);
        this.children = tag.m_128451_("children");
    }

    public int getChildren() {
        return this.children;
    }

    @Override
    public void onDie(GolemBase entity, DamageSource source) {
        this.attemptAddChildren(entity, this.children);
    }

    protected Collection<GolemBase> attemptAddChildren(GolemBase entity, int count) {
        ArrayList<GolemBase> children = new ArrayList<GolemBase>();
        if (entity.f_19853_ instanceof ServerLevelAccessor && !entity.m_6162_() && count > 0) {
            DifficultyInstance diff = entity.f_19853_.m_6436_(entity.m_142538_());
            for (int i = 0; i < count; ++i) {
                GolemBase child = GolemBase.create(entity.f_19853_, entity.getMaterial());
                child.m_6863_(true);
                if (entity.m_5448_() != null) {
                    child.m_6710_(entity.m_5448_());
                }
                child.m_20359_((Entity)entity);
                entity.f_19853_.m_7967_((Entity)child);
                child.m_6518_((ServerLevelAccessor)entity.f_19853_, diff, MobSpawnType.MOB_SUMMONED, null, null);
                children.add(child);
            }
        }
        return children;
    }

    @Override
    public void onAddDescriptions(List<Component> list) {
        list.add((Component)new TranslatableComponent("entitytip.split_on_death").m_130940_(ChatFormatting.GREEN));
    }
}

