/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior.parameter;

import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

@Immutable
public class MobEffectBehaviorParameter
extends BehaviorParameter {
    private final BehaviorParameter.Target target;
    private final double chance;
    private final double range;
    private final ListTag effectList;

    public MobEffectBehaviorParameter(CompoundTag tag) {
        this.target = BehaviorParameter.Target.getByName(tag.m_128461_("target"));
        this.chance = tag.m_128459_("chance");
        this.range = tag.m_128459_("range");
        this.effectList = tag.m_128437_("effects", 10);
    }

    public BehaviorParameter.Target getTarget() {
        return this.target;
    }

    public double getChance() {
        return this.chance;
    }

    public double getRange() {
        return this.range;
    }

    public MobEffectInstance[] getEffects() {
        return MobEffectBehaviorParameter.readEffectArray(this.getEffectTag());
    }

    public ListTag getEffectTag() {
        return this.effectList.m_6426_();
    }

    public void apply(GolemBase self, LivingEntity other) {
        if (this.effectList.size() > 0 && (double)self.m_21187_().nextFloat() < this.chance) {
            CompoundTag effectTag = this.effectList.m_128728_(self.m_21187_().nextInt(this.effectList.size())).m_6426_();
            MobEffectInstance effect = MobEffectBehaviorParameter.readEffect(effectTag);
            switch (this.target) {
                case AREA: {
                    double inflate = this.range > 0.0 ? this.range : 2.0;
                    TargetingConditions condition = TargetingConditions.m_148353_().m_148355_().m_26893_();
                    List targets = self.f_19853_.m_45971_(LivingEntity.class, condition, (LivingEntity)self, self.m_142469_().m_82400_(inflate));
                    for (LivingEntity target : targets) {
                        this.applyEffect(target, effect);
                    }
                    break;
                }
                case SELF: {
                    this.applyEffect((LivingEntity)self, effect);
                    break;
                }
                case ENEMY: {
                    this.applyEffect(other, effect);
                }
            }
        }
    }

    private void applyEffect(LivingEntity target, MobEffectInstance effect) {
        if (effect != null && target != null) {
            target.m_7292_(effect);
        }
    }
}

