/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior.parameter;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

@Immutable
public class SummonEntityBehaviorParameter
extends BehaviorParameter {
    private final BehaviorParameter.Target target;
    private final BehaviorParameter.Target targetPos;
    private final ResourceLocation entityId;
    private final CompoundTag compoundTag;
    private final double chance;
    private final double bonusChanceInRain;
    private final Component component;

    public SummonEntityBehaviorParameter(CompoundTag tag) {
        this.target = BehaviorParameter.Target.getByName(tag.m_128461_("target"));
        this.targetPos = tag.m_128441_("summon_pos") ? BehaviorParameter.Target.getByName(tag.m_128461_("summon_pos")) : this.target;
        this.compoundTag = tag.m_128469_("entity");
        this.entityId = new ResourceLocation(this.compoundTag.m_128461_("id"));
        this.chance = tag.m_128459_("chance");
        this.bonusChanceInRain = tag.m_128459_("bonus_chance_in_rain");
        this.component = tag.m_128441_("translation_key") ? new TranslatableComponent(tag.m_128461_("translation_key")) : new TranslatableComponent("entitytip.summon_x", new Object[]{new TranslatableComponent("entity." + this.entityId.m_135827_() + "." + this.entityId.m_135815_())});
    }

    public BehaviorParameter.Target getTarget() {
        return this.target;
    }

    public BehaviorParameter.Target getSummonPos() {
        return this.targetPos;
    }

    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    public double getChance() {
        return this.chance;
    }

    public double getBonusChanceInRain() {
        return this.bonusChanceInRain;
    }

    public CompoundTag getCompoundTag() {
        return this.compoundTag;
    }

    public Component getDescription() {
        return this.component;
    }

    public void apply(GolemBase self, @Nullable Entity angerTarget) {
        double chanceApply = this.chance;
        if (self.f_19853_.m_46758_(self.m_142538_())) {
            chanceApply += this.bonusChanceInRain;
        }
        if (!self.f_19853_.m_5776_() && (double)self.m_21187_().nextFloat() < chanceApply) {
            Optional entity = EntityType.m_20642_((CompoundTag)this.compoundTag, (Level)self.f_19853_);
            if (entity.isPresent() && self.f_19853_ instanceof ServerLevel) {
                ((Entity)entity.get()).m_20258_(this.compoundTag);
                Vec3 pos = this.targetPos == BehaviorParameter.Target.SELF || angerTarget == null ? self.m_20182_() : angerTarget.m_20182_();
                ((Entity)entity.get()).m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                self.f_19853_.m_7967_((Entity)entity.get());
                if (entity.get() instanceof Mob) {
                    ((Mob)entity.get()).m_6518_((ServerLevelAccessor)((ServerLevel)self.f_19853_), self.f_19853_.m_6436_(new BlockPos(pos)), MobSpawnType.MOB_SUMMONED, null, null);
                    if (this.target == BehaviorParameter.Target.ENEMY && angerTarget != null) {
                        ((Mob)entity.get()).m_6710_(self.m_5448_());
                    }
                }
                if (entity.get() instanceof NeutralMob && this.target == BehaviorParameter.Target.ENEMY && angerTarget != null) {
                    ((NeutralMob)entity.get()).m_6925_(angerTarget.m_142081_());
                    ((NeutralMob)entity.get()).m_6825_();
                }
            } else {
                ExtraGolems.LOGGER.warn("Failed to create entity of type " + this.entityId);
            }
        }
    }
}

