/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GlowBlock;
import com.mcmoddev.golems.block.PowerBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.behavior.ExplodeBehavior;
import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.container.behavior.ShootArrowsBehavior;
import com.mcmoddev.golems.container.behavior.UseFuelBehavior;
import com.mcmoddev.golems.entity.IArrowShooter;
import com.mcmoddev.golems.entity.IFuelConsumer;
import com.mcmoddev.golems.entity.IMultitextured;
import com.mcmoddev.golems.entity.IRandomExploder;
import com.mcmoddev.golems.entity.IRandomTeleporter;
import com.mcmoddev.golems.entity.goal.GoToWaterGoal;
import com.mcmoddev.golems.entity.goal.PlaceUtilityBlocksGoal;
import com.mcmoddev.golems.entity.goal.SwimUpGoal;
import com.mcmoddev.golems.item.SpawnGolemItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class GolemBase
extends IronGolem
implements IMultitextured,
IFuelConsumer,
IRandomTeleporter,
IRandomExploder,
IArrowShooter,
IEntityAdditionalSpawnData {
    protected static final EntityDataAccessor<String> MATERIAL = SynchedEntityData.m_135353_(GolemBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Boolean> CHILD = SynchedEntityData.m_135353_(GolemBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> TEXTURE = SynchedEntityData.m_135353_(GolemBase.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(GolemBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> FUSE_LIT = SynchedEntityData.m_135353_(GolemBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ARROWS = SynchedEntityData.m_135353_(GolemBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String KEY_MATERIAL = "Material";
    public static final String KEY_CHILD = "IsChild";
    private static final double MAX_ARMOR = ((RangedAttribute)Attributes.f_22284_).m_147362_();
    private ResourceLocation material = new ResourceLocation("golems", "empty");
    private GolemContainer container = GolemContainer.EMPTY;
    protected Component description;
    protected final WaterBoundPathNavigation waterNavigator;
    protected final GroundPathNavigation groundNavigator;
    protected boolean swimmingUp;
    protected int fuse;
    protected final RangedAttackGoal aiArrowAttack;
    protected final MeleeAttackGoal aiMeleeAttack;
    private SimpleContainer inventory;
    protected int biomeColor = 8626266;

    public GolemBase(EntityType<? extends GolemBase> type, Level world) {
        super(type, world);
        this.waterNavigator = new WaterBoundPathNavigation((Mob)this, world);
        this.groundNavigator = new GroundPathNavigation((Mob)this, world);
        this.aiArrowAttack = new RangedAttackGoal((RangedAttackMob)this, 1.0, 28, 32.0f);
        this.aiMeleeAttack = new MeleeAttackGoal((PathfinderMob)this, 1.0, true);
        this.initArrowInventory();
    }

    public static GolemBase create(Level world, ResourceLocation material) {
        GolemBase golem = new GolemBase((EntityType<? extends GolemBase>)((EntityType)EGRegistry.GOLEM.get()), world);
        golem.setMaterial(material);
        return golem;
    }

    public void setMaterial(ResourceLocation materialIn) {
        if (materialIn.equals((Object)this.material)) {
            return;
        }
        this.m_20088_().m_135381_(MATERIAL, (Object)materialIn.toString());
        this.material = materialIn;
        this.container = ExtraGolems.GOLEM_CONTAINERS.get(materialIn).orElse(GolemContainer.EMPTY);
        this.f_20943_ = new AttributeMap(this.container.getAttributeSupplier().get().m_22265_());
        this.m_20331_(this.container.getAttributes().getArmor() > MAX_ARMOR);
        this.description = null;
        if (!this.f_19853_.m_5776_()) {
            this.f_21345_.m_148096_();
            this.m_8099_();
            switch (this.container.getSwimAbility()) {
                case FLOAT: {
                    this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
                    break;
                }
                case SWIM: {
                    this.f_19793_ = 1.0f;
                    this.f_21342_ = new SwimmingMovementController(this);
                    this.m_21441_(BlockPathTypes.WATER, 0.0f);
                    this.f_21345_.m_25352_(1, (Goal)new GoToWaterGoal(this, 14, 1.0));
                    this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, (double)0.8f, 200));
                    this.f_21345_.m_25352_(5, (Goal)new SwimUpGoal(this, 1.0, this.f_19853_.m_5736_() + 1));
                    break;
                }
            }
            if (this.container.getAttributes().isHurtByWater()) {
                this.m_21441_(BlockPathTypes.WATER, -1.0f);
            }
            this.registerGlowGoal();
            this.registerPowerGoal();
            this.container.getBehaviors().values().forEach(list -> list.forEach(b -> b.onRegisterGoals(this)));
        }
    }

    public ResourceLocation getMaterial() {
        return this.material;
    }

    public GolemContainer getContainer() {
        return this.container;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(MATERIAL, (Object)new ResourceLocation("golems", "empty").toString());
        this.m_20088_().m_135372_(CHILD, (Object)false);
        this.m_20088_().m_135372_(TEXTURE, (Object)0);
        this.m_20088_().m_135372_(FUEL, (Object)0);
        this.m_20088_().m_135372_(FUSE_LIT, (Object)false);
        this.m_20088_().m_135372_(ARROWS, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (MATERIAL.equals(key)) {
            this.setMaterial(new ResourceLocation((String)this.m_20088_().m_135370_(MATERIAL)));
        }
        if (CHILD.equals(key)) {
            if (this.m_6162_()) {
                double childHealth = Math.floor(this.getContainer().getAttributes().getHealth() * 0.3 * 10.0) / 10.0;
                double childAttack = Math.floor(this.getContainer().getAttributes().getAttack() * 0.6 * 10.0) / 10.0;
                this.m_21051_(Attributes.f_22276_).m_22100_(childHealth);
                this.m_21051_(Attributes.f_22281_).m_22100_(childAttack);
                this.m_21051_(Attributes.f_22278_).m_22100_(0.0);
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(this.getContainer().getAttributes().getHealth());
                this.m_21051_(Attributes.f_22281_).m_22100_(this.getContainer().getAttributes().getAttack());
                this.m_21051_(Attributes.f_22278_).m_22100_(this.getContainer().getAttributes().getKnockbackResist());
            }
            this.m_6210_();
        } else if (TEXTURE.equals(key)) {
            this.setTextureId((byte)this.getTextureId());
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevel, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        this.m_21153_(this.m_21233_());
        return super.m_6518_(serverLevel, difficulty, mobSpawnType, spawnGroupData, tag);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    protected void registerGlowGoal() {
        int lightInt = this.container.getMaxLightLevel();
        if (lightInt > 0) {
            BlockState state = (BlockState)((GlowBlock)((Object)EGRegistry.UTILITY_LIGHT.get())).m_49966_().m_61124_((Property)GlowBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightInt));
            this.f_21345_.m_25352_(9, (Goal)new PlaceUtilityBlocksGoal(this, state, 6, true, (golem, pos) -> golem.isProvidingLight()));
        }
    }

    protected void registerPowerGoal() {
        int powerInt = this.getContainer().getMaxPowerLevel();
        if (powerInt > 0) {
            BlockState state = (BlockState)((PowerBlock)((Object)EGRegistry.UTILITY_POWER.get())).m_49966_().m_61124_((Property)PowerBlock.POWER_LEVEL, (Comparable)Integer.valueOf(powerInt));
            int freq = 4;
            this.f_21345_.m_25352_(9, (Goal)new PlaceUtilityBlocksGoal(this, state, 4, false, (golem, pos) -> golem.isProvidingPower()));
        }
    }

    public boolean canInteractChangeTexture() {
        return this.getContainer().getMultitexture().isPresent() && this.getContainer().getMultitexture().get().canCycle();
    }

    public boolean isProvidingLight() {
        if (this.getContainer().getMultitexture().isPresent()) {
            return this.getContainer().getMultitexture().get().getLight(this) > 0;
        }
        return this.getContainer().getMaxLightLevel() > 0;
    }

    public boolean isProvidingPower() {
        return this.getContainer().getMaxPowerLevel() > 0;
    }

    public float getHealAmount(ItemStack i) {
        float amount = (float)((double)this.m_21233_() * this.getContainer().getHealAmount(i.m_41720_()));
        if (this.m_6162_()) {
            amount *= 1.75f;
        }
        return Math.min(amount, 64.0f);
    }

    public BlockPos getBlockBelow() {
        return this.m_20099_();
    }

    public ItemStack getBanner() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setBanner(ItemStack bannerItem) {
        this.m_8061_(EquipmentSlot.CHEST, bannerItem);
        if (bannerItem.m_41720_() instanceof BannerItem) {
            this.m_21409_(EquipmentSlot.CHEST, 1.0f);
        }
    }

    public void m_8024_() {
        BlockPos pos;
        super.m_8024_();
        if (this.getContainer().getAttributes().isHurtByWater() && this.m_20071_()) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
        }
        if (this.getContainer().getAttributes().isHurtByHeat() && ((Biome)this.f_19853_.m_204166_(pos = this.m_20099_().m_6630_(2)).m_203334_()).m_198910_(pos)) {
            this.m_6469_(DamageSource.f_19307_, 1.0f);
        }
        if (this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS) && this.f_19797_ % 35 == 1) {
            boolean forceMelee = this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 8.0;
            this.updateCombatTask(forceMelee);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_5776_()) {
            if (this.f_19797_ % 15 == 1) {
                this.biomeColor = ((Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_()).m_47542_();
            }
            if (this.isFuseLit()) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + this.m_21187_().nextDouble() - 0.5, this.m_20186_() + this.m_21187_().nextDouble() * (double)this.m_20206_(), this.m_20189_() + this.m_21187_().nextDouble() - 0.5, 0.0, 0.0, 0.0);
            }
            this.getContainer().getParticle().ifPresent(particle -> this.f_19853_.m_7106_(particle, this.m_20185_() + this.m_21187_().nextDouble() - 0.5, this.m_20186_() + this.m_21187_().nextDouble() * (double)this.m_20192_(), this.m_20189_() + this.m_21187_().nextDouble() - 0.5, 0.1 * (this.m_21187_().nextDouble() - 0.5), 0.1 * (this.m_21187_().nextDouble() - 0.5), 0.1 * (this.m_21187_().nextDouble() - 0.5)));
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (!this.getContainer().getAttributes().isHurtByFall()) {
            return false;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        boolean flag = super.m_142535_(distance, damageMultiplier, source);
        int i = this.m_5639_(distance, damageMultiplier);
        if (i > 0) {
            SoundEvent sound = i > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_();
            this.m_5496_(sound, 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(DamageSource.f_19315_, i);
            return true;
        }
        return flag;
    }

    public boolean m_5825_() {
        return this.getContainer().getAttributes().hasFireImmunity();
    }

    public boolean m_6128_() {
        return this.getContainer().getAttributes().hasExplosionImmunity();
    }

    public boolean m_6549_(EntityType<?> type) {
        if (type == EntityType.f_20532_ && this.m_28876_()) {
            return EGConfig.enableFriendlyFire();
        }
        if (type == EntityType.f_20492_ || type == EGRegistry.GOLEM.get() || type == EntityType.f_20460_ || type == EntityType.f_20528_) {
            return false;
        }
        return super.m_6549_(type);
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            double knockback = this.getContainer().getAttributes().getAttackKnockback();
            if (knockback > 0.0 && !this.m_6162_()) {
                Vec3 myPos = this.m_20182_();
                Vec3 ePos = target.m_20182_();
                double dX = Math.signum(ePos.f_82479_ - myPos.f_82479_) * knockback;
                double dZ = Math.signum(ePos.f_82481_ - myPos.f_82481_) * knockback;
                target.m_20256_(target.m_20184_().m_82520_(dX, knockback / 2.0, dZ));
            }
            this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onHurtTarget(this, target)));
            return true;
        }
        return false;
    }

    protected void m_6475_(DamageSource source, float amount) {
        super.m_6475_(source, amount);
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onActuallyHurt(this, source, amount)));
    }

    public ItemStack getPickedResult(HitResult ray) {
        return this.container.hasBlocks() ? new ItemStack((ItemLike)this.container.getAllBlocks().toArray(new Block[0])[0]) : ItemStack.f_41583_;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getBanner().m_41619_() && stack.m_41720_() instanceof ShearsItem) {
            this.m_5552_(this.getBanner(), this.m_6162_() ? 0.9f : 1.4f);
            this.setBanner(ItemStack.f_41583_);
            return InteractionResult.CONSUME;
        }
        if (stack.m_41720_() instanceof BannerItem && this.processInteractBanner(player, hand, stack)) {
            return InteractionResult.CONSUME;
        }
        float healAmount = this.getHealAmount(stack);
        if (!stack.m_41619_() && healAmount > 0.0f && this.processInteractHeal(player, hand, stack, healAmount)) {
            return InteractionResult.CONSUME;
        }
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_() && !player.m_6047_() && this.canInteractChangeTexture() && this.cycleTexture()) {
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onMobInteract(this, player, hand)));
        return super.m_6071_(player, hand);
    }

    protected boolean processInteractBanner(Player player, InteractionHand hand, ItemStack stack) {
        if (!this.getBanner().m_41619_()) {
            this.m_5552_(this.getBanner(), this.m_6162_() ? 0.9f : 1.4f);
        }
        this.setBanner(stack.m_41620_(1));
        return true;
    }

    protected boolean processInteractHeal(Player player, InteractionHand hand, ItemStack stack, float healAmount) {
        if (EGConfig.enableHealGolems() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(healAmount);
            if (!player.m_7500_()) {
                if (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                } else {
                    player.m_21008_(hand, stack.getContainerItem());
                }
            }
            if (this.m_5448_() == player) {
                this.m_6703_(null);
                this.m_6710_(null);
            }
            Vec3 pos = this.m_20182_();
            SpawnGolemItem.spawnParticles(this.f_19853_, pos.f_82479_, pos.f_82480_ + (double)this.m_20206_() / 2.0, pos.f_82481_, 0.15, (ParticleOptions)ParticleTypes.f_123751_, 30);
            this.m_5496_(SoundEvents.f_12447_, 0.85f, 1.1f + this.f_19796_.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    public boolean m_6126_() {
        return this.getContainer().getAttributes().isHurtByWater();
    }

    public float m_6073_() {
        return this.isProvidingLight() || this.isProvidingPower() ? 1.0f : super.m_6073_();
    }

    protected Component m_5677_() {
        if (this.description == null) {
            this.description = new TranslatableComponent("entity." + this.material.m_135827_() + ".golem." + this.material.m_135815_());
        }
        return this.description;
    }

    protected ResourceLocation m_7582_() {
        return this.getContainer().getLootTable(this);
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(CHILD);
    }

    public void m_6863_(boolean isChild) {
        if ((Boolean)this.m_20088_().m_135370_(CHILD) != isChild) {
            this.m_20088_().m_135381_(CHILD, (Object)isChild);
            this.m_6210_();
        }
    }

    public void m_6667_(DamageSource source) {
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onDie(this, source)));
        super.m_6667_(source);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setMaterial(new ResourceLocation(tag.m_128461_(KEY_MATERIAL)));
        this.m_6863_(tag.m_128471_(KEY_CHILD));
        this.container.getMultitexture().ifPresent(m -> this.loadTextureId(tag));
        this.initArrowInventory();
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onReadData(this, tag)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_(KEY_MATERIAL, this.getMaterial().toString());
        tag.m_128379_(KEY_CHILD, this.m_6162_());
        this.container.getMultitexture().ifPresent(m -> this.saveTextureId(tag));
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onWriteData(this, tag)));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.material);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.setMaterial(buffer.m_130281_());
        this.m_21153_(this.m_21233_());
    }

    protected SoundEvent m_7515_() {
        return this.getGolemSound();
    }

    protected SoundEvent m_7975_(DamageSource ignored) {
        return this.getGolemSound() == SoundEvents.f_11987_ ? SoundEvents.f_11985_ : this.getGolemSound();
    }

    protected SoundEvent m_5592_() {
        return this.getGolemSound() == SoundEvents.f_11987_ ? SoundEvents.f_11983_ : this.getGolemSound();
    }

    public final SoundEvent getGolemSound() {
        return this.container.getSound();
    }

    @Override
    public int getTextureCount() {
        return this.container.getMultitexture().isPresent() ? this.container.getMultitexture().get().getTextureCount() : 0;
    }

    @Override
    public void setTextureId(byte toSet) {
        if (toSet >= 0) {
            this.m_20088_().m_135381_(TEXTURE, (Object)toSet);
        }
    }

    @Override
    public int getTextureId() {
        return ((Byte)this.m_20088_().m_135370_(TEXTURE)).byteValue();
    }

    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        this.container.getMultitexture().ifPresent(m -> this.setTextureId((byte)m.getTextureFromBlock(body.m_60734_())));
    }

    public int getBiomeColor() {
        return this.biomeColor;
    }

    @Override
    public void setFuel(int fuel) {
        this.m_20088_().m_135381_(FUEL, (Object)fuel);
    }

    @Override
    public int getFuel() {
        return (Integer)this.m_20088_().m_135370_(FUEL);
    }

    @Override
    public int getMaxFuel() {
        List b = this.container.getBehaviors(GolemBehaviors.USE_FUEL);
        return b.isEmpty() ? 0 : ((UseFuelBehavior)b.get(0)).getMaxFuel();
    }

    @Override
    public GolemBase getGolemEntity() {
        return this;
    }

    @Override
    public int getFuseLen() {
        List b = this.container.getBehaviors(GolemBehaviors.EXPLODE);
        return b.isEmpty() ? 0 : ((ExplodeBehavior)b.get(0)).getFuseLen();
    }

    @Override
    public int getFuse() {
        return this.fuse;
    }

    @Override
    public void setFuse(int fuseIn) {
        this.fuse = fuseIn;
    }

    @Override
    public void setFuseLit(boolean litIn) {
        this.m_20088_().m_135381_(FUSE_LIT, (Object)litIn);
    }

    @Override
    public boolean isFuseLit() {
        return (Boolean)this.m_20088_().m_135370_(FUSE_LIT);
    }

    @Override
    public void initArrowInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(9);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.m_5757_((Container)this.inventory);
    }

    @Override
    public double getArrowDamage() {
        if (this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
            double multiplier = this.m_6162_() ? 0.5 : 1.0;
            return multiplier * ((ShootArrowsBehavior)this.getContainer().getBehaviors(GolemBehaviors.SHOOT_ARROWS).get(0)).getDamage();
        }
        return 0.0;
    }

    public boolean m_7243_(ItemStack stack) {
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof ArrowItem && this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
            int l = this.getArrowInventory().m_6643_();
            for (int i = 0; i < l; ++i) {
                ItemStack invStack = this.getArrowInventory().m_8020_(i);
                if (!invStack.m_41619_() && (invStack.m_41720_() != stack.m_41720_() || !ItemStack.m_41658_((ItemStack)invStack, (ItemStack)stack) || invStack.m_41613_() + stack.m_41613_() > invStack.m_41741_())) continue;
                return true;
            }
            return false;
        }
        return this.m_7252_(stack);
    }

    public boolean m_21531_() {
        return this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS) || super.m_21531_();
    }

    @Override
    public SimpleContainer getArrowInventory() {
        return this.inventory;
    }

    @Override
    public RangedAttackGoal getRangedGoal() {
        return this.aiArrowAttack;
    }

    @Override
    public MeleeAttackGoal getMeleeGoal() {
        return this.aiMeleeAttack;
    }

    @Override
    public int getArrowsInInventory() {
        return (Integer)this.m_20088_().m_135370_(ARROWS);
    }

    @Override
    public void setArrowsInInventory(int count) {
        this.m_20088_().m_135381_(ARROWS, (Object)count);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
            this.dropArrowInventory();
        }
    }

    public boolean m_21540_(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ArrowItem && this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS) && this.getArrowInventory().m_19183_(stack)) {
            this.getArrowInventory().m_19173_(stack);
            return true;
        }
        return super.m_21540_(stack);
    }

    public void m_21053_(ItemEntity itemEntity) {
        super.m_21053_(itemEntity);
        this.m_5757_((Container)this.getArrowInventory());
    }

    public boolean m_7252_(ItemStack item) {
        return false;
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_6142_() && this.m_20069_() && this.isSwimmingUp()) {
            this.m_19920_(0.01f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(vec);
        }
    }

    public void m_5844_() {
        if (this.container.getSwimAbility() != GolemContainer.SwimMode.SWIM) {
            super.m_5844_();
            return;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_6142_() && this.m_20069_() && this.isSwimmingUp()) {
                this.f_21344_ = this.waterNavigator;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigator;
                this.m_20282_(false);
            }
        }
    }

    protected float m_6108_() {
        return this.container.getSwimAbility() == GolemContainer.SwimMode.SWIM ? 0.88f : super.m_6108_();
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public void setSwimmingUp(boolean isSwimmingUp) {
        this.swimmingUp = isSwimmingUp && this.container.getSwimAbility() == GolemContainer.SwimMode.SWIM;
    }

    public boolean isSwimmingUp() {
        if (this.container.getSwimAbility() != GolemContainer.SwimMode.SWIM) {
            return false;
        }
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.m_5448_();
        return e != null && e.m_20069_();
    }

    public static boolean isSwimmingUp(GolemBase golem) {
        return golem.swimmingUp;
    }

    public boolean shouldMoveToWater(Vec3 target) {
        return this.container.getSwimAbility() == GolemContainer.SwimMode.SWIM;
    }

    static class SwimmingMovementController
    extends MoveControl {
        private final GolemBase golem;

        public SwimmingMovementController(GolemBase golemIn) {
            super((Mob)golemIn);
            this.golem = golemIn;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.golem.m_5448_();
            if (this.golem.isSwimmingUp() && this.golem.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.golem.m_20186_() || this.golem.swimmingUp) {
                    this.golem.m_20256_(this.golem.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.golem.m_21573_().m_26571_()) {
                    this.golem.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.golem.m_20185_();
                double d1 = this.f_24976_ - this.golem.m_20186_();
                double d2 = this.f_24977_ - this.golem.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.golem.m_146922_(this.m_24991_(this.golem.m_146908_(), f, 90.0f));
                this.golem.f_20883_ = this.golem.m_146908_();
                float f1 = (float)(this.f_24978_ * this.golem.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.golem.m_6113_(), (float)f1);
                this.golem.m_7910_(f2);
                this.golem.m_20256_(this.golem.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.golem.f_19861_) {
                    this.golem.m_20256_(this.golem.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

