/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import com.mcmoddev.golems.entity.GolemBase;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class GoToWaterGoal
extends Goal {
    private final GolemBase golem;
    private final int detectWaterRadius;
    private double targetX;
    private double targetY;
    private double targetZ;
    private final double speed;
    private final Level world;

    public GoToWaterGoal(GolemBase golemBase, int radius, double speed) {
        this.golem = golemBase;
        this.detectWaterRadius = radius;
        this.speed = speed;
        this.world = golemBase.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.golem.m_20069_()) {
            return false;
        }
        Vec3 target = this.getNearbyWater();
        if (target == null || !this.golem.shouldMoveToWater(target)) {
            return false;
        }
        this.targetX = target.f_82479_;
        this.targetY = target.f_82480_;
        this.targetZ = target.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        return !this.golem.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.golem.m_21573_().m_26519_(this.targetX, this.targetY, this.targetZ, this.speed);
    }

    private Vec3 getNearbyWater() {
        Random rand = this.golem.m_21187_();
        BlockPos pos1 = this.golem.getBlockBelow();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos2 = pos1.m_142082_(rand.nextInt(this.detectWaterRadius * 2) - this.detectWaterRadius, 2 - rand.nextInt(8), rand.nextInt(this.detectWaterRadius * 2) - this.detectWaterRadius);
            if (this.world.m_8055_(pos2).m_60734_() != Blocks.f_49990_) continue;
            return new Vec3((double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_());
        }
        return null;
    }
}

