/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.event;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.container.render.GolemRenderSettings;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.network.SGolemContainerPacket;
import com.mcmoddev.golems.network.SGolemModelPacket;
import com.mcmoddev.golems.network.SummonGolemCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class EGForgeEvents {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ExtraGolems.GOLEM_CONTAINERS);
        event.addListener(ExtraGolems.GOLEM_RENDER_SETTINGS);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ExtraGolems.GOLEM_CONTAINERS.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> ExtraGolems.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemContainerPacket((ResourceLocation)e.getKey(), (GolemContainer)c))));
            ExtraGolems.GOLEM_RENDER_SETTINGS.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> ExtraGolems.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemModelPacket((ResourceLocation)e.getKey(), (GolemRenderSettings)c))));
        }
    }

    @SubscribeEvent
    public static void onAddCommands(RegisterCommandsEvent event) {
        SummonGolemCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlacePumpkin(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && EGConfig.pumpkinBuildsGolems() && event.getPlacedBlock().m_60734_() == Blocks.f_50143_ && event.getWorld() instanceof Level) {
            GolemHeadBlock.trySpawnGolem(event.getEntity(), (Level)event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public static void onTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof Mob && event.getTarget() instanceof GolemBase) {
            Mob mob = (Mob)event.getEntityLiving();
            GolemBase target = (GolemBase)event.getTarget();
            if (target.getContainer().hasBehavior(GolemBehaviors.USE_FUEL) && !target.hasFuel()) {
                mob.m_6710_(null);
                mob.m_6703_(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Villager villager;
        VillagerData villagerdata;
        if (EGConfig.villagerSummonChance() > 0 && event.getEntityLiving() instanceof Villager && event.getEntityLiving().m_6142_() && !event.getEntityLiving().m_5803_() && event.getEntityLiving().f_19797_ % 50 == 0 && (villagerdata = (villager = (Villager)event.getEntityLiving()).m_7141_()) != null && !villager.m_6162_() && villagerdata.m_35571_() != VillagerProfession.f_35596_) {
            GolemBase golem;
            long time = villager.m_20193_().m_46467_();
            int minNumVillagers = 3;
            AABB aabb = villager.m_142469_().m_82400_(10.0);
            List nearbyVillagers = villager.m_20193_().m_6443_(Villager.class, aabb, v -> v.m_35392_(time) && v.m_6084_());
            List nearbyGolems = villager.m_20193_().m_45976_(IronGolem.class, aabb.m_82400_(10.0));
            if (nearbyVillagers.size() >= 3 && nearbyGolems.isEmpty() && villager.m_21187_().nextInt(100) < EGConfig.villagerSummonChance() && (golem = EGForgeEvents.summonGolem(villager)) != null) {
                ExtraGolems.LOGGER.debug("Villager summoned a entity! " + golem);
                nearbyVillagers.forEach(GolemSensor::m_26647_);
            }
        }
    }

    @Nullable
    private static GolemBase summonGolem(@Nonnull Villager villager) {
        ServerLevel world = (ServerLevel)villager.m_20193_();
        BlockPos blockpos = villager.m_142538_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos2;
            ResourceLocation typeName;
            Optional<GolemContainer> type;
            double d0 = world.f_46441_.nextInt(16) - 8;
            double d1 = world.f_46441_.nextInt(16) - 8;
            double d2 = 6.0;
            for (int j = 0; j >= -12; --j) {
                BlockPos blockpos1 = blockpos.m_142022_(d0, d2 + (double)j, d1);
                if (!world.m_46859_(blockpos1) && !world.m_8055_(blockpos1).m_60767_().m_76332_() || !world.m_8055_(blockpos1.m_7495_()).m_60767_().m_76337_()) continue;
                d2 += (double)j;
                break;
            }
            if (!(type = ExtraGolems.GOLEM_CONTAINERS.get(typeName = EGForgeEvents.getGolemToSpawn((Level)world, blockpos2 = blockpos.m_142022_(d0, d2, d1)))).isPresent()) continue;
            GolemBase golem = GolemBase.create((Level)world, typeName);
            if (golem.getTextureCount() > 0) {
                golem.randomizeTexture((Level)world, blockpos2);
            }
            if (golem.m_5545_((LevelAccessor)world, MobSpawnType.MOB_SUMMONED) && golem.m_6914_((LevelReader)world)) {
                golem.m_6034_(blockpos2.m_123341_(), blockpos2.m_123342_(), blockpos2.m_123343_());
                world.m_7967_((Entity)golem);
                golem.m_6518_((ServerLevelAccessor)world, world.m_6436_(blockpos2), MobSpawnType.MOB_SUMMONED, null, null);
                return golem;
            }
            golem.m_146870_();
        }
        return null;
    }

    @Nullable
    private static ResourceLocation getGolemToSpawn(Level world, BlockPos pos) {
        List<ResourceLocation> options = EGConfig.getVillagerGolems();
        ResourceLocation choice = options.isEmpty() ? null : options.get(world.m_5822_().nextInt(options.size()));
        return choice;
    }
}

