/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.ExtraGolems;
import java.nio.file.Path;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.resource.PathResourcePack;

public final class AddonLoader {
    public static final String QUARK = "quark";
    private static final String QUARK_PACK_NAME = "golems_addon_quark";
    public static final String MEKANISM = "mekanism";
    private static final String MEKANISM_PACK_NAME = "golems_addon_mekanism";
    public static final String TCONSTRUCT = "tconstruct";
    private static final String TCONSTRUCT_PACK_NAME = "golems_addon_tconstruct";
    public static final String BIOMESOPLENTY = "biomesoplenty";
    private static final String BIOMESOPLENTY_PACK_NAME = "golems_addon_biomesoplenty";
    private static boolean isQuarkLoaded;
    private static boolean isMekanismLoaded;
    private static boolean isTinkersLoaded;
    private static boolean isBiomesOPlentyLoaded;

    public static void init() {
        isQuarkLoaded = ModList.get().isLoaded(QUARK);
        isMekanismLoaded = ModList.get().isLoaded(MEKANISM);
        isTinkersLoaded = ModList.get().isLoaded(TCONSTRUCT);
        isBiomesOPlentyLoaded = ModList.get().isLoaded(BIOMESOPLENTY);
    }

    public static boolean isQuarkLoaded() {
        return isQuarkLoaded;
    }

    public static boolean isMekanismLoaded() {
        return isMekanismLoaded;
    }

    public static boolean isBiomesOPlentyLoaded() {
        return isBiomesOPlentyLoaded;
    }

    public static boolean isTinkersLoaded() {
        return isTinkersLoaded;
    }

    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            ExtraGolems.LOGGER.debug("golems: addPackFinders");
            if (AddonLoader.isQuarkLoaded()) {
                ExtraGolems.LOGGER.info("Extra Golems detected Quark, registering data pack now");
                AddonLoader.registerAddon(event, QUARK_PACK_NAME);
            }
            if (AddonLoader.isMekanismLoaded()) {
                ExtraGolems.LOGGER.info("Extra Golems detected Mekanism, registering data pack now");
                AddonLoader.registerAddon(event, MEKANISM_PACK_NAME);
            }
            if (AddonLoader.isTinkersLoaded()) {
                ExtraGolems.LOGGER.info("Extra Golems detected Tinkers Construct, registering data pack now");
                AddonLoader.registerAddon(event, TCONSTRUCT_PACK_NAME);
            }
            if (AddonLoader.isBiomesOPlentyLoaded()) {
                ExtraGolems.LOGGER.info("Extra Golems detected Biomes O Plenty, registering data pack now");
                AddonLoader.registerAddon(event, BIOMESOPLENTY_PACK_NAME);
            }
        }
    }

    private static void registerAddon(AddPackFindersEvent event, String packName) {
        event.addRepositorySource((packConsumer, constructor) -> {
            Pack pack = Pack.m_10430_((String)("golems:" + packName), (boolean)true, () -> {
                Path path = ModList.get().getModFileById("golems").getFile().findResource(new String[]{"/" + packName});
                return new PathResourcePack(packName, path);
            }, (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
            if (pack != null) {
                packConsumer.accept(pack);
            } else {
                ExtraGolems.LOGGER.error("golems: Failed to register data pack \"" + packName + "\"");
            }
        });
    }
}

