/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.network;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.GolemContainer;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SGolemContainerPacket {
    protected ResourceLocation key;
    protected GolemContainer golemContainer;

    public SGolemContainerPacket(ResourceLocation key, GolemContainer golemContainerIn) {
        this.key = key;
        this.golemContainer = golemContainerIn;
    }

    public static SGolemContainerPacket fromBytes(FriendlyByteBuf buf) {
        ResourceLocation sKey = buf.m_130281_();
        CompoundTag sNBT = buf.m_130260_();
        Optional sCont = ExtraGolems.GOLEM_CONTAINERS.readObject((Tag)sNBT).resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to read GolemContainer from NBT for packet\n" + error));
        return new SGolemContainerPacket(sKey, sCont.orElse(GolemContainer.EMPTY));
    }

    public static void toBytes(SGolemContainerPacket msg, FriendlyByteBuf buf) {
        DataResult<Tag> nbtResult = ExtraGolems.GOLEM_CONTAINERS.writeObject(msg.golemContainer);
        Tag tag = (Tag)nbtResult.resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to write GolemContainer to NBT for packet\n" + error)).get();
        buf.m_130085_(msg.key);
        buf.m_130079_((CompoundTag)tag);
    }

    public static void handlePacket(SGolemContainerPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> ExtraGolems.GOLEM_CONTAINERS.put(message.key, message.golemContainer));
        }
        context.setPacketHandled(true);
    }
}

