/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render;

import com.mcmoddev.golems.ExtraGolems;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class DynamicTextureState {
    public static final int TILES = 8;
    public ResourceLocation location;
    public ResourceLocation sourceImage;
    public ResourceLocation templateImage;
    public RenderStateShard.TextureStateShard state;
    public DynamicTexture texture;

    public DynamicTextureState(ResourceLocation id, ResourceLocation blockName, ResourceLocation templateName) {
        this.location = id;
        this.sourceImage = blockName;
        this.templateImage = templateName;
        try {
            Resource blockResource = Minecraft.m_91087_().m_91098_().m_142591_(blockName);
            Resource templateResource = Minecraft.m_91087_().m_91098_().m_142591_(templateName);
            NativeImage block = NativeImage.m_85058_((InputStream)blockResource.m_6679_());
            NativeImage template = NativeImage.m_85058_((InputStream)templateResource.m_6679_());
            int blockWidth = block.m_84982_();
            int outputWidth = 8 * blockWidth;
            int outputHeight = 8 * blockWidth;
            int templateWidth = template.m_84982_();
            int templateHeight = template.m_85084_();
            float scale = outputWidth / templateWidth;
            this.texture = new DynamicTexture(outputWidth, outputHeight, true);
            NativeImage outputImg = this.texture.m_117991_();
            for (int j = 0; j < outputHeight; ++j) {
                for (int i = 0; i < outputWidth; ++i) {
                    byte alpha = template.m_85087_((int)((float)i / scale) % templateWidth, (int)((float)j / scale) % templateHeight);
                    outputImg.m_84988_(i, j, block.m_84985_(i % blockWidth, j % blockWidth) & alpha);
                }
            }
        }
        catch (IOException e) {
            ExtraGolems.LOGGER.error("Error trying to make dynamic texture for " + blockName + " with template " + templateName);
            this.texture = new DynamicTexture(128, 128, true);
            this.texture.m_117991_().m_84997_(0, 0, 128, 128, -1);
            e.printStackTrace();
        }
        this.texture.m_117985_();
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        textureManager.m_118495_(this.location, (AbstractTexture)this.texture);
        this.state = new RenderStateShard.TextureStateShard(this.location, false, false);
    }
}

