/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class MultitextureSettings {
    public static final MultitextureSettings EMPTY = new MultitextureSettings(false, (Map<Integer, TextureEntry>)ImmutableMap.of());
    public static final Codec<MultitextureSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("cycle", (Object)false).forGetter(MultitextureSettings::canCycle), (App)Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, i -> Integer.toString(i)), TextureEntry.CODEC).fieldOf("textures").forGetter(MultitextureSettings::getTextureEntryMap)).apply((Applicative)instance, MultitextureSettings::new));
    private final int textureCount;
    private final boolean cycle;
    private final ImmutableMap<Integer, TextureEntry> entryMap;
    private final ImmutableMap<ResourcePair, Integer> blockMap;

    private MultitextureSettings(boolean cycle, Map<Integer, TextureEntry> entryMap) {
        this.textureCount = entryMap.size();
        this.cycle = cycle;
        this.entryMap = ImmutableMap.copyOf(entryMap);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.entryMap.forEach((num, entry) -> {
            if (num < 0 || num >= this.textureCount) {
                ExtraGolems.LOGGER.error("Error parsing MultiTextureSettings: 'textures' contains out of bounds texture ID '" + num + "' (max is " + (this.textureCount - 1) + ")");
            }
            entry.getBlocks().forEach(resource -> builder.put(resource, num));
        });
        this.blockMap = builder.build();
    }

    public int getTextureCount() {
        return this.textureCount;
    }

    public boolean canCycle() {
        return this.cycle;
    }

    public Map<Integer, TextureEntry> getTextureEntryMap() {
        return this.entryMap;
    }

    public TextureEntry getEntry(int textureId) {
        return (TextureEntry)this.entryMap.getOrDefault((Object)textureId, (Object)TextureEntry.EMPTY);
    }

    public Map<ResourcePair, Integer> getBlockMap() {
        return this.blockMap;
    }

    public int getLight(GolemBase entity) {
        return ((TextureEntry)this.entryMap.getOrDefault((Object)entity.getTextureId(), (Object)TextureEntry.EMPTY)).getLight();
    }

    public ResourceLocation getLootTable(GolemBase entity) {
        ResourceLocation fallback = entity.getMaterial();
        if (this.entryMap.containsKey((Object)entity.getTextureId())) {
            return ((TextureEntry)this.entryMap.get((Object)entity.getTextureId())).getLootTable().orElse(fallback);
        }
        return fallback;
    }

    public int getTextureFromBlock(Block block) {
        ResourcePair key = new ResourcePair(ForgeRegistries.BLOCKS.getKey((Object)block), false);
        if (this.getBlockMap().containsKey(key)) {
            return this.getBlockMap().get(key);
        }
        BlockState blockState = block.m_49966_();
        for (Map.Entry<ResourcePair, Integer> entry : this.getBlockMap().entrySet()) {
            if (!entry.getKey().flag() || !blockState.m_204336_(ForgeRegistries.BLOCKS.tags().createTagKey(entry.getKey().resource()))) continue;
            return entry.getValue();
        }
        return 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("MultitextureSettings: ");
        b.append("texture_count[").append(this.textureCount).append("] ");
        b.append("cycle[").append(this.cycle).append("] ");
        b.append("textures[").append(this.entryMap).append("] ");
        return b.toString();
    }

    public static class TextureEntry {
        public static final TextureEntry EMPTY = new TextureEntry((List<ResourcePair>)ImmutableList.of(), Optional.empty(), 0);
        public static final Codec<TextureEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(ResourcePair.CODEC, (Codec)ResourcePair.CODEC.listOf()).xmap(either -> (List)either.map(ImmutableList::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((ResourcePair)list.get(0))) : Either.right((Object)list)).optionalFieldOf("blocks", (Object)Lists.newArrayList()).forGetter(TextureEntry::getBlocks), (App)ResourceLocation.f_135803_.optionalFieldOf("loot_table").forGetter(TextureEntry::getLootTable), (App)Codec.INT.optionalFieldOf("glow", (Object)0).forGetter(TextureEntry::getLight)).apply((Applicative)instance, TextureEntry::new));
        private final List<ResourcePair> blocks;
        private final Optional<ResourceLocation> lootTable;
        private final int light;

        private TextureEntry(List<ResourcePair> blocks, Optional<ResourceLocation> lootTable, int light) {
            this.blocks = blocks;
            this.lootTable = lootTable;
            this.light = light;
        }

        public List<ResourcePair> getBlocks() {
            return this.blocks;
        }

        public Optional<ResourceLocation> getLootTable() {
            return this.lootTable;
        }

        public int getLight() {
            return this.light;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("TextureEntry: ");
            b.append("block[").append(this.blocks).append("] ");
            b.append("loot_table[").append(this.lootTable).append("] ");
            b.append("light[").append(this.light).append("] ");
            return b.toString();
        }
    }
}

