/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.mcmoddev.golems.container.behavior.AoeDryBehavior;
import com.mcmoddev.golems.container.behavior.AoeFreezeBehavior;
import com.mcmoddev.golems.container.behavior.AoeGrowBehavior;
import com.mcmoddev.golems.container.behavior.BurnInSunBehavior;
import com.mcmoddev.golems.container.behavior.ChangeMaterialBehavior;
import com.mcmoddev.golems.container.behavior.ChangeTextureBehavior;
import com.mcmoddev.golems.container.behavior.CraftingMenuBehavior;
import com.mcmoddev.golems.container.behavior.ExplodeBehavior;
import com.mcmoddev.golems.container.behavior.FollowBehavior;
import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.OnActuallyHurtBehavior;
import com.mcmoddev.golems.container.behavior.OnHurtTargetBehavior;
import com.mcmoddev.golems.container.behavior.PassiveEffectBehavior;
import com.mcmoddev.golems.container.behavior.PlaceBlocksBehavior;
import com.mcmoddev.golems.container.behavior.ShootArrowsBehavior;
import com.mcmoddev.golems.container.behavior.SplitBehavior;
import com.mcmoddev.golems.container.behavior.TeleportBehavior;
import com.mcmoddev.golems.container.behavior.TemptBehavior;
import com.mcmoddev.golems.container.behavior.UseFuelBehavior;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class GolemBehaviors {
    public static final Map<ResourceLocation, Function<CompoundTag, ? extends GolemBehavior>> BEHAVIORS = new HashMap<ResourceLocation, Function<CompoundTag, ? extends GolemBehavior>>();
    public static final Map<ResourceLocation, Class<? extends GolemBehavior>> CLASS_MAP = new HashMap<ResourceLocation, Class<? extends GolemBehavior>>();
    public static final ResourceLocation AOE_DRY = GolemBehaviors.register("aoe_dry", AoeDryBehavior.class, AoeDryBehavior::new);
    public static final ResourceLocation AOE_FREEZE = GolemBehaviors.register("aoe_freeze", AoeFreezeBehavior.class, AoeFreezeBehavior::new);
    public static final ResourceLocation AOE_GROW = GolemBehaviors.register("aoe_grow", AoeGrowBehavior.class, AoeGrowBehavior::new);
    public static final ResourceLocation BURN_IN_SUN = GolemBehaviors.register("burn_in_sun", BurnInSunBehavior.class, BurnInSunBehavior::new);
    public static final ResourceLocation CHANGE_TEXTURE = GolemBehaviors.register("change_texture", ChangeTextureBehavior.class, ChangeTextureBehavior::new);
    public static final ResourceLocation CHANGE_MATERIAL = GolemBehaviors.register("change_material", ChangeMaterialBehavior.class, ChangeMaterialBehavior::new);
    public static final ResourceLocation CRAFTING_MENU = GolemBehaviors.register("crafting_menu", CraftingMenuBehavior.class, CraftingMenuBehavior::new);
    public static final ResourceLocation EXPLODE = GolemBehaviors.register("explode", ExplodeBehavior.class, ExplodeBehavior::new);
    public static final ResourceLocation FOLLOW = GolemBehaviors.register("follow", FollowBehavior.class, FollowBehavior::new);
    public static final ResourceLocation ON_ACTUALLY_HURT = GolemBehaviors.register("hurt", OnActuallyHurtBehavior.class, OnActuallyHurtBehavior::new);
    public static final ResourceLocation ON_HURT_TARGET = GolemBehaviors.register("attack", OnHurtTargetBehavior.class, OnHurtTargetBehavior::new);
    public static final ResourceLocation PLACE_BLOCKS = GolemBehaviors.register("place_blocks", PlaceBlocksBehavior.class, PlaceBlocksBehavior::new);
    public static final ResourceLocation PASSIVE_EFFECT = GolemBehaviors.register("passive_effect", PassiveEffectBehavior.class, PassiveEffectBehavior::new);
    public static final ResourceLocation SHOOT_ARROWS = GolemBehaviors.register("shoot_arrows", ShootArrowsBehavior.class, ShootArrowsBehavior::new);
    public static final ResourceLocation SPLIT_ON_DEATH = GolemBehaviors.register("split_on_death", SplitBehavior.class, SplitBehavior::new);
    public static final ResourceLocation TELEPORT = GolemBehaviors.register("teleport", TeleportBehavior.class, TeleportBehavior::new);
    public static final ResourceLocation TEMPT = GolemBehaviors.register("tempt", TemptBehavior.class, TemptBehavior::new);
    public static final ResourceLocation USE_FUEL = GolemBehaviors.register("use_fuel", UseFuelBehavior.class, UseFuelBehavior::new);

    private GolemBehaviors() {
    }

    public static void init() {
    }

    public static Optional<? extends GolemBehavior> create(ResourceLocation name, CompoundTag tag) {
        if (BEHAVIORS.containsKey(name)) {
            return Optional.of(BEHAVIORS.get(name).apply(tag));
        }
        return Optional.empty();
    }

    private static <T extends GolemBehavior> ResourceLocation register(String name, Class<T> clazz, Function<CompoundTag, T> function) {
        ResourceLocation id = new ResourceLocation("golems", name);
        BEHAVIORS.put(id, function);
        CLASS_MAP.put(id, clazz);
        return id;
    }
}

