/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior.parameter;

import com.mcmoddev.golems.container.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

@Immutable
public class FireBehaviorParameter
extends BehaviorParameter {
    private final BehaviorParameter.Target target;
    private final double chance;
    private final double range;
    private final int time;

    public FireBehaviorParameter(CompoundTag tag) {
        this.target = BehaviorParameter.Target.getByName(tag.m_128461_("target"));
        this.chance = tag.m_128459_("chance");
        this.time = tag.m_128451_("time");
        this.range = tag.m_128459_("range");
    }

    public BehaviorParameter.Target getTarget() {
        return this.target;
    }

    public double getChance() {
        return this.chance;
    }

    public double getRange() {
        return this.range;
    }

    public int getTime() {
        return this.time;
    }

    public void apply(GolemBase self, Entity other) {
        if ((double)self.m_217043_().m_188501_() < this.chance) {
            switch (this.target) {
                case AREA: {
                    double inflate = this.range > 0.0 ? this.range : 2.0;
                    TargetingConditions condition = TargetingConditions.m_148353_().m_148355_().m_26893_();
                    List targets = self.f_19853_.m_45971_(LivingEntity.class, condition, (LivingEntity)self, self.m_20191_().m_82400_(inflate));
                    for (LivingEntity target : targets) {
                        target.m_20254_(this.time);
                    }
                    break;
                }
                case ENEMY: {
                    if (other == null) break;
                    other.m_20254_(this.time);
                    break;
                }
                case SELF: {
                    self.m_20254_(this.time);
                }
            }
        }
    }
}

