/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.container.AttributeSettings;
import com.mcmoddev.golems.container.MultitextureSettings;
import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.GolemBehaviors;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

public final class GolemContainer {
    public static final ResourceLocation EMPTY_MATERIAL = new ResourceLocation("golems", "clay");
    public static final GolemContainer EMPTY = new GolemContainer(AttributeSettings.EMPTY, SwimMode.SINK, 0, 0, true, SoundEvents.f_12450_, Optional.empty(), (List<ResourcePair>)ImmutableList.of((Object)new ResourcePair(ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50016_), false)), (Map<ResourcePair, Double>)ImmutableMap.of(), Optional.empty(), (List<CompoundTag>)ImmutableList.of());
    public static final Codec<GolemContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AttributeSettings.CODEC.fieldOf("attributes").forGetter(GolemContainer::getAttributes), (App)SwimMode.CODEC.optionalFieldOf("swim_ability", (Object)SwimMode.SINK).forGetter(GolemContainer::getSwimAbility), (App)Codec.INT.optionalFieldOf("glow", (Object)0).forGetter(GolemContainer::getMaxLightLevel), (App)Codec.INT.optionalFieldOf("power", (Object)0).forGetter(GolemContainer::getMaxPowerLevel), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(GolemContainer::isHidden), (App)SoundEvent.f_11655_.optionalFieldOf("sound", (Object)SoundEvents.f_12450_).forGetter(GolemContainer::getSound), (App)ParticleTypes.f_123791_.optionalFieldOf("particle").forGetter(GolemContainer::getParticle), (App)Codec.either(ResourcePair.CODEC, (Codec)ResourcePair.CODEC.listOf()).xmap(either -> (List)either.map(ImmutableList::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((ResourcePair)list.get(0))) : Either.right((Object)list)).optionalFieldOf("blocks", (Object)Lists.newArrayList()).forGetter(GolemContainer::getBlocksRaw), (App)Codec.unboundedMap(ResourcePair.CODEC, (Codec)Codec.DOUBLE).optionalFieldOf("heal_items", (Object)Maps.newHashMap()).forGetter(GolemContainer::getHealItemsRaw), (App)MultitextureSettings.CODEC.optionalFieldOf("multitexture").forGetter(GolemContainer::getMultitexture), (App)CompoundTag.f_128325_.listOf().optionalFieldOf("behavior", (Object)Lists.newArrayList((Object[])new CompoundTag[]{new CompoundTag()})).forGetter(GolemContainer::getBehaviorsRaw)).apply((Applicative)instance, GolemContainer::new));
    private final AttributeSettings attributes;
    private final SwimMode swimAbility;
    private final int glow;
    private final int power;
    private final boolean hidden;
    private final SoundEvent sound;
    private final Optional<ParticleOptions> particle;
    private final List<ResourcePair> blocksRaw;
    private final ImmutableSet<ResourceLocation> blocks;
    private final ImmutableSet<ResourceLocation> blockTags;
    private final Map<ResourcePair, Double> healItemsRaw;
    private final ImmutableMap<ResourceLocation, Double> healItems;
    private final ImmutableMap<ResourceLocation, Double> healItemTags;
    private final List<CompoundTag> behaviorsRaw;
    private final ImmutableMap<ResourceLocation, ImmutableList<GolemBehavior>> behaviors;
    private final Optional<MultitextureSettings> multitexture;
    private final ImmutableList<Component> descriptions;

    private GolemContainer(AttributeSettings attributes, SwimMode swimAbility, int glow, int power, boolean hidden, SoundEvent sound, Optional<ParticleOptions> particle, List<ResourcePair> blocksRaw, Map<ResourcePair, Double> healItemsRaw, Optional<MultitextureSettings> multitexture, List<CompoundTag> goalsRaw) {
        this.attributes = attributes;
        this.swimAbility = swimAbility;
        this.glow = glow;
        this.power = power;
        this.hidden = hidden;
        this.sound = sound;
        this.particle = particle;
        this.blocksRaw = blocksRaw;
        this.healItemsRaw = healItemsRaw;
        this.multitexture = multitexture;
        this.behaviorsRaw = goalsRaw;
        ImmutableSet.Builder bblocks = ImmutableSet.builder();
        ImmutableSet.Builder bblockTags = ImmutableSet.builder();
        if (this.multitexture.isPresent()) {
            this.multitexture.get().getBlockMap().keySet().forEach(pair -> {
                if (pair.flag()) {
                    bblockTags.add((Object)pair.resource());
                } else {
                    bblocks.add((Object)pair.resource());
                }
            });
        } else {
            this.blocksRaw.forEach(pair -> {
                if (pair.flag()) {
                    bblockTags.add((Object)pair.resource());
                } else {
                    bblocks.add((Object)pair.resource());
                }
            });
        }
        this.blocks = bblocks.build();
        this.blockTags = bblockTags.build();
        ImmutableMap.Builder bhealItems = ImmutableMap.builder();
        ImmutableMap.Builder bhealItemTags = ImmutableMap.builder();
        this.healItemsRaw.forEach((s, d) -> {
            if (s.flag()) {
                bhealItemTags.put((Object)s.resource(), d);
            } else {
                bhealItems.put((Object)s.resource(), d);
            }
        });
        this.healItems = bhealItems.build();
        this.healItemTags = bhealItemTags.build();
        HashMap<ResourceLocation, List> bbehaviors = new HashMap<ResourceLocation, List>();
        for (CompoundTag goalTag : goalsRaw) {
            if (!goalTag.m_128425_("type", 8)) continue;
            ResourceLocation goalId = new ResourceLocation(goalTag.m_128461_("type"));
            Optional<? extends GolemBehavior> behavior = GolemBehaviors.create(goalId, goalTag);
            if (behavior.isPresent()) {
                bbehaviors.putIfAbsent(goalId, Lists.newArrayList());
                ((List)bbehaviors.get(goalId)).add(behavior.get());
                continue;
            }
            ExtraGolems.LOGGER.warn("GolemContainer: behavior '" + goalId + "' does not exist!");
        }
        ImmutableMap.Builder bbehaviors2 = ImmutableMap.builder();
        bbehaviors.forEach((id, list) -> bbehaviors2.put(id, (Object)ImmutableList.copyOf((Collection)list)));
        this.behaviors = bbehaviors2.build();
        this.descriptions = ImmutableList.copyOf(this.createDescriptions());
    }

    public AttributeSettings getAttributes() {
        return this.attributes;
    }

    public SwimMode getSwimAbility() {
        return this.swimAbility;
    }

    public boolean canSwim() {
        return this.swimAbility == SwimMode.FLOAT;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public Optional<ParticleOptions> getParticle() {
        return this.particle;
    }

    private List<ResourcePair> getBlocksRaw() {
        return this.blocksRaw;
    }

    public ImmutableSet<ResourceLocation> getBlocks() {
        return this.blocks;
    }

    public ImmutableSet<ResourceLocation> getBlockTags() {
        return this.blockTags;
    }

    private Map<ResourcePair, Double> getHealItemsRaw() {
        return this.healItemsRaw;
    }

    public ImmutableMap<ResourceLocation, Double> getHealItems() {
        return this.healItems;
    }

    public ImmutableMap<ResourceLocation, Double> getHealItemTags() {
        return this.healItemTags;
    }

    private List<CompoundTag> getBehaviorsRaw() {
        return this.behaviorsRaw;
    }

    public ImmutableMap<ResourceLocation, ImmutableList<GolemBehavior>> getBehaviors() {
        return this.behaviors;
    }

    public Optional<MultitextureSettings> getMultitexture() {
        return this.multitexture;
    }

    public int getMaxLightLevel() {
        return this.glow;
    }

    public int getMaxPowerLevel() {
        return this.power;
    }

    public ImmutableList<Component> getDescriptions() {
        return this.descriptions;
    }

    public ResourceLocation getLootTable(GolemBase entity) {
        ResourceLocation lootTable = entity.getMaterial();
        if (this.multitexture.isPresent()) {
            lootTable = this.multitexture.get().getLootTable(entity);
        }
        return new ResourceLocation(lootTable.m_135827_(), "entities/golem/" + lootTable.m_135815_());
    }

    public boolean hasBlocks() {
        if (this.blocks.size() > 0) {
            return true;
        }
        for (ResourceLocation tagId : this.blockTags) {
            ITag tag = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)tagId));
            if (tag.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public Set<Block> getAllBlocks() {
        return GolemContainer.getAllBlocks(this.blocks, this.blockTags);
    }

    public boolean matches(Block body, Block legs, Block arm1, Block arm2) {
        Set<Block> blocks = this.getAllBlocks();
        return blocks.contains(body) && blocks.contains(legs) && blocks.contains(arm1) && blocks.contains(arm2);
    }

    public double getHealAmount(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (this.healItems.containsKey((Object)id)) {
            return (Double)this.healItems.get((Object)id);
        }
        for (Map.Entry entry : this.healItemTags.entrySet()) {
            ITag tag = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)((ResourceLocation)entry.getKey())));
            if (!tag.contains((Object)item)) continue;
            return (Double)entry.getValue();
        }
        return 0.0;
    }

    public boolean hasBehavior(ResourceLocation name) {
        return !((ImmutableList)this.getBehaviors().getOrDefault((Object)name, (Object)ImmutableList.of())).isEmpty();
    }

    public <T extends GolemBehavior> List<T> getBehaviors(ResourceLocation name) {
        List behaviorList = (List)this.behaviors.get((Object)name);
        if (!behaviorList.isEmpty() && ((GolemBehavior)behaviorList.get(0)).getClass().isAssignableFrom(GolemBehaviors.CLASS_MAP.get(name))) {
            return behaviorList;
        }
        return ImmutableList.of();
    }

    public Supplier<AttributeSupplier.Builder> getAttributeSupplier() {
        return () -> GolemBase.m_21552_().m_22268_(Attributes.f_22276_, this.attributes.getHealth()).m_22268_(Attributes.f_22279_, this.attributes.getSpeed()).m_22268_(Attributes.f_22278_, this.attributes.getKnockbackResist()).m_22268_(Attributes.f_22282_, this.attributes.getAttackKnockback()).m_22268_(Attributes.f_22284_, this.attributes.getArmor()).m_22268_(Attributes.f_22281_, this.attributes.getAttack());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("GolemContainer: ");
        b.append("attributes[").append(this.attributes).append("] ");
        b.append("swim_ability[").append((Object)this.swimAbility).append("] ");
        b.append("hidden[").append(this.hidden).append("] ");
        b.append("sound[").append(this.sound.m_11660_()).append("] ");
        b.append("particle[").append(this.particle).append("] ");
        b.append("blocks[").append(this.blocksRaw).append("] ");
        b.append("healItems[").append(this.healItemsRaw).append("] ");
        b.append("behavior[").append(this.behaviors).append("] ");
        b.append("multitexture[").append(this.multitexture).append("] ");
        return b.toString();
    }

    public static Set<Block> getAllBlocks(Collection<ResourceLocation> blocks, Collection<ResourceLocation> blockTags) {
        HashSet<Block> all = new HashSet<Block>();
        for (ResourceLocation blockId : blocks) {
            Block tmpBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
            if (tmpBlock == null) continue;
            all.add(tmpBlock);
        }
        for (ResourceLocation tagId : blockTags) {
            ITag tag = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)tagId));
            all.addAll(tag.stream().toList());
        }
        return all;
    }

    private List<Component> createDescriptions() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.attributes.hasFireImmunity()) {
            list.add((Component)Component.m_237115_((String)"enchantment.minecraft.fire_protection").m_130940_(ChatFormatting.GOLD));
        }
        if (this.attributes.hasExplosionImmunity()) {
            list.add((Component)Component.m_237115_((String)"enchantment.minecraft.blast_protection").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
        }
        if (this.glow > 0) {
            list.add((Component)Component.m_237115_((String)"entitytip.provides_light").m_130940_(ChatFormatting.RED));
        }
        if (this.power > 0) {
            list.add((Component)Component.m_237115_((String)"entitytip.provides_power").m_130940_(ChatFormatting.RED));
        }
        if (this.attributes.getAttackKnockback() > 0.39) {
            list.add((Component)Component.m_237115_((String)"entitytip.has_knockback").m_130940_(ChatFormatting.DARK_RED));
        }
        if (this.multitexture.isPresent() && this.multitexture.get().canCycle()) {
            list.add((Component)Component.m_237115_((String)"entitytip.click_change_texture").m_130940_(ChatFormatting.BLUE));
        }
        if (this.swimAbility == SwimMode.SWIM) {
            list.add((Component)Component.m_237115_((String)"entitytip.advanced_swim").m_130940_(ChatFormatting.DARK_AQUA));
        }
        this.behaviors.values().forEach(l -> l.forEach(b -> b.onAddDescriptions(list)));
        return list;
    }

    public static enum SwimMode implements StringRepresentable
    {
        SINK("sink"),
        FLOAT("float"),
        SWIM("swim");

        private static final Map<String, SwimMode> valueMap;
        public static final Codec<SwimMode> CODEC;
        private final String name;

        private SwimMode(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }

        public static SwimMode getByName(String nameIn) {
            return valueMap.getOrDefault(nameIn, SINK);
        }

        static {
            valueMap = new HashMap<String, SwimMode>();
            for (SwimMode t : SwimMode.values()) {
                valueMap.put(t.m_7912_(), t);
            }
            CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)((Object)SwimMode.getByName(s))), SwimMode::m_7912_).stable();
        }
    }
}

