/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.container.behavior;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.container.behavior.GolemBehavior;
import com.mcmoddev.golems.container.behavior.parameter.ChangeMaterialBehaviorParameter;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.ChangeMaterialGoal;
import com.mcmoddev.golems.util.ResourcePair;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

@Immutable
public class ChangeMaterialBehavior
extends GolemBehavior {
    private final ChangeMaterialBehaviorParameter tickMaterial;
    private final ChangeMaterialBehaviorParameter wetMaterial;
    private final ChangeMaterialBehaviorParameter dryMaterial;
    private final ChangeMaterialBehaviorParameter fueledMaterial;
    private final ChangeMaterialBehaviorParameter emptyMaterial;
    private final Map<ResourcePair, ChangeMaterialBehaviorParameter> itemParameters;

    public ChangeMaterialBehavior(CompoundTag tag) {
        super(tag);
        this.tickMaterial = tag.m_128441_("tick") ? new ChangeMaterialBehaviorParameter(tag.m_128469_("tick")) : null;
        this.wetMaterial = tag.m_128441_("wet") ? new ChangeMaterialBehaviorParameter(tag.m_128469_("wet")) : null;
        this.dryMaterial = tag.m_128441_("dry") ? new ChangeMaterialBehaviorParameter(tag.m_128469_("dry")) : null;
        this.fueledMaterial = tag.m_128441_("fuel") ? new ChangeMaterialBehaviorParameter(tag.m_128469_("fuel")) : null;
        this.emptyMaterial = tag.m_128441_("fuel_empty") ? new ChangeMaterialBehaviorParameter(tag.m_128469_("fuel_empty")) : null;
        this.itemParameters = ImmutableMap.copyOf(ChangeMaterialBehavior.readParameters(tag.m_128469_("items"), ChangeMaterialBehaviorParameter::new));
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.f_21345_.m_25352_(1, new ChangeMaterialGoal<GolemBase>(entity, this.tickMaterial, this.wetMaterial, this.dryMaterial, this.fueledMaterial, this.emptyMaterial));
    }

    @Override
    public void onMobInteract(GolemBase entity, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        ResourcePair itemId = new ResourcePair(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()), false);
        if (this.itemParameters.containsKey(itemId) && this.apply(entity, player, hand, this.itemParameters.get(itemId))) {
            return;
        }
        for (Map.Entry<ResourcePair, ChangeMaterialBehaviorParameter> entry : this.itemParameters.entrySet()) {
            TagKey tagKey;
            if (!entry.getKey().flag() || !item.m_204117_(tagKey = ForgeRegistries.ITEMS.tags().createTagKey(entry.getKey().resource())) || !this.apply(entity, player, hand, entry.getValue())) continue;
            return;
        }
    }

    private boolean apply(GolemBase entity, Player player, InteractionHand hand, ChangeMaterialBehaviorParameter behaviorParameter) {
        if ((double)entity.m_217043_().m_188501_() < behaviorParameter.getChance()) {
            entity.setMaterial(behaviorParameter.getMaterial());
            ChangeMaterialBehavior.sendParticles((Entity)entity, (ParticleOptions)ParticleTypes.f_123751_, 12);
            player.m_6674_(hand);
            return true;
        }
        return false;
    }
}

